/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientPrimaryReplicaTracker;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.lang.NodeStoppingException;

public class ClientTablePartitionPrimaryReplicasGetRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, ClientPrimaryReplicaTracker tracker) throws NodeStoppingException {
        int tableId = in.unpackInt();
        long timestamp = in.unpackLong();
        return tracker.primaryReplicasAsync(tableId, timestamp).thenApply(primaryReplicas -> out -> {
            assert (primaryReplicas != null) : "Primary replicas == null";
            List<String> nodeNames = primaryReplicas.nodeNames();
            if (nodeNames == null) {
                out.packInt(primaryReplicas.partitions());
                out.packBoolean(false);
            } else {
                out.packInt(nodeNames.size());
                out.packBoolean(true);
                out.packLong(primaryReplicas.timestamp());
                for (String nodeName : nodeNames) {
                    out.packString(nodeName);
                }
            }
        });
    }
}

