/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

class SetFieldBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;
    private final BytecodeExpression value;
    private final ParameterizedType fieldType;

    SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Class<?> declaringClass, String name, BytecodeExpression value) {
        this(instance, SetFieldBytecodeExpression.getDeclaredField(declaringClass, name), value);
    }

    SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Field field, BytecodeExpression value) {
        this(instance, ParameterizedType.type(Objects.requireNonNull(field, "field is null").getDeclaringClass()), field.getName(), value, ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            BytecodeUtils.checkArgument(isStatic, "Field is not static: %s", field);
        } else {
            BytecodeUtils.checkArgument(!isStatic, "Field is static: %s", field);
        }
    }

    SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, FieldDefinition field, BytecodeExpression value) {
        this(instance, Objects.requireNonNull(field, "field is null").getDeclaringClass().getType(), field.getName(), value, field.getType());
        if (instance == null) {
            BytecodeUtils.checkArgument(field.getAccess().contains((Object)Access.STATIC), "Field is not static: %s", field);
        } else {
            BytecodeUtils.checkArgument(!field.getAccess().contains((Object)Access.STATIC), "Field is static: %s", field);
        }
    }

    SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType declaringClass, String name, BytecodeExpression value) {
        this(instance, declaringClass, name, value, value.getType());
    }

    SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType declaringClass, String name, BytecodeExpression value, ParameterizedType fieldType) {
        super(ParameterizedType.type(Void.TYPE));
        if (instance != null) {
            BytecodeUtils.checkArgument(!instance.getType().isPrimitive(), "Type %s does not have fields", instance.getType());
        }
        this.instance = instance;
        this.declaringClass = Objects.requireNonNull(declaringClass, "declaringClass is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        if (this.instance == null) {
            return new BytecodeBlock().append(this.value.getBytecode(generationContext)).putStaticField(this.declaringClass, this.name, this.fieldType);
        }
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.value.getBytecode(generationContext)).putField(this.declaringClass, this.name, this.fieldType);
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name + " = " + String.valueOf(this.value);
        }
        return String.valueOf(this.instance) + "." + this.name + " = " + String.valueOf(this.value);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return this.instance != null ? List.of(this.instance, this.value) : List.of(this.value);
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Objects.requireNonNull(declaringClass, "declaringClass is null");
        Objects.requireNonNull(name, "name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

