/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowUpgrader;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.distributed.gc.GcUpdateHandler;
import org.apache.ignite.internal.table.distributed.gc.MvGc;
import org.apache.ignite.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite.internal.table.distributed.raft.snapshot.FullStateTransferIndexChooser;
import org.apache.ignite.internal.table.distributed.raft.snapshot.IndexIdAndBinaryRow;
import org.apache.ignite.internal.table.distributed.raft.snapshot.IndexIdAndTableVersion;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.table.distributed.raft.snapshot.RaftSnapshotPartitionMeta;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class PartitionAccessImpl
implements PartitionAccess {
    private final PartitionKey partitionKey;
    private final MvTableStorage mvTableStorage;
    private final TxStateTableStorage txStateTableStorage;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();
    private final MvGc mvGc;
    private final IndexUpdateHandler indexUpdateHandler;
    private final GcUpdateHandler gcUpdateHandler;
    private final FullStateTransferIndexChooser fullStateTransferIndexChooser;
    private final SchemaRegistry schemaRegistry;
    private final LowWatermark lowWatermark;

    public PartitionAccessImpl(PartitionKey partitionKey, MvTableStorage mvTableStorage, TxStateTableStorage txStateTableStorage, MvGc mvGc, IndexUpdateHandler indexUpdateHandler, GcUpdateHandler gcUpdateHandler, FullStateTransferIndexChooser fullStateTransferIndexChooser, SchemaRegistry schemaRegistry, LowWatermark lowWatermark) {
        this.partitionKey = partitionKey;
        this.mvTableStorage = mvTableStorage;
        this.txStateTableStorage = txStateTableStorage;
        this.mvGc = mvGc;
        this.indexUpdateHandler = indexUpdateHandler;
        this.gcUpdateHandler = gcUpdateHandler;
        this.fullStateTransferIndexChooser = fullStateTransferIndexChooser;
        this.schemaRegistry = schemaRegistry;
        this.lowWatermark = lowWatermark;
    }

    @Override
    public PartitionKey partitionKey() {
        return this.partitionKey;
    }

    private int partitionId() {
        return this.partitionKey.partitionId();
    }

    private int tableId() {
        return this.mvTableStorage.getTableDescriptor().getId();
    }

    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> getAllTxMeta() {
        return this.getTxStateStorage().scan();
    }

    @Override
    public void addTxMeta(UUID txId, TxMeta txMeta) {
        this.getTxStateStorage().putForRebalance(txId, txMeta);
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) {
        return this.getMvPartitionStorage().closestRowId(lowerBound);
    }

    @Override
    public List<ReadResult> getAllRowVersions(RowId rowId) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        return (List)mvPartitionStorage.runConsistently(locker -> {
            locker.lock(rowId);
            try (Cursor cursor = mvPartitionStorage.scanVersions(rowId);){
                List list = cursor.stream().collect(Collectors.toList());
                return list;
            }
        });
    }

    @Override
    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        byte[] configBytes = this.getMvPartitionStorage().committedGroupConfiguration();
        return this.raftGroupConfigurationConverter.fromBytes(configBytes);
    }

    @Override
    public void addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId, int catalogVersion) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        List<IndexIdAndTableVersion> indexIdAndTableVersionList = this.fullStateTransferIndexChooser.chooseForAddWrite(catalogVersion, this.tableId(), TransactionIds.beginTimestamp((UUID)txId));
        List<IndexIdAndBinaryRow> indexIdAndBinaryRowList = this.upgradeForEachTableVersion(row, indexIdAndTableVersionList);
        mvPartitionStorage.runConsistently(locker -> {
            locker.lock(rowId);
            mvPartitionStorage.addWrite(rowId, row, txId, commitTableId, commitPartitionId);
            for (IndexIdAndBinaryRow indexIdAndBinaryRow : indexIdAndBinaryRowList) {
                this.indexUpdateHandler.addToIndex(indexIdAndBinaryRow.binaryRow(), rowId, indexIdAndBinaryRow.indexId());
            }
            return null;
        });
    }

    @Override
    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp, int catalogVersion) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        List<IndexIdAndTableVersion> indexIdAndTableVersionList = this.fullStateTransferIndexChooser.chooseForAddWriteCommitted(catalogVersion, this.tableId(), commitTimestamp);
        List<IndexIdAndBinaryRow> indexIdAndBinaryRowList = this.upgradeForEachTableVersion(row, indexIdAndTableVersionList);
        mvPartitionStorage.runConsistently(locker -> {
            locker.lock(rowId);
            mvPartitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
            for (IndexIdAndBinaryRow indexIdAndBinaryRow : indexIdAndBinaryRowList) {
                this.indexUpdateHandler.addToIndex(indexIdAndBinaryRow.binaryRow(), rowId, indexIdAndBinaryRow.indexId());
            }
            return null;
        });
    }

    @Override
    public long minLastAppliedIndex() {
        return Math.min(this.getMvPartitionStorage().lastAppliedIndex(), this.getTxStateStorage().lastAppliedIndex());
    }

    @Override
    public long minLastAppliedTerm() {
        return Math.min(this.getMvPartitionStorage().lastAppliedTerm(), this.getTxStateStorage().lastAppliedTerm());
    }

    @Override
    public long maxLastAppliedIndex() {
        return Math.max(this.getMvPartitionStorage().lastAppliedIndex(), this.getTxStateStorage().lastAppliedIndex());
    }

    @Override
    public long maxLastAppliedTerm() {
        return Math.max(this.getMvPartitionStorage().lastAppliedTerm(), this.getTxStateStorage().lastAppliedTerm());
    }

    @Override
    public long leaseStartTime() {
        return this.getMvPartitionStorage().leaseStartTime();
    }

    @Override
    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.getMvPartitionStorage().primaryReplicaNodeId();
    }

    @Override
    @Nullable
    public String primaryReplicaNodeName() {
        return this.getMvPartitionStorage().primaryReplicaNodeName();
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        TxStateStorage txStateStorage = this.getTxStateStorage();
        return this.mvGc.removeStorage(PartitionAccessImpl.toTablePartitionId(this.partitionKey)).thenCompose(unused -> CompletableFuture.allOf(this.mvTableStorage.startRebalancePartition(this.partitionId()), txStateStorage.startRebalance()));
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        TxStateStorage txStateStorage = this.getTxStateStorage();
        return CompletableFuture.allOf(this.mvTableStorage.abortRebalancePartition(this.partitionId()), txStateStorage.abortRebalance()).thenAccept(unused -> this.mvGc.addStorage(PartitionAccessImpl.toTablePartitionId(this.partitionKey), this.gcUpdateHandler));
    }

    @Override
    public CompletableFuture<Void> finishRebalance(RaftSnapshotPartitionMeta partitionMeta) {
        TxStateStorage txStateStorage = this.getTxStateStorage();
        byte[] configBytes = this.raftGroupConfigurationConverter.toBytes(partitionMeta.raftGroupConfig());
        return CompletableFuture.allOf(this.mvTableStorage.finishRebalancePartition(this.partitionId(), partitionMeta.toMvPartitionMeta(configBytes)), txStateStorage.finishRebalance(partitionMeta.lastAppliedIndex(), partitionMeta.lastAppliedTerm())).thenAccept(unused -> this.mvGc.addStorage(PartitionAccessImpl.toTablePartitionId(this.partitionKey), this.gcUpdateHandler));
    }

    @Override
    @Nullable
    public RowId getNextRowIdToBuildIndex(int indexId) {
        return this.indexUpdateHandler.getNextRowIdToBuildIndex(indexId);
    }

    @Override
    public void setNextRowIdToBuildIndex(Map<Integer, RowId> nextRowIdToBuildByIndexId) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        mvPartitionStorage.runConsistently(locker -> {
            nextRowIdToBuildByIndexId.forEach(this.indexUpdateHandler::setNextRowIdToBuildIndex);
            return null;
        });
    }

    @Override
    public void updateLowWatermark(HybridTimestamp newLowWatermark) {
        this.lowWatermark.updateLowWatermark(newLowWatermark);
    }

    private MvPartitionStorage getMvPartitionStorage() {
        int partitionId = this.partitionId();
        MvPartitionStorage mvPartitionStorage = this.mvTableStorage.getMvPartition(partitionId);
        assert (mvPartitionStorage != null) : IgniteStringFormatter.format((String)"tableId={}, partitionId={}", (Object[])new Object[]{this.tableId(), partitionId});
        return mvPartitionStorage;
    }

    private TxStateStorage getTxStateStorage() {
        int partitionId = this.partitionId();
        TxStateStorage txStateStorage = this.txStateTableStorage.getTxStateStorage(partitionId);
        assert (txStateStorage != null) : IgniteStringFormatter.format((String)"tableId={}, partitionId={}", (Object[])new Object[]{this.tableId(), partitionId});
        return txStateStorage;
    }

    private static TablePartitionId toTablePartitionId(PartitionKey partitionKey) {
        return new TablePartitionId(partitionKey.tableId(), partitionKey.partitionId());
    }

    private List<IndexIdAndBinaryRow> upgradeForEachTableVersion(@Nullable BinaryRow source, List<IndexIdAndTableVersion> indexIdAndTableVersionList) {
        if (source == null) {
            return List.of();
        }
        return indexIdAndTableVersionList.stream().map(indexIdAndTableVersion -> {
            BinaryRowUpgrader upgrader = new BinaryRowUpgrader(this.schemaRegistry, indexIdAndTableVersion.tableVersion());
            return new IndexIdAndBinaryRow(indexIdAndTableVersion.indexId(), upgrader.upgrade(source));
        }).collect(Collectors.toCollection(() -> new ArrayList(indexIdAndTableVersionList.size())));
    }
}

