/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Objects;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.table.partition.Partition;
import org.jetbrains.annotations.Nullable;

public class ExecutionOptions {
    public static final ExecutionOptions DEFAULT = ExecutionOptions.builder().build();
    private final int priority;
    private final int maxRetries;
    @Nullable
    private final Partition partition;

    private ExecutionOptions(int priority, int maxRetries, @Nullable Partition partition) {
        this.priority = priority;
        this.maxRetries = maxRetries;
        this.partition = partition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int priority() {
        return this.priority;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    @Nullable
    public Partition partition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionOptions that = (ExecutionOptions)o;
        return this.priority == that.priority && this.maxRetries == that.maxRetries && Objects.equals(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.maxRetries, this.partition);
    }

    public static ExecutionOptions from(JobExecutionOptions jobExecutionOptions) {
        return ExecutionOptions.builder().priority(jobExecutionOptions.priority()).maxRetries(jobExecutionOptions.maxRetries()).build();
    }

    public static class Builder {
        private int priority;
        private int maxRetries;
        @Nullable
        private Partition partition;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder partition(@Nullable Partition partition) {
            this.partition = partition;
            return this;
        }

        public ExecutionOptions build() {
            return new ExecutionOptions(this.priority, this.maxRetries, this.partition);
        }
    }
}

