/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.type;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.shaded.org.jetbrains.annotations.Contract;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class NativeTypes {
    public static final int MAX_TIME_PRECISION = 9;
    public static final NativeType BOOLEAN = new NativeType(NativeTypeSpec.BOOLEAN, 1);
    public static final NativeType INT8 = new NativeType(NativeTypeSpec.INT8, 1);
    public static final NativeType INT16 = new NativeType(NativeTypeSpec.INT16, 2);
    public static final NativeType INT32 = new NativeType(NativeTypeSpec.INT32, 4);
    public static final NativeType INT64 = new NativeType(NativeTypeSpec.INT64, 8);
    public static final NativeType FLOAT = new NativeType(NativeTypeSpec.FLOAT, 4);
    public static final NativeType DOUBLE = new NativeType(NativeTypeSpec.DOUBLE, 8);
    public static final NativeType UUID = new NativeType(NativeTypeSpec.UUID, 16);
    public static final NativeType STRING = new VarlenNativeType(NativeTypeSpec.STRING, Integer.MAX_VALUE);
    public static final NativeType BYTES = new VarlenNativeType(NativeTypeSpec.BYTES, Integer.MAX_VALUE);
    public static final NativeType DATE = new NativeType(NativeTypeSpec.DATE, 3);

    private NativeTypes() {
    }

    public static NativeType stringOf(int len) {
        return new VarlenNativeType(NativeTypeSpec.STRING, len);
    }

    public static NativeType blobOf(int len) {
        return new VarlenNativeType(NativeTypeSpec.BYTES, len);
    }

    public static NativeType decimalOf(int precision, int scale) {
        return new DecimalNativeType(precision, scale);
    }

    public static NativeType time(int precision) {
        return TemporalNativeType.time(precision);
    }

    public static NativeType datetime(int precision) {
        return TemporalNativeType.datetime(precision);
    }

    public static NativeType timestamp(int precision) {
        return TemporalNativeType.timestamp(precision);
    }

    @Contract(value="null -> null")
    @Nullable
    public static NativeType fromObject(@Nullable Object val) {
        NativeTypeSpec spec = NativeTypeSpec.fromObject(val);
        if (spec == null) {
            return null;
        }
        switch (spec) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case UUID: {
                return UUID;
            }
            case DATE: {
                return DATE;
            }
            case TIME: {
                assert (val instanceof LocalTime) : val.getClass().getCanonicalName();
                return NativeTypes.time(NativeTypes.derivePrecisionFromNanos(((LocalTime)val).getNano()));
            }
            case DATETIME: {
                assert (val instanceof LocalDateTime) : val.getClass().getCanonicalName();
                return NativeTypes.datetime(NativeTypes.derivePrecisionFromNanos(((LocalDateTime)val).getNano()));
            }
            case TIMESTAMP: {
                assert (val instanceof Instant) : val.getClass().getCanonicalName();
                return NativeTypes.timestamp(NativeTypes.derivePrecisionFromNanos(((Instant)val).getNano()));
            }
            case STRING: {
                return NativeTypes.stringOf(((CharSequence)val).length());
            }
            case BYTES: {
                return NativeTypes.blobOf(((byte[])val).length);
            }
            case DECIMAL: {
                return NativeTypes.decimalOf(((BigDecimal)val).precision(), ((BigDecimal)val).scale());
            }
        }
        assert (false) : "Unexpected type: " + String.valueOf((Object)spec);
        return null;
    }

    private static int derivePrecisionFromNanos(int nanos) {
        if (nanos == 0) {
            return 0;
        }
        int trailingZeroes = 0;
        while (nanos % 10 == 0) {
            ++trailingZeroes;
            nanos /= 10;
        }
        return 9 - trailingZeroes;
    }
}

