/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteStringFormatter;

public class ColumnNotFoundException
extends IgniteException {
    public ColumnNotFoundException(String columnName) {
        super(ErrorGroups.Table.COLUMN_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Column does not exist [name={}]", (Object[])new Object[]{IgniteNameUtils.quote((String)columnName)}));
    }

    public ColumnNotFoundException(String schemaName, String tableName, String columnName) {
        super(ErrorGroups.Table.COLUMN_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Column does not exist [tableName={}, columnName={}]", (Object[])new Object[]{IgniteNameUtils.canonicalName((String)schemaName, (String)tableName), IgniteNameUtils.quote((String)columnName)}));
    }

    public ColumnNotFoundException(UUID traceId, int code, String message, Throwable cause) {
        super(traceId, code, message, cause);
    }
}

