/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.ignite.network;

import java.util.function.Supplier;
import org.apache.ignite.internal.configuration.ConfigurationManager;

/**
 * Cluster service factory.
 */
public interface ClusterServiceFactory {
    /**
     * Creates a new {@link ClusterService} using the provided context. The created network will not be in the "started" state.
     *
     * @param context Cluster context.
     * @param nodeConfiguration Node configuration.
     * @param nodeFinderSupplier Supplier that provides node finder for discovering the initial cluster members.
     * @return New cluster service.
     */
    ClusterService createClusterService(
        ClusterLocalConfiguration context,
        ConfigurationManager nodeConfiguration,
        Supplier<NodeFinder> nodeFinderSupplier
    );
}
