/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.kill;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;

public class KillSqlCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(description="Query identifier")
    private String queryId;
    private UUID nodeId;
    private long qryId;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.queryId);
        U.writeUuid(out, this.nodeId);
        out.writeLong(this.qryId);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.queryId = U.readString(in);
        this.nodeId = U.readUuid(in);
        this.qryId = in.readLong();
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public long qryId() {
        return this.qryId;
    }

    public void qryId(long qryId) {
        this.qryId = qryId;
    }

    public String queryId() {
        return this.queryId;
    }

    public void queryId(String queryId) {
        this.queryId = queryId;
        T2<UUID, Long> ids = SqlKillQueryCommand.parseGlobalQueryId(queryId);
        if (ids == null) {
            throw new IllegalArgumentException("Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
        }
        this.nodeId = (UUID)ids.get1();
        this.qryId = (Long)ids.get2();
    }
}

