/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.IdGenerator;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTrimExchange;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class FragmentSplitter
extends IgniteRelShuttle {
    private final Deque<FragmentProto> stack = new LinkedList<FragmentProto>();
    private RelNode cutPoint;
    private FragmentProto curr;

    public FragmentSplitter(RelNode cutPoint) {
        this.cutPoint = cutPoint;
    }

    public List<Fragment> go(Fragment fragment) {
        ArrayList<Fragment> res = new ArrayList<Fragment>();
        this.stack.push(new FragmentProto(IdGenerator.nextId(), fragment.root()));
        while (!this.stack.isEmpty()) {
            this.curr = this.stack.pop();
            this.curr.root = this.visit(this.curr.root);
            res.add(this.curr.build());
            this.curr = null;
        }
        return res;
    }

    @Override
    public IgniteRel visit(IgniteReceiver rel) {
        this.curr.remotes.add((Object)rel);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteExchange rel) {
        throw new AssertionError();
    }

    @Override
    protected IgniteRel processNode(IgniteRel rel) {
        if (rel == this.cutPoint) {
            this.cutPoint = null;
            return this.split(rel);
        }
        List inputs = Commons.cast(rel.getInputs());
        for (int i = 0; i < inputs.size(); ++i) {
            this.visitChild(rel, i, (IgniteRel)inputs.get(i));
        }
        return rel;
    }

    private IgniteRel split(IgniteRel rel) {
        long srcFragmentId;
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet traits = rel.getTraitSet();
        RelDataType rowType = rel.getRowType();
        IgniteRel input = rel instanceof IgniteTrimExchange ? rel.getInput(0) : rel;
        long targetFragmentId = this.curr.id;
        long exchangeId = srcFragmentId = IdGenerator.nextId();
        IgniteReceiver receiver = new IgniteReceiver(cluster, traits, rowType, exchangeId, srcFragmentId);
        IgniteSender snd = new IgniteSender(cluster, traits, (RelNode)input, exchangeId, targetFragmentId, rel.distribution());
        this.curr.remotes.add((Object)receiver);
        this.stack.push(new FragmentProto(srcFragmentId, snd));
        return receiver;
    }

    private static class FragmentProto {
        private final long id;
        private IgniteRel root;
        private final ImmutableList.Builder<IgniteReceiver> remotes = ImmutableList.builder();

        private FragmentProto(long id, IgniteRel root) {
            this.id = id;
            this.root = root;
        }

        Fragment build() {
            return new Fragment(this.id, this.root, (List<IgniteReceiver>)this.remotes.build());
        }
    }
}

