/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.argument.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgument;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.util.GridStringBuilder;

public class CLIArgumentParser {
    private final List<CLIArgument<?>> positionalArgCfg;
    private final Map<String, CLIArgument<?>> argConfiguration = new LinkedHashMap();
    private final List<Object> parsedPositionalArgs = new ArrayList<Object>();
    private final Map<String, Object> parsedArgs = new HashMap<String, Object>();

    public CLIArgumentParser(List<CLIArgument<?>> argConfiguration) {
        this(Collections.emptyList(), argConfiguration);
    }

    public CLIArgumentParser(List<CLIArgument<?>> positionalArgConfig, List<CLIArgument<?>> argConfiguration) {
        this.positionalArgCfg = positionalArgConfig;
        for (CLIArgument<?> cliArgument : argConfiguration) {
            this.argConfiguration.put(cliArgument.name(), cliArgument);
        }
    }

    public void parse(Iterator<String> argsIter) {
        Set obligatoryArgs = this.argConfiguration.values().stream().filter(a -> !a.optional()).map(CLIArgument::name).collect(Collectors.toSet());
        int positionalIdx = 0;
        while (argsIter.hasNext()) {
            String strVal;
            boolean bool;
            String arg = argsIter.next();
            CLIArgument<?> cliArg = this.argConfiguration.get(arg.toLowerCase());
            if (cliArg == null) {
                if (positionalIdx < this.positionalArgCfg.size()) {
                    cliArg = this.positionalArgCfg.get(positionalIdx);
                    Object value = CommandUtils.parseVal((String)arg, cliArg.type());
                    cliArg.validator().accept(cliArg.name(), value);
                    this.parsedPositionalArgs.add(value);
                    ++positionalIdx;
                    continue;
                }
                throw new IllegalArgumentException("Unexpected argument: " + arg);
            }
            if (this.parsedArgs.get(cliArg.name()) != null) {
                throw new IllegalArgumentException(cliArg.name() + " argument specified twice");
            }
            boolean bl = bool = cliArg.type().equals(Boolean.class) || cliArg.type().equals(Boolean.TYPE);
            if (!bool && !argsIter.hasNext()) {
                throw new IllegalArgumentException("Please specify a value for argument: " + arg);
            }
            String string = strVal = bool ? "true" : argsIter.next();
            if (strVal != null && strVal.startsWith("--")) {
                throw new IllegalArgumentException("Unexpected value: " + strVal);
            }
            try {
                Object value = CommandUtils.parseVal((String)strVal, cliArg.type());
                cliArg.validator().accept(cliArg.name(), value);
                this.parsedArgs.put(cliArg.name(), value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to parse " + cliArg.name() + " command argument. " + e.getMessage());
            }
            obligatoryArgs.remove(cliArg.name());
        }
        if (!obligatoryArgs.isEmpty()) {
            throw new IllegalArgumentException("Mandatory argument(s) missing: " + obligatoryArgs);
        }
    }

    public <T> T get(CLIArgument<?> arg) {
        Object val = this.parsedArgs.get(arg.name());
        if (val == null) {
            return (T)arg.defaultValueSupplier().apply(this);
        }
        return (T)val;
    }

    public <T> T get(String name) {
        CLIArgument<?> arg = this.argConfiguration.get(name);
        if (arg == null) {
            throw new IgniteException("No such argument: " + name);
        }
        return this.get(arg);
    }

    public <T> T get(int position) {
        if (this.parsedPositionalArgs.size() - 1 < position) {
            return null;
        }
        return (T)this.parsedPositionalArgs.get(position);
    }

    public String usage() {
        GridStringBuilder sb = new GridStringBuilder("Usage: ");
        for (CLIArgument<?> arg : this.argConfiguration.values()) {
            sb.a(this.argNameForUsage(arg)).a(" ");
        }
        for (CLIArgument<?> arg : this.argConfiguration.values()) {
            String dfltVal = null;
            try {
                dfltVal = (String)arg.defaultValueSupplier().apply(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.a("\n\n").a(arg.name()).a(": ").a(arg.usage());
            if (!arg.optional()) continue;
            sb.a(" Default value: ").a(dfltVal instanceof String[] ? Arrays.toString((Object[])dfltVal) : dfltVal);
        }
        return sb.toString();
    }

    private String argNameForUsage(CLIArgument<?> arg) {
        if (arg.optional()) {
            return "[" + arg.name() + "]";
        }
        return arg.name();
    }
}

