/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.SqlStrictParseException;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlAnalyzeCommand;
import org.apache.ignite.internal.sql.command.SqlBeginTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropStatisticsCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlKillClientCommand;
import org.apache.ignite.internal.sql.command.SqlKillComputeTaskCommand;
import org.apache.ignite.internal.sql.command.SqlKillContinuousQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillScanQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillServiceCommand;
import org.apache.ignite.internal.sql.command.SqlKillTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlRefreshStatitsicsCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.jetbrains.annotations.Nullable;

public class SqlParser {
    public static final String STATISTICS = "STATISTICS";
    private final String schemaName;
    private final SqlLexer lex;
    private int lastCmdBeginPos;
    private int lastCmdEndPos = -1;

    public SqlParser(@Nullable String schemaName, String sql) {
        this.schemaName = schemaName;
        this.lex = new SqlLexer(sql);
    }

    public SqlCommand nextCommand() {
        SqlCommand cmd = this.nextCommand0();
        if (cmd != null && cmd.schemaName() == null) {
            cmd.schemaName(this.schemaName);
        }
        return cmd;
    }

    private SqlCommand nextCommand0() {
        block42: while (true) {
            if (!this.lex.shift()) {
                this.lastCmdEndPos = -1;
                return null;
            }
            switch (this.lex.tokenType()) {
                case SEMICOLON: {
                    continue block42;
                }
                case DEFAULT: {
                    SqlCommand cmd = null;
                    int curCmdBegin = this.lex.tokenPosition();
                    switch (this.lex.token()) {
                        case "BEGIN": {
                            cmd = this.processBegin();
                            break;
                        }
                        case "COMMIT": {
                            cmd = this.processCommit();
                            break;
                        }
                        case "CREATE": {
                            cmd = this.processCreate();
                            break;
                        }
                        case "DROP": {
                            cmd = this.processDrop();
                            break;
                        }
                        case "ROLLBACK": {
                            cmd = this.processRollback();
                            break;
                        }
                        case "START": {
                            cmd = this.processStart();
                            break;
                        }
                        case "COPY": {
                            try {
                                cmd = this.processCopy();
                                break;
                            }
                            catch (SqlParseException e) {
                                throw new SqlStrictParseException(e);
                            }
                        }
                        case "SET": {
                            cmd = this.processSet();
                            break;
                        }
                        case "ALTER": {
                            cmd = this.processAlter();
                            break;
                        }
                        case "KILL": {
                            cmd = this.processKill();
                            break;
                        }
                        case "HELP": {
                            cmd = this.processHelp();
                            break;
                        }
                        case "SHOW": {
                            cmd = this.processShow();
                            break;
                        }
                        case "GRANT": {
                            cmd = this.processGrant();
                            break;
                        }
                        case "REVOKE": {
                            cmd = this.processRevoke();
                            break;
                        }
                        case "ANALYZE": {
                            cmd = this.processAnalyze();
                            break;
                        }
                        case "REFRESH": {
                            cmd = this.processRefresh();
                        }
                    }
                    if (cmd != null) {
                        int curCmdEnd = this.lex.position();
                        if (this.lex.shift() && this.lex.tokenType() != SqlLexerTokenType.SEMICOLON) {
                            throw SqlParserUtils.errorUnexpectedToken(this.lex);
                        }
                        this.lastCmdBeginPos = curCmdBegin;
                        this.lastCmdEndPos = curCmdEnd;
                        return cmd;
                    }
                    throw SqlParserUtils.errorUnexpectedToken(this.lex, "BEGIN", "COMMIT", "CREATE", "DROP", "ROLLBACK", "COPY", "SET", "ALTER", "START", "KILL");
                }
            }
            break;
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex);
    }

    private SqlCommand processBegin() {
        SqlParserUtils.skipIfMatchesOptionalKeyword(this.lex, "TRANSACTION");
        SqlParserUtils.skipIfMatchesOptionalKeyword(this.lex, "WORK");
        return new SqlBeginTransactionCommand();
    }

    private SqlCommand processCommit() {
        SqlParserUtils.skipIfMatchesOptionalKeyword(this.lex, "TRANSACTION");
        return new SqlCommitTransactionCommand();
    }

    private SqlCommand processSet() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (this.lex.token()) {
                case "STREAMING": {
                    return new SqlSetStreamingCommand().parse(this.lex);
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "STREAMING");
    }

    private SqlCommand processKill() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (this.lex.token()) {
                case "QUERY": {
                    return new SqlKillQueryCommand().parse(this.lex);
                }
                case "SCAN": {
                    return new SqlKillScanQueryCommand().parse(this.lex);
                }
                case "COMPUTE": {
                    return new SqlKillComputeTaskCommand().parse(this.lex);
                }
                case "CONTINUOUS": {
                    return new SqlKillContinuousQueryCommand().parse(this.lex);
                }
                case "SERVICE": {
                    return new SqlKillServiceCommand().parse(this.lex);
                }
                case "TRANSACTION": {
                    return new SqlKillTransactionCommand().parse(this.lex);
                }
                case "CLIENT": {
                    return new SqlKillClientCommand().parse(this.lex);
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "QUERY");
    }

    private SqlCommand processCopy() {
        return new SqlBulkLoadCommand().parse(this.lex);
    }

    private SqlCommand processCreate() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            SqlCommand cmd = null;
            switch (this.lex.token()) {
                case "INDEX": {
                    cmd = new SqlCreateIndexCommand();
                    break;
                }
                case "SPATIAL": {
                    if (this.lex.shift() && SqlParserUtils.matchesKeyword(this.lex, "INDEX")) {
                        cmd = new SqlCreateIndexCommand().spatial(true);
                        break;
                    }
                    throw SqlParserUtils.errorUnexpectedToken(this.lex, "INDEX");
                }
                case "USER": {
                    cmd = new SqlCreateUserCommand();
                }
            }
            if (cmd != null) {
                return cmd.parse(this.lex);
            }
            SqlParserUtils.errorUnsupportedIfMatchesKeyword((SqlLexerToken)this.lex, "HASH", "PRIMARY", "UNIQUE");
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "INDEX", "SPATIAL", "USER");
    }

    private SqlCommand processDrop() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            SqlCommand cmd = null;
            switch (this.lex.token()) {
                case "INDEX": {
                    cmd = new SqlDropIndexCommand();
                    break;
                }
                case "USER": {
                    cmd = new SqlDropUserCommand();
                    break;
                }
                case "STATISTICS": {
                    cmd = new SqlDropStatisticsCommand();
                }
            }
            if (cmd != null) {
                return cmd.parse(this.lex);
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "INDEX", "USER");
    }

    private SqlCommand processRollback() {
        SqlParserUtils.skipIfMatchesOptionalKeyword(this.lex, "TRANSACTION");
        return new SqlRollbackTransactionCommand();
    }

    private SqlCommand processStart() {
        SqlParserUtils.skipIfMatchesKeyword(this.lex, "TRANSACTION");
        return new SqlBeginTransactionCommand();
    }

    private SqlCommand processAlter() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            SqlCommand cmd = null;
            switch (this.lex.token()) {
                case "TABLE": {
                    cmd = new SqlAlterTableCommand();
                    break;
                }
                case "USER": {
                    cmd = new SqlAlterUserCommand();
                }
            }
            if (cmd != null) {
                return cmd.parse(this.lex);
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "TABLE", "USER");
    }

    private SqlCommand processHelp() {
        throw new SqlStrictParseException("HELP command is not supported", 1002, SqlParserUtils.errorUnsupported(this.lex));
    }

    private SqlCommand processShow() {
        throw new SqlStrictParseException("SHOW command is not supported", 1002, SqlParserUtils.errorUnsupported(this.lex));
    }

    private SqlCommand processGrant() {
        throw new SqlStrictParseException("GRANT command is not supported", 1002, SqlParserUtils.errorUnsupported(this.lex));
    }

    private SqlCommand processRevoke() {
        throw new SqlStrictParseException("REVOKE command is not supported", 1002, SqlParserUtils.errorUnsupported(this.lex));
    }

    private SqlCommand processAnalyze() {
        SqlAnalyzeCommand cmd = new SqlAnalyzeCommand();
        return cmd.parse(this.lex);
    }

    private SqlCommand processRefresh() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT && STATISTICS.equals(this.lex.token())) {
            SqlRefreshStatitsicsCommand cmd = new SqlRefreshStatitsicsCommand();
            return cmd.parse(this.lex);
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, STATISTICS);
    }

    public String remainingSql() {
        if (this.lex.eod()) {
            return null;
        }
        return this.lex.sql().substring(this.lex.position());
    }

    public String lastCommandSql() {
        if (this.lastCmdEndPos < 0) {
            return null;
        }
        return this.lex.sql().substring(this.lastCmdBeginPos, this.lastCmdEndPos);
    }
}

