/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.A;

public abstract class DistributedSqlConfiguration {
    private static final String QUERY_TIMEOUT_PROPERTY_NAME = "sql.defaultQueryTimeout";
    protected static final String PROPERTY_UPDATE_MESSAGE = "SQL parameter '%s' was changed from '%s' to '%s'";
    public static final int DFLT_QRY_TIMEOUT = 0;
    private volatile DistributedChangeableProperty<Integer> dfltQryTimeout;

    protected DistributedSqlConfiguration(final GridKernalContext ctx, final IgniteLogger log) {
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedChangeableProperty prop = dispatcher.property(DistributedSqlConfiguration.QUERY_TIMEOUT_PROPERTY_NAME);
                if (prop != null) {
                    DistributedSqlConfiguration.this.dfltQryTimeout = prop;
                    return;
                }
                DistributedSqlConfiguration.this.dfltQryTimeout = new SimpleDistributedProperty<Integer>(DistributedSqlConfiguration.QUERY_TIMEOUT_PROPERTY_NAME, SimpleDistributedProperty::parseNonNegativeInteger, "Timeout in milliseconds for default query timeout. 0 means there is no timeout.");
                DistributedSqlConfiguration.this.dfltQryTimeout.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedSqlConfiguration.PROPERTY_UPDATE_MESSAGE, log));
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedSqlConfiguration.this.dfltQryTimeout});
            }

            @Override
            public void onReadyToWrite() {
                if (ReadableDistributedMetaStorage.isSupported(ctx)) {
                    DistributedConfigurationUtils.setDefaultValue(DistributedSqlConfiguration.this.dfltQryTimeout, (int)ctx.config().getSqlConfiguration().getDefaultQueryTimeout(), log);
                } else {
                    log.warning("Distributed metastorage is not supported. All distributed SQL configuration parameters are unavailable.");
                    DistributedSqlConfiguration.this.dfltQryTimeout.localUpdate(Integer.valueOf((int)ctx.config().getSqlConfiguration().getDefaultQueryTimeout()));
                }
            }
        });
    }

    public int defaultQueryTimeout() {
        Integer t = this.dfltQryTimeout == null ? null : (Integer)this.dfltQryTimeout.get();
        return t != null ? t : 0;
    }

    public GridFutureAdapter<?> defaultQueryTimeout(int timeout) throws IgniteCheckedException {
        A.ensure(timeout >= 0, "default query timeout value must not be negative.");
        if (this.dfltQryTimeout == null) {
            throw new IgniteCheckedException("Property sql.defaultQueryTimeout is not registered yet");
        }
        return this.dfltQryTimeout.propagateAsync(timeout);
    }
}

