/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CompressionHandler {
    private final CompressionProcessor compressProc;
    private final int diskPageCompressLevel;
    private final DiskPageCompression diskPageCompression;

    private CompressionHandler(CompressionProcessor compressProc, DiskPageCompression diskPageCompression, int diskPageCompressLevel) {
        this.diskPageCompression = diskPageCompression;
        this.diskPageCompressLevel = diskPageCompressLevel;
        this.compressProc = compressProc;
    }

    private CompressionHandler() {
        this.diskPageCompression = DiskPageCompression.DISABLED;
        this.diskPageCompressLevel = 0;
        this.compressProc = null;
    }

    public DiskPageCompression diskPageCompression() {
        return this.diskPageCompression;
    }

    public int diskPageCompressionLevel() {
        return this.diskPageCompressLevel;
    }

    public boolean compressionEnabled() {
        return this.diskPageCompression != DiskPageCompression.DISABLED;
    }

    public ByteBuffer compressPage(ByteBuffer page, PageStore store) throws IgniteCheckedException {
        if (this.diskPageCompression == DiskPageCompression.DISABLED) {
            return page;
        }
        int blockSize = store.getBlockSize();
        if (blockSize <= 0) {
            throw new IgniteCheckedException("Failed to detect storage block size on " + U.osString());
        }
        return this.compressProc.compressPage(page, store.getPageSize(), blockSize, this.diskPageCompression, this.diskPageCompressLevel);
    }

    public static CompressionHandler create(GridKernalContext ctx, CacheConfiguration cfg) throws IgniteCheckedException {
        DiskPageCompression diskPageCompr = cfg.getDiskPageCompression();
        DataStorageConfiguration dsCfg = ctx.config().getDataStorageConfiguration();
        if (ctx.clientNode() || diskPageCompr == DiskPageCompression.DISABLED || !CU.isPersistentCache(cfg, dsCfg)) {
            return new CompressionHandler();
        }
        CompressionProcessor comprProc = ctx.compress();
        int lvl = cfg.getDiskPageCompressionLevel() == null ? CompressionProcessor.getDefaultCompressionLevel(diskPageCompr) : CompressionProcessor.checkCompressionLevelBounds(cfg.getDiskPageCompressionLevel(), diskPageCompr);
        File dbPath = ctx.pdsFolderResolver().resolveFolders().persistentStoreRootPath();
        assert (dbPath != null);
        comprProc.checkPageCompressionSupported(dbPath.toPath(), dsCfg.getPageSize());
        return new CompressionHandler(comprProc, diskPageCompr, lvl);
    }
}

