/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.PartitionDestroyRequest;
import org.apache.ignite.internal.util.typedef.T2;
import org.jetbrains.annotations.Nullable;

public class PartitionDestroyQueue {
    private final ConcurrentMap<T2<Integer, Integer>, PartitionDestroyRequest> pendingReqs = new ConcurrentHashMap<T2<Integer, Integer>, PartitionDestroyRequest>();

    public void addDestroyRequest(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
        PartitionDestroyRequest req = new PartitionDestroyRequest(grpId, partId);
        PartitionDestroyRequest old = this.pendingReqs.putIfAbsent(new T2<Integer, Integer>(grpId, partId), req);
        assert (old == null || grpCtx == null) : "Must wait for old destroy request to finish before adding a new one [grpId=" + grpId + ", grpName=" + grpCtx.cacheOrGroupName() + ", partId=" + partId + ']';
    }

    public PartitionDestroyRequest removeRequest(int grpId, int partId) {
        return (PartitionDestroyRequest)this.pendingReqs.remove(new T2<Integer, Integer>(grpId, partId));
    }

    public ConcurrentMap<T2<Integer, Integer>, PartitionDestroyRequest> pendingReqs() {
        return this.pendingReqs;
    }
}

