/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessor;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTrackerImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotWithoutTxs;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionImpl;
import org.apache.ignite.internal.processors.cache.mvcc.StaticMvccQueryTracker;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxAlreadyCompletedCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxUnexpectedStateCheckedException;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionMixedModeException;
import org.apache.ignite.transactions.TransactionState;
import org.apache.ignite.transactions.TransactionUnsupportedConcurrencyException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvccUtils {
    public static final int MVCC_KEY_ABSENT_BEFORE_OFF = 29;
    public static final int MVCC_HINTS_BIT_OFF = 30;
    public static final int MVCC_KEY_ABSENT_BEFORE_MASK = 0x20000000;
    public static final int MVCC_HINTS_MASK = -1073741824;
    public static final int MVCC_OP_COUNTER_MASK = 0x1FFFFFFF;
    public static final long MVCC_CRD_COUNTER_NA = 0L;
    public static final long MVCC_CRD_START_CNTR = 1L;
    public static final long MVCC_COUNTER_NA = 0L;
    public static final long MVCC_INITIAL_CNTR = 1L;
    public static final long MVCC_START_CNTR = 3L;
    public static final int MVCC_OP_COUNTER_NA = 0;
    public static final int MVCC_START_OP_CNTR = 1;
    public static final int MVCC_READ_OP_CNTR = 0x1FFFFFFF;
    public static final int MVCC_INVISIBLE = 0;
    public static final int MVCC_VISIBLE_REMOVED = 1;
    public static final int MVCC_VISIBLE = 2;
    public static final MvccVersion INITIAL_VERSION = MvccUtils.mvccVersion(1L, 1L, 1);
    public static final MvccSnapshot MVCC_MAX_SNAPSHOT = new MvccSnapshotWithoutTxs(Long.MAX_VALUE, Long.MAX_VALUE, 0x1FFFFFFF, 0L);
    private static final MvccClosure<Integer> getVisibleState = new GetVisibleState();
    private static final MvccClosure<Boolean> isVisible = new IsVisible();
    private static final MvccClosure<MvccVersion> getNewVer = new GetNewVersion();

    private MvccUtils() {
    }

    public static boolean isActive(GridCacheContext cctx, long mvccCrd, long mvccCntr, MvccSnapshot snapshot) throws IgniteCheckedException {
        byte state;
        if (MvccUtils.isVisible(cctx, snapshot, mvccCrd, mvccCntr, 0, false)) {
            return false;
        }
        return cctx.kernalContext().coordinators().hasLocalTransaction(mvccCrd, mvccCntr) || (state = MvccUtils.state(cctx, mvccCrd, mvccCntr, 0)) != 3 && state != 2;
    }

    public static byte state(GridCacheContext cctx, long mvccCrd, long mvccCntr, int mvccOpCntr) {
        return MvccUtils.state(cctx.kernalContext().coordinators(), mvccCrd, mvccCntr, mvccOpCntr);
    }

    public static byte state(CacheGroupContext grp, long mvccCrd, long mvccCntr, int mvccOpCntr) {
        return MvccUtils.state(grp.shared().coordinators(), mvccCrd, mvccCntr, mvccOpCntr);
    }

    public static byte state(MvccProcessor proc, long mvccCrd, long mvccCntr, int mvccOpCntr) {
        if (MvccUtils.compare(INITIAL_VERSION, mvccCrd, mvccCntr, mvccOpCntr) == 0) {
            return 3;
        }
        if ((mvccOpCntr & 0xC0000000) != 0) {
            return (byte)(mvccOpCntr >>> 30);
        }
        MvccCoordinator crd = proc.currentCoordinator();
        int state = proc.state(mvccCrd, mvccCntr);
        if ((state == 0 || state == 1) && (crd.unassigned() || crd.initialized() && mvccCrd < crd.version())) {
            state = 2;
        }
        return (byte)state;
    }

    public static boolean isVisible(GridCacheContext cctx, MvccSnapshot snapshot, long mvccCrd, long mvccCntr, int opCntr) throws IgniteCheckedException {
        return MvccUtils.isVisible(cctx, snapshot, mvccCrd, mvccCntr, opCntr, true);
    }

    public static boolean isVisible(GridCacheContext cctx, MvccSnapshot snapshot, long mvccCrd, long mvccCntr, int opCntrWithHints, boolean useTxLog) throws IgniteCheckedException {
        int opCntr = opCntrWithHints & 0x1FFFFFFF;
        if (mvccCrd == 0L) {
            assert (mvccCntr == 0L && opCntrWithHints == 0) : "rowVer=" + MvccUtils.mvccVersion(mvccCrd, mvccCntr, opCntrWithHints) + ", snapshot=" + snapshot;
            return false;
        }
        if (MvccUtils.compare(INITIAL_VERSION, mvccCrd, mvccCntr, opCntr) == 0) {
            return true;
        }
        long snapshotCrd = snapshot.coordinatorVersion();
        long snapshotCntr = snapshot.counter();
        int snapshotOpCntr = snapshot.operationCounter();
        assert ((snapshotOpCntr & 0xE0000000) == 0) : snapshot;
        if (mvccCrd > snapshotCrd) {
            return false;
        }
        if (mvccCrd < snapshotCrd) {
            if (!useTxLog) {
                return true;
            }
            byte state = MvccUtils.state(cctx, mvccCrd, mvccCntr, opCntrWithHints);
            if (MVCC_MAX_SNAPSHOT.compareTo(snapshot) != 0 && state != 3 && state != 2) {
                throw MvccUtils.unexpectedStateException(cctx, state, mvccCrd, mvccCntr, opCntrWithHints, snapshot);
            }
            return state == 3;
        }
        if (mvccCntr > snapshotCntr) {
            return false;
        }
        if (mvccCntr == snapshotCntr && snapshotOpCntr != 0x1FFFFFFF) {
            assert (opCntr <= snapshotOpCntr) : "rowVer=" + MvccUtils.mvccVersion(mvccCrd, mvccCntr, opCntrWithHints) + ", snapshot=" + snapshot;
            return opCntr < snapshotOpCntr;
        }
        if (snapshot.activeTransactions().contains(mvccCntr)) {
            return false;
        }
        if (!useTxLog) {
            return true;
        }
        byte state = MvccUtils.state(cctx, mvccCrd, mvccCntr, opCntrWithHints);
        if (state != 3 && state != 2) {
            throw MvccUtils.unexpectedStateException(cctx, state, mvccCrd, mvccCntr, opCntrWithHints, snapshot);
        }
        return state == 3;
    }

    public static IgniteTxUnexpectedStateCheckedException unexpectedStateException(CacheGroupContext grp, byte state, long crd, long cntr, int opCntr) {
        return MvccUtils.unexpectedStateException(grp.shared().kernalContext(), state, crd, cntr, opCntr, null);
    }

    public static IgniteTxUnexpectedStateCheckedException unexpectedStateException(GridCacheContext cctx, byte state, long crd, long cntr, int opCntr, MvccSnapshot snapshot) {
        return MvccUtils.unexpectedStateException(cctx.kernalContext(), state, crd, cntr, opCntr, snapshot);
    }

    private static IgniteTxUnexpectedStateCheckedException unexpectedStateException(GridKernalContext ctx, byte state, long crd, long cntr, int opCntr, MvccSnapshot snapshot) {
        String msg = "Unexpected state: [state=" + state + ", rowVer=" + crd + ":" + cntr + ":" + opCntr;
        if (snapshot != null) {
            msg = msg + ", txVer=" + snapshot.coordinatorVersion() + ":" + snapshot.counter() + ":" + snapshot.operationCounter();
        }
        msg = msg + ", localNodeId=" + ctx.localNodeId() + "]";
        return new IgniteTxUnexpectedStateCheckedException(msg);
    }

    public static boolean isVisible(GridCacheContext cctx, MvccSnapshot snapshot, long crd, long cntr, int opCntr, long link) throws IgniteCheckedException {
        return MvccUtils.isVisible(cctx, snapshot, crd, cntr, opCntr, false) && MvccUtils.isVisible(cctx, link, snapshot);
    }

    public static boolean hasNewVersion(MvccUpdateVersionAware row) {
        assert (row.newMvccCoordinatorVersion() == 0L || MvccUtils.mvccVersionIsValid(row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter()));
        return row.newMvccCoordinatorVersion() > 0L;
    }

    public static int getVisibleState(GridCacheContext cctx, long link, MvccSnapshot snapshot) throws IgniteCheckedException {
        return MvccUtils.invoke(cctx, link, getVisibleState, snapshot);
    }

    public static MvccVersion getNewVersion(GridCacheContext cctx, long link) throws IgniteCheckedException {
        return MvccUtils.invoke(cctx, link, getNewVer, null);
    }

    public static int compare(MvccVersionAware row, MvccVersion ver) {
        return MvccUtils.compare(row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter(), ver.coordinatorVersion(), ver.counter(), ver.operationCounter());
    }

    public static int compare(MvccVersion mvccVerLeft, long mvccCrdRight, long mvccCntrRight) {
        return MvccUtils.compare(mvccVerLeft.coordinatorVersion(), mvccVerLeft.counter(), mvccCrdRight, mvccCntrRight);
    }

    public static int compare(MvccVersionAware row, long mvccCrdRight, long mvccCntrRight) {
        return MvccUtils.compare(row.mvccCoordinatorVersion(), row.mvccCounter(), mvccCrdRight, mvccCntrRight);
    }

    public static int compare(MvccVersion mvccVerLeft, long mvccCrdRight, long mvccCntrRight, int mvccOpCntrRight) {
        return MvccUtils.compare(mvccVerLeft.coordinatorVersion(), mvccVerLeft.counter(), mvccVerLeft.operationCounter(), mvccCrdRight, mvccCntrRight, mvccOpCntrRight);
    }

    public static int compare(long mvccCrdLeft, long mvccCntrLeft, int mvccOpCntrLeft, MvccVersionAware other) {
        return MvccUtils.compare(mvccCrdLeft, mvccCntrLeft, mvccOpCntrLeft, other.mvccCoordinatorVersion(), other.mvccCounter(), other.mvccOperationCounter());
    }

    public static int compare(long mvccCrdLeft, long mvccCntrLeft, long mvccCrdRight, long mvccCntrRight) {
        return MvccUtils.compare(mvccCrdLeft, mvccCntrLeft, 0, mvccCrdRight, mvccCntrRight, 0);
    }

    public static int compare(long mvccCrdLeft, long mvccCntrLeft, int mvccOpCntrLeft, long mvccCrdRight, long mvccCntrRight, int mvccOpCntrRight) {
        int cmp = Long.compare(mvccCrdLeft, mvccCrdRight);
        if (cmp != 0 || (cmp = Long.compare(mvccCntrLeft, mvccCntrRight)) != 0 || (cmp = Integer.compare(mvccOpCntrLeft & 0x1FFFFFFF, mvccOpCntrRight & 0x1FFFFFFF)) != 0) {
            return cmp;
        }
        return 0;
    }

    public static int compareIgnoreOpCounter(MvccVersion left, MvccVersion right) {
        return MvccUtils.compare(left.coordinatorVersion(), left.counter(), 0, right.coordinatorVersion(), right.counter(), 0);
    }

    public static int compareNewVersion(MvccUpdateVersionAware row, long mvccCrd, long mvccCntr) {
        return MvccUtils.compare(row.newMvccCoordinatorVersion(), row.newMvccCounter(), mvccCrd, mvccCntr);
    }

    public static int compareNewVersion(MvccUpdateVersionAware row, long mvccCrd, long mvccCntr, int opCntr) {
        return MvccUtils.compare(row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter(), mvccCrd, mvccCntr, opCntr);
    }

    public static int compareNewVersion(MvccUpdateVersionAware row, MvccVersion ver) {
        return MvccUtils.compare(row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter(), ver.coordinatorVersion(), ver.counter(), ver.operationCounter());
    }

    public static boolean mvccVersionIsValid(long crdVer, long cntr, int opCntr) {
        return MvccUtils.mvccVersionIsValid(crdVer, cntr) && (opCntr & 0x1FFFFFFF) != 0;
    }

    public static boolean mvccVersionIsValid(long crdVer, long cntr) {
        return crdVer > 0L && cntr > 0L;
    }

    public static ClusterTopologyServerNotFoundException noCoordinatorError() {
        return new ClusterTopologyServerNotFoundException("Mvcc coordinator is not assigned.");
    }

    private static boolean isVisible(GridCacheContext cctx, long link, MvccSnapshot snapshot) throws IgniteCheckedException {
        return MvccUtils.invoke(cctx, link, isVisible, snapshot);
    }

    private static <R> R invoke(GridCacheContext cctx, long link, MvccClosure<R> clo, MvccSnapshot snapshot) throws IgniteCheckedException {
        assert (false);
        return null;
    }

    private static <R> R invoke(GridCacheContext cctx, DataPageIO dataIo, long pageAddr, int itemId, int pageSize, MvccClosure<R> clo, MvccSnapshot snapshot) throws IgniteCheckedException {
        int offset = dataIo.getPayloadOffset(pageAddr, itemId, pageSize, 40);
        long mvccCrd = dataIo.mvccCoordinator(pageAddr, offset);
        long mvccCntr = dataIo.mvccCounter(pageAddr, offset);
        int mvccOpCntr = dataIo.rawMvccOperationCounter(pageAddr, offset);
        assert (MvccUtils.mvccVersionIsValid(mvccCrd, mvccCntr, mvccOpCntr)) : MvccUtils.mvccVersion(mvccCrd, mvccCntr, mvccOpCntr);
        long newMvccCrd = dataIo.newMvccCoordinator(pageAddr, offset);
        long newMvccCntr = dataIo.newMvccCounter(pageAddr, offset);
        int newMvccOpCntr = dataIo.rawNewMvccOperationCounter(pageAddr, offset);
        assert (newMvccCrd == 0L || MvccUtils.mvccVersionIsValid(newMvccCrd, newMvccCntr, newMvccOpCntr)) : MvccUtils.mvccVersion(newMvccCrd, newMvccCntr, newMvccOpCntr);
        return clo.apply(cctx, snapshot, mvccCrd, mvccCntr, mvccOpCntr, newMvccCrd, newMvccCntr, newMvccOpCntr);
    }

    public static boolean isVisible(GridCacheContext cctx, MvccSnapshot snapshot, DataPageIO dataIo, long pageAddr, int itemId, int pageSize) throws IgniteCheckedException {
        return MvccUtils.invoke(cctx, dataIo, pageAddr, itemId, pageSize, isVisible, snapshot);
    }

    public static GridNearTxLocal checkActive(GridNearTxLocal tx) throws IgniteTxAlreadyCompletedCheckedException {
        if (tx != null && tx.state() != TransactionState.ACTIVE) {
            throw new IgniteTxAlreadyCompletedCheckedException("Transaction is already completed.");
        }
        return tx;
    }

    @Nullable
    public static GridNearTxLocal tx(GridKernalContext ctx) {
        return MvccUtils.tx(ctx, null);
    }

    @Nullable
    public static GridNearTxLocal tx(GridKernalContext ctx, @Nullable GridCacheVersion txId) {
        GridNearTxLocal tx;
        IgniteTxManager tm = ctx.cache().context().tm();
        IgniteInternalTx tx0 = txId == null ? (IgniteInternalTx)tm.tx() : tm.tx(txId);
        GridNearTxLocal gridNearTxLocal = tx = tx0 != null && tx0.user() ? (GridNearTxLocal)tx0 : null;
        if (tx != null) {
            if (!tx.pessimistic()) {
                tx.setRollbackOnly();
                throw new TransactionUnsupportedConcurrencyException("Only pessimistic transactions are supported when MVCC is enabled.");
            }
            if (!tx.isOperationAllowed(true)) {
                tx.setRollbackOnly();
                throw new TransactionMixedModeException("Operations on MVCC caches are not permitted in transactions spanning non MVCC caches.");
            }
        }
        return tx;
    }

    public static GridNearTxLocal txStart(GridKernalContext ctx, long timeout) {
        return MvccUtils.txStart(ctx, null, timeout);
    }

    public static GridNearTxLocal txStart(GridCacheContext cctx, long timeout) {
        return MvccUtils.txStart(cctx.kernalContext(), cctx, timeout);
    }

    private static GridNearTxLocal txStart(GridKernalContext ctx, @Nullable GridCacheContext cctx, long timeout) {
        TransactionConfiguration tcfg;
        if (timeout == 0L && (tcfg = CU.transactionConfiguration(cctx, ctx.config())) != null) {
            timeout = tcfg.getDefaultTxTimeout();
        }
        GridNearTxLocal tx = ctx.cache().context().tm().newTx(false, false, cctx != null && cctx.systemTx() ? cctx : null, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, timeout, cctx == null || !cctx.skipStore(), true, 0, null);
        tx.syncMode(CacheWriteSynchronizationMode.FULL_SYNC);
        return tx;
    }

    @NotNull
    public static MvccQueryTracker mvccTracker(GridCacheContext cctx, GridNearTxLocal tx) throws IgniteCheckedException {
        MvccQueryTracker tracker = tx == null ? new MvccQueryTrackerImpl(cctx) : new StaticMvccQueryTracker(cctx, MvccUtils.requestSnapshot(tx));
        if (tracker.snapshot() == null) {
            tracker.requestSnapshot().get();
        }
        return tracker;
    }

    public static MvccSnapshot requestSnapshot(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        MvccSnapshot snapshot = tx.mvccSnapshot();
        if (snapshot == null) {
            return tx.requestSnapshot().get();
        }
        return snapshot;
    }

    private static MvccVersion mvccVersion(long crd, long cntr, int opCntr) {
        return new MvccVersionImpl(crd, cntr, opCntr);
    }

    public static boolean belongToSameTx(MvccVersion v1, MvccVersion v2) {
        return v1.coordinatorVersion() == v2.coordinatorVersion() && v1.counter() == v2.counter();
    }

    private static class GetNewVersion
    implements MvccClosure<MvccVersion> {
        private GetNewVersion() {
        }

        @Override
        public MvccVersion apply(GridCacheContext cctx, MvccSnapshot snapshot, long mvccCrd, long mvccCntr, int mvccOpCntr, long newMvccCrd, long newMvccCntr, int newMvccOpCntr) {
            return newMvccCrd == 0L ? null : MvccUtils.mvccVersion(newMvccCrd, newMvccCntr, newMvccOpCntr);
        }
    }

    private static class IsVisible
    implements MvccClosure<Boolean> {
        private IsVisible() {
        }

        @Override
        public Boolean apply(GridCacheContext cctx, MvccSnapshot snapshot, long mvccCrd, long mvccCntr, int mvccOpCntr, long newMvccCrd, long newMvccCntr, int newMvccOpCntr) throws IgniteCheckedException {
            if (!MvccUtils.isVisible(cctx, snapshot, mvccCrd, mvccCntr, mvccOpCntr)) {
                return false;
            }
            if (newMvccCrd == 0L) {
                return true;
            }
            assert (MvccUtils.mvccVersionIsValid(newMvccCrd, newMvccCntr, newMvccOpCntr));
            if (mvccCrd == newMvccCrd && mvccCntr == newMvccCntr) {
                return false;
            }
            return !MvccUtils.isVisible(cctx, snapshot, newMvccCrd, newMvccCntr, newMvccOpCntr);
        }
    }

    private static class GetVisibleState
    implements MvccClosure<Integer> {
        private GetVisibleState() {
        }

        @Override
        public Integer apply(GridCacheContext cctx, MvccSnapshot snapshot, long mvccCrd, long mvccCntr, int mvccOpCntr, long newMvccCrd, long newMvccCntr, int newMvccOpCntr) throws IgniteCheckedException {
            if (!MvccUtils.isVisible(cctx, snapshot, mvccCrd, mvccCntr, mvccOpCntr)) {
                return 0;
            }
            if (newMvccCrd == 0L) {
                return 2;
            }
            assert (MvccUtils.mvccVersionIsValid(newMvccCrd, newMvccCntr, newMvccOpCntr));
            if (mvccCrd == newMvccCrd && mvccCntr == newMvccCntr) {
                return 1;
            }
            return MvccUtils.isVisible(cctx, snapshot, newMvccCrd, newMvccCntr, newMvccOpCntr) ? 1 : 2;
        }
    }

    private static interface MvccClosure<R> {
        public R apply(GridCacheContext var1, MvccSnapshot var2, long var3, long var5, int var7, long var8, long var10, int var12) throws IgniteCheckedException;
    }
}

