/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.management.cache.ViewCacheCmd;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class CacheInfo
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String seqName;
    private long seqVal;
    private String cacheName;
    private int cacheId;
    private String grpName;
    private int grpId;
    private int cachesCnt;
    private int partitions;
    private int mapped;
    public AffinityTopologyVersion topVer;
    private CacheMode mode;
    private CacheAtomicityMode atomicityMode;
    private int backupsCnt;
    private String affinityClsName;

    public String getSeqName() {
        return this.seqName;
    }

    public void setSeqName(String seqName) {
        this.seqName = seqName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public int getCacheId() {
        return this.cacheId;
    }

    public void setCacheId(int cacheId) {
        this.cacheId = cacheId;
    }

    public String getGrpName() {
        return this.grpName;
    }

    public void setGrpName(String grpName) {
        this.grpName = grpName;
    }

    public int getGrpId() {
        return this.grpId;
    }

    public void setGrpId(int grpId) {
        this.grpId = grpId;
    }

    public int getCachesCnt() {
        return this.cachesCnt;
    }

    public void setCachesCnt(int cachesCnt) {
        this.cachesCnt = cachesCnt;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public int getMapped() {
        return this.mapped;
    }

    public void setMapped(int mapped) {
        this.mapped = mapped;
    }

    public AffinityTopologyVersion getTopologyVersion() {
        return this.topVer;
    }

    public void setTopologyVersion(AffinityTopologyVersion topologyVersion) {
        this.topVer = topologyVersion;
    }

    public void setSeqVal(long seqVal) {
        this.seqVal = seqVal;
    }

    public long getSeqVal() {
        return this.seqVal;
    }

    public CacheMode getMode() {
        return this.mode;
    }

    public void setMode(CacheMode mode) {
        this.mode = mode;
    }

    public CacheAtomicityMode getAtomicityMode() {
        return this.atomicityMode;
    }

    public void setAtomicityMode(CacheAtomicityMode atomicityMode) {
        this.atomicityMode = atomicityMode;
    }

    public int getBackupsCnt() {
        return this.backupsCnt;
    }

    public void setBackupsCnt(int backupsCnt) {
        this.backupsCnt = backupsCnt;
    }

    public String getAffinityClsName() {
        return this.affinityClsName;
    }

    public void setAffinityClsName(String affinityClsName) {
        this.affinityClsName = affinityClsName;
    }

    public Object name(ViewCacheCmd cmd) {
        switch (cmd) {
            case CACHES: {
                return this.getCacheName();
            }
            case GROUPS: {
                return this.getGrpName();
            }
            case SEQ: {
                return this.getSeqName();
            }
        }
        throw new IllegalArgumentException("Unknown cache subcommand " + (Object)((Object)cmd));
    }

    public Map<String, Object> toMap(ViewCacheCmd cmd) {
        LinkedHashMap<String, Object> map;
        switch (cmd) {
            case SEQ: {
                map = new LinkedHashMap<String, Object>(2);
                map.put("seqName", this.getSeqName());
                map.put("curVal", this.seqVal);
                break;
            }
            case GROUPS: {
                map = new LinkedHashMap(10);
                map.put("grpName", this.getGrpName());
                map.put("grpId", this.getGrpId());
                map.put("cachesCnt", this.getCachesCnt());
                map.put("prim", this.getPartitions());
                map.put("mapped", this.getMapped());
                map.put("mode", (Object)this.getMode());
                map.put("atomicity", (Object)this.getAtomicityMode());
                map.put("backups", this.getBackupsCnt());
                map.put("affCls", this.getAffinityClsName());
                break;
            }
            default: {
                map = new LinkedHashMap(10);
                map.put("cacheName", this.getCacheName());
                map.put("cacheId", this.getCacheId());
                map.put("grpName", this.getGrpName());
                map.put("grpId", this.getGrpId());
                map.put("prim", this.getPartitions());
                map.put("mapped", this.getMapped());
                map.put("mode", (Object)this.getMode());
                map.put("atomicity", (Object)this.getAtomicityMode());
                map.put("backups", this.getBackupsCnt());
                map.put("affCls", this.getAffinityClsName());
            }
        }
        return map;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.seqName);
        out.writeLong(this.seqVal);
        U.writeString(out, this.cacheName);
        out.writeInt(this.cacheId);
        U.writeString(out, this.grpName);
        out.writeInt(this.grpId);
        out.writeInt(this.partitions);
        out.writeInt(this.mapped);
        out.writeObject(this.topVer);
        out.writeByte(CacheMode.toCode(this.mode));
        out.writeInt(this.backupsCnt);
        U.writeString(out, this.affinityClsName);
        out.writeInt(this.cachesCnt);
        U.writeEnum(out, this.atomicityMode);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.seqName = U.readString(in);
        this.seqVal = in.readLong();
        this.cacheName = U.readString(in);
        this.cacheId = in.readInt();
        this.grpName = U.readString(in);
        this.grpId = in.readInt();
        this.partitions = in.readInt();
        this.mapped = in.readInt();
        this.topVer = (AffinityTopologyVersion)in.readObject();
        this.mode = CacheMode.fromCode(in.readByte());
        this.backupsCnt = in.readInt();
        this.affinityClsName = U.readString(in);
        this.cachesCnt = in.readInt();
        this.atomicityMode = protoVer >= 2 ? CacheAtomicityMode.fromOrdinal(in.readByte()) : null;
    }

    public String toString() {
        return S.toString(CacheInfo.class, this);
    }
}

