/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteTableScan
extends ProjectableFilterableTableScan
implements SourceAwareIgniteRel {
    private final long sourceId;

    public IgniteTableScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public IgniteTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl) {
        this(cluster, traits, tbl, null, null, null);
    }

    public IgniteTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColunms) {
        this(-1L, cluster, traits, tbl, proj, cond, requiredColunms);
    }

    private IgniteTableScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColunms) {
        super(cluster, traits, (List<RelHint>)ImmutableList.of(), tbl, proj, cond, requiredColunms);
        this.sourceId = sourceId;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteTableScan(sourceId, this.getCluster(), this.getTraitSet(), this.getTable(), (List<RexNode>)this.projects, this.condition, this.requiredColumns);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTableScan(this.sourceId, cluster, this.getTraitSet(), this.getTable(), (List<RexNode>)this.projects, this.condition, this.requiredColumns);
    }
}

