/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionFunction;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;

public class IgniteFilter
extends Filter
implements TraitsAwareIgniteRel {
    public IgniteFilter(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexNode condition) {
        super(cluster, traits, input, condition);
    }

    public IgniteFilter(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new IgniteFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (!TraitUtils.rewindability(inTraits.get(0)).rewindable() && RexUtils.hasCorrelation(this.getCondition())) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.rewindability(inTraits.get(0))), inTraits));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.distribution(inTraits.get(0))), inTraits));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.collation(inTraits.get(0))), inTraits));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> corrSet = RexUtils.extractCorrelationIds(this.getCondition());
        CorrelationTrait correlation = TraitUtils.correlation(nodeTraits);
        if (corrSet.isEmpty() || correlation.correlationIds().containsAll(corrSet)) {
            return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)inTraits.get(0).replace((RelTrait)correlation)));
        }
        return null;
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(this.getCondition());
        corrIds.addAll(TraitUtils.correlation(inTraits.get(0)).correlationIds());
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(corrIds)), inTraits));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        IgniteDistribution distribution;
        block5: {
            distribution = TraitUtils.distribution(nodeTraits);
            if (distribution.function().correlated()) {
                final DistributionFunction.CorrelatedDistribution func = (DistributionFunction.CorrelatedDistribution)distribution.function();
                RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                    public Void visitCorrelVariable(RexCorrelVariable variable) {
                        if (variable.id.equals((Object)func.correlationId())) {
                            throw new Util.FoundOne((Object)variable);
                        }
                        return null;
                    }
                };
                try {
                    this.condition.accept((RexVisitor)visitor);
                }
                catch (Util.FoundOne corr) {
                    IgniteDistribution corrDistr = func.target();
                    assert (corrDistr.getType() == RelDistribution.Type.HASH_DISTRIBUTED);
                    int corrFieldsCnt = ((RexNode)corr.getNode()).getType().getFieldCount();
                    int inputFieldsCnt = this.getRowType().getFieldCount();
                    Mapping mapping = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)corrFieldsCnt, (int)inputFieldsCnt);
                    List conds = RelOptUtil.conjunctions((RexNode)RexUtil.toCnf((RexBuilder)this.getCluster().getRexBuilder(), (RexNode)this.condition));
                    for (RexNode cond : conds) {
                        RexFieldAccess fieldAccess;
                        RexInputRef inputRef;
                        if (!(cond instanceof RexCall) || ((RexCall)cond).getOperator().getKind() != SqlKind.EQUALS) continue;
                        RexNode left = (RexNode)((RexCall)cond).getOperands().get(0);
                        RexNode right = (RexNode)((RexCall)cond).getOperands().get(1);
                        Object object = left instanceof RexInputRef ? (RexInputRef)left : (inputRef = right instanceof RexInputRef ? (RexInputRef)right : null);
                        Object object2 = left instanceof RexFieldAccess ? (RexFieldAccess)left : (fieldAccess = right instanceof RexFieldAccess ? (RexFieldAccess)right : null);
                        if (inputRef == null || fieldAccess == null || !(fieldAccess.getReferenceExpr() instanceof RexCorrelVariable) || !((RexCorrelVariable)fieldAccess.getReferenceExpr()).id.equals((Object)func.correlationId())) continue;
                        mapping.set(fieldAccess.getField().getIndex(), inputRef.getIndex());
                    }
                    IgniteDistribution inputDistr = corrDistr.apply((Mappings.TargetMapping)mapping);
                    if (inputDistr == IgniteDistributions.random()) break block5;
                    return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)inputDistr)));
                }
            }
        }
        return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)distribution)));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.getInput());
        return planner.getCostFactory().makeCost(rowCount, rowCount * 4.0, 0.0);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteFilter(cluster, this.getTraitSet(), (RelNode)IgniteFilter.sole(inputs), this.getCondition());
    }
}

