/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;

public abstract class IgniteAggregate
extends Aggregate
implements IgniteRel {
    protected IgniteAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, groupSet, groupSets, aggCalls);
    }

    protected IgniteAggregate(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        Double groupsCnt = mq.getDistinctRowCount(this.getInput(), this.groupSet, null);
        if (groupsCnt != null) {
            return groupsCnt;
        }
        return super.estimateRowCount(mq);
    }

    public double estimateMemoryForGroup(RelMetadataQuery mq) {
        double mem = (double)this.groupSet.cardinality() * 4.0;
        if (!this.aggCalls.isEmpty()) {
            double grps = this.estimateRowCount(mq);
            double rows = this.input.estimateRowCount(mq);
            for (AggregateCall aggCall : this.aggCalls) {
                if (aggCall.isDistinct()) {
                    mem += 5.0 * rows / grps;
                    continue;
                }
                mem += 5.0;
            }
        }
        return mem;
    }

    public RelOptCost computeSelfCostHash(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double inRows = mq.getRowCount(this.getInput());
        double groups = this.estimateRowCount(mq);
        return costFactory.makeCost(inRows, inRows * 1.0, 0.0, groups * this.estimateMemoryForGroup(mq), 0.0);
    }

    public RelOptCost computeSelfCostSort(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double inRows = mq.getRowCount(this.getInput());
        return costFactory.makeCost(inRows, inRows * 1.0, 0.0, this.estimateMemoryForGroup(mq), 0.0);
    }
}

