/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteResource;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlValidator
extends SqlValidatorImpl {
    private static final BigDecimal DEC_INT_MAX = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final int MAX_LENGTH_OF_ALIASES = 256;
    private static final Set<SqlKind> HUMAN_READABLE_ALIASES_FOR;
    Object[] parameters;

    public IgniteSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, IgniteTypeFactory typeFactory, SqlValidator.Config config, Object[] parameters) {
        super(opTab, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, config);
        this.parameters = parameters;
    }

    public void validateInsert(SqlInsert insert) {
        this.validateTableModify(insert.getTargetTable());
        if (insert.getTargetColumnList() == null) {
            insert.setOperand(3, (SqlNode)this.inferColumnList(insert));
        }
        super.validateInsert(insert);
    }

    public void validateUpdate(SqlUpdate call) {
        this.validateTableModify(call.getTargetTable());
        this.validateUpdateFields(call);
        super.validateUpdate(call);
    }

    public void validateDelete(SqlDelete call) {
        this.validateTableModify(call.getTargetTable());
        super.validateDelete(call);
    }

    public void validateMerge(SqlMerge call) {
        this.validateTableModify(call.getTargetTable());
        super.validateMerge(call);
    }

    private void validateTableModify(SqlNode table) {
        SqlValidatorTable targetTable = this.getCatalogReader().getTable((List)((SqlIdentifier)table).names);
        if (targetTable == null) {
            throw this.newValidationError(table, Static.RESOURCE.objectNotFound(table.toString()));
        }
        if (!((IgniteTable)targetTable.unwrap(IgniteTable.class)).isModifiable()) {
            throw this.newValidationError(table, IgniteResource.INSTANCE.modifyTableNotSupported(table.toString()));
        }
    }

    public void validateLiteral(SqlLiteral literal) {
        if (literal.getTypeName() != SqlTypeName.DECIMAL) {
            super.validateLiteral(literal);
        }
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        SqlIdentifier targetTable = (SqlIdentifier)call.getTargetTable();
        SqlValidatorTable table = this.getCatalogReader().getTable((List)targetTable.names);
        if (table == null) {
            throw this.newValidationError((SqlNode)call, Static.RESOURCE.objectNotFound(targetTable.toString()));
        }
        SqlIdentifier alias = call.getAlias() != null ? call.getAlias() : new SqlIdentifier(this.deriveAlias((SqlNode)targetTable, 0), SqlParserPos.ZERO);
        ((IgniteTable)table.unwrap(IgniteTable.class)).descriptor().selectForUpdateRowType((IgniteTypeFactory)this.typeFactory).getFieldNames().stream().map(name -> alias.plus(name, SqlParserPos.ZERO)).forEach(arg_0 -> ((SqlNodeList)selectList).add(arg_0));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            selectList.add(SqlValidatorUtil.addAlias((SqlNode)exp, (String)SqlUtil.deriveAliasFromOrdinal((int)ordinal++)));
        }
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias((SqlNode)sourceTable, (String)call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null);
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = SqlNodeList.of((SqlNode)new SqlIdentifier("_KEY", SqlParserPos.ZERO));
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias((SqlNode)sourceTable, (String)call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null);
    }

    protected void validateSelect(SqlSelect select, RelDataType targetRowType) {
        this.checkIntegerLimit(select.getFetch(), "fetch / limit");
        this.checkIntegerLimit(select.getOffset(), "offset");
        super.validateSelect(select, targetRowType);
    }

    protected void validateNamespace(SqlValidatorNamespace namespace, RelDataType targetRowType) {
        IgniteCacheTable igniteTable;
        SqlValidatorTable table = namespace.getTable();
        if (table != null && (igniteTable = (IgniteCacheTable)table.unwrap(IgniteCacheTable.class)) != null) {
            igniteTable.ensureCacheStarted();
        }
        super.validateNamespace(namespace, targetRowType);
    }

    private void checkIntegerLimit(SqlNode n, String nodeName) {
        if (n instanceof SqlLiteral) {
            BigDecimal offFetchLimit = ((SqlLiteral)n).bigDecimalValue();
            if (offFetchLimit.compareTo(DEC_INT_MAX) > 0 || offFetchLimit.compareTo(BigDecimal.ZERO) < 0) {
                throw this.newValidationError(n, IgniteResource.INSTANCE.correctIntegerLimit(nodeName));
            }
        } else if (n instanceof SqlDynamicParam) {
            if (F.isEmpty((Object[])this.parameters)) {
                return;
            }
            int idx = ((SqlDynamicParam)n).getIndex();
            if (idx < this.parameters.length) {
                Object param = this.parameters[idx];
                if (this.parameters[idx] instanceof Integer && (Integer)param < 0) {
                    throw this.newValidationError(n, IgniteResource.INSTANCE.correctIntegerLimit(nodeName));
                }
            }
        }
    }

    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        String alias;
        if (call.getKind() == SqlKind.AS && this.isSystemFieldName(alias = this.deriveAlias((SqlNode)call, 0))) {
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.illegalAlias(alias));
        }
        super.validateCall(call, scope);
    }

    public String deriveAlias(SqlNode node, int ordinal) {
        if (node.isA(HUMAN_READABLE_ALIASES_FOR)) {
            String alias = node.toSqlString(c -> c.withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withAlwaysUseParentheses(false).withClauseStartsLine(false)).getSql();
            return alias.substring(0, Math.min(alias.length(), 256));
        }
        return super.deriveAlias(node, ordinal);
    }

    public void validateAggregateParams(SqlCall aggCall, @Nullable SqlNode filter, @Nullable SqlNodeList distinctList, @Nullable SqlNodeList orderList, SqlValidatorScope scope) {
        this.validateAggregateFunction(aggCall, (SqlAggFunction)aggCall.getOperator());
        super.validateAggregateParams(aggCall, filter, null, orderList, scope);
    }

    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlSelect select;
        if (node instanceof SqlSelect && (select = (SqlSelect)node).getFrom() instanceof SqlJoin) {
            boolean hasStar = false;
            for (SqlNode expr : select.getSelectList()) {
                if (!(expr instanceof SqlIdentifier) || !((SqlIdentifier)expr).isStar() || ((SqlIdentifier)expr).names.size() != 1) continue;
                hasStar = true;
            }
            this.performJoinRewrites((SqlJoin)select.getFrom(), hasStar);
        }
        return super.performUnconditionalRewrites(node, underFrom);
    }

    private void performJoinRewrites(SqlJoin join, boolean hasStar) {
        if (join.getLeft() instanceof SqlJoin) {
            this.performJoinRewrites((SqlJoin)join.getLeft(), hasStar || join.isNatural());
        }
        if (join.getRight() instanceof SqlJoin) {
            this.performJoinRewrites((SqlJoin)join.getRight(), hasStar || join.isNatural());
        }
        if (join.isNatural() || join.getConditionType() == JoinConditionType.USING && hasStar) {
            join.setLeft(this.rewriteTableToQuery(join.getLeft()));
            join.setRight(this.rewriteTableToQuery(join.getRight()));
        }
    }

    private SqlNode rewriteTableToQuery(SqlNode from) {
        SqlNode src;
        SqlNode sqlNode = src = from.getKind() == SqlKind.AS ? (SqlNode)((SqlCall)from).getOperandList().get(0) : from;
        if (src.getKind() == SqlKind.IDENTIFIER || src.getKind() == SqlKind.TABLE_REF) {
            String alias = this.deriveAlias(from, 0);
            SqlSelect expandedQry = new SqlSelect(SqlParserPos.ZERO, null, SqlNodeList.of((SqlNode)SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO)), src, null, null, null, null, null, null, null, null);
            return SqlValidatorUtil.addAlias((SqlNode)expandedQry, (String)alias);
        }
        return from;
    }

    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (includeSystemVars || exp.getKind() != SqlKind.IDENTIFIER || !this.isSystemFieldName(this.deriveAlias(exp, 0))) {
            super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
        }
    }

    public boolean isSystemField(RelDataTypeField field) {
        return this.isSystemFieldName(field.getName());
    }

    private void validateAggregateFunction(SqlCall call, SqlAggFunction aggFunction) {
        if (!SqlKind.AGGREGATE.contains(aggFunction.kind)) {
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.unsupportedAggregationFunction(aggFunction.getName()));
        }
        switch (aggFunction.kind) {
            case COUNT: {
                if (call.operandCount() > 1) {
                    throw this.newValidationError((SqlNode)call, Static.RESOURCE.invalidArgCount(aggFunction.getName(), 1));
                }
                return;
            }
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case ANY_VALUE: 
            case ARRAY_AGG: 
            case ARRAY_CONCAT_AGG: 
            case GROUP_CONCAT: 
            case LISTAGG: 
            case STRING_AGG: {
                return;
            }
        }
        throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.unsupportedAggregationFunction(aggFunction.getName()));
    }

    private SqlNodeList inferColumnList(SqlInsert call) {
        SqlValidatorTable table = this.table(this.validatedNamespace((SqlNode)call, this.unknownType));
        if (table == null) {
            return null;
        }
        CacheTableDescriptor desc = (CacheTableDescriptor)table.unwrap(CacheTableDescriptor.class);
        if (desc == null) {
            return null;
        }
        SqlNodeList columnList = new SqlNodeList(SqlParserPos.ZERO);
        for (RelDataTypeField field : desc.insertRowType(this.typeFactory()).getFieldList()) {
            columnList.add((SqlNode)new SqlIdentifier(field.getName(), SqlParserPos.ZERO));
        }
        return columnList;
    }

    private void validateUpdateFields(SqlUpdate call) {
        if (call.getTargetColumnList() == null) {
            return;
        }
        SqlValidatorNamespace ns = this.validatedNamespace((SqlNode)call, this.unknownType);
        SqlValidatorTable table = this.table(ns);
        if (table == null) {
            return;
        }
        CacheTableDescriptor desc = (CacheTableDescriptor)table.unwrap(CacheTableDescriptor.class);
        if (desc == null) {
            return;
        }
        RelDataType baseType = table.getRowType();
        RelOptTable relOptTable = this.relOptTable(ns);
        for (SqlNode node : call.getTargetColumnList()) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField target = SqlValidatorUtil.getTargetField((RelDataType)baseType, (RelDataTypeFactory)this.typeFactory(), (SqlIdentifier)id, (SqlValidatorCatalogReader)this.getCatalogReader(), (RelOptTable)relOptTable);
            if (target == null) {
                throw this.newValidationError((SqlNode)id, Static.RESOURCE.unknownTargetColumn(id.toString()));
            }
            if (desc.isUpdateAllowed(relOptTable, target.getIndex())) continue;
            throw this.newValidationError((SqlNode)id, IgniteResource.INSTANCE.cannotUpdateField(id.toString()));
        }
    }

    private SqlValidatorTable table(SqlValidatorNamespace ns) {
        RelOptTable relOptTable = this.relOptTable(ns);
        if (relOptTable != null) {
            return (SqlValidatorTable)relOptTable.unwrap(SqlValidatorTable.class);
        }
        return ns.getTable();
    }

    private RelOptTable relOptTable(SqlValidatorNamespace ns) {
        return SqlValidatorUtil.getRelOptTable((SqlValidatorNamespace)ns, (Prepare.CatalogReader)((Prepare.CatalogReader)this.getCatalogReader().unwrap(Prepare.CatalogReader.class)), null, null);
    }

    private SqlValidatorNamespace validatedNamespace(SqlNode node, RelDataType targetType) {
        SqlValidatorNamespace ns = this.getNamespace(node);
        this.validateNamespace(ns, targetType);
        return ns;
    }

    private IgniteTypeFactory typeFactory() {
        return (IgniteTypeFactory)this.typeFactory;
    }

    private boolean isSystemFieldName(String alias) {
        return "_KEY".equalsIgnoreCase(alias) || "_VAL".equalsIgnoreCase(alias);
    }

    protected void inferUnknownTypes(RelDataType inferredType, SqlValidatorScope scope, SqlNode node) {
        if (node instanceof SqlDynamicParam && inferredType.equals(this.unknownType)) {
            if (this.parameters.length > ((SqlDynamicParam)node).getIndex()) {
                Object param = this.parameters[((SqlDynamicParam)node).getIndex()];
                this.setValidatedNodeType(node, param == null ? this.typeFactory().createSqlType(SqlTypeName.NULL) : this.typeFactory().toSql(this.typeFactory().createType(param.getClass())));
            } else {
                this.setValidatedNodeType(node, this.typeFactory().createCustomType((Type)((Object)Object.class)));
            }
        } else if (node instanceof SqlCall) {
            SqlValidatorScope newScope = (SqlValidatorScope)this.scopes.get(node);
            if (newScope != null) {
                scope = newScope;
            }
            SqlCall call = (SqlCall)node;
            SqlOperandTypeInference operandTypeInference = call.getOperator().getOperandTypeInference();
            SqlOperandTypeChecker operandTypeChecker = call.getOperator().getOperandTypeChecker();
            SqlCallBinding callBinding = new SqlCallBinding((SqlValidator)this, scope, call);
            List operands = callBinding.operands();
            Object[] operandTypes = new RelDataType[operands.size()];
            Arrays.fill(operandTypes, this.unknownType);
            if (operandTypeInference != null) {
                operandTypeInference.inferOperandTypes(callBinding, inferredType, (RelDataType[])operandTypes);
            } else if (operandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker checker = (FamilyOperandTypeChecker)operandTypeChecker;
                for (int i = 0; i < checker.getOperandCountRange().getMax() && i < operandTypes.length; ++i) {
                    SqlTypeFamily family = checker.getOperandSqlTypeFamily(i);
                    RelDataType type = family.getDefaultConcreteType((RelDataTypeFactory)this.typeFactory());
                    if (type == null || !(operands.get(i) instanceof SqlDynamicParam)) continue;
                    operandTypes[i] = type;
                }
            }
            for (int i = 0; i < operands.size(); ++i) {
                SqlNode operand = (SqlNode)operands.get(i);
                if (operand == null) continue;
                this.inferUnknownTypes((RelDataType)operandTypes[i], scope, operand);
            }
        } else {
            super.inferUnknownTypes(inferredType, scope, node);
        }
    }

    static {
        EnumSet<SqlKind> kinds = EnumSet.noneOf(SqlKind.class);
        kinds.addAll(SqlKind.AGGREGATE);
        kinds.addAll(SqlKind.BINARY_ARITHMETIC);
        kinds.addAll(SqlKind.FUNCTION);
        kinds.add(SqlKind.CEIL);
        kinds.add(SqlKind.FLOOR);
        kinds.add(SqlKind.LITERAL);
        HUMAN_READABLE_ALIASES_FOR = Collections.unmodifiableSet(kinds);
    }
}

