/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MarshallingContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class ErrorMessage
implements MarshalableMessage {
    private UUID queryId;
    private long fragmentId;
    private byte[] errBytes;
    @GridDirectTransient
    private Throwable err;

    public ErrorMessage() {
    }

    public ErrorMessage(UUID queryId, long fragmentId, Throwable err) {
        assert (err != null);
        this.queryId = queryId;
        this.fragmentId = fragmentId;
        this.err = err;
    }

    public UUID queryId() {
        return this.queryId;
    }

    public long fragmentId() {
        return this.fragmentId;
    }

    public Throwable error() {
        assert (this.err != null);
        return this.err;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("fragmentId", this.fragmentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeUuid("queryId", this.queryId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.fragmentId = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.queryId = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ErrorMessage.class);
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_ERROR_MESSAGE;
    }

    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void prepareMarshal(MarshallingContext ctx) throws IgniteCheckedException {
        this.errBytes = ctx.marshal(this.err);
    }

    @Override
    public void prepareUnmarshal(MarshallingContext ctx) throws IgniteCheckedException {
        if (this.errBytes != null) {
            this.err = (Throwable)ctx.unmarshal(this.errBytes);
        }
    }
}

