/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.tracker;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.MemoryTracker;
import org.apache.ignite.internal.util.typedef.internal.A;

public class GlobalMemoryTracker
implements MemoryTracker {
    private final long quota;
    private final AtomicLong allocated = new AtomicLong();

    public GlobalMemoryTracker(long quota) {
        A.ensure((quota > 0L ? 1 : 0) != 0, (String)"quota > 0");
        this.quota = quota;
    }

    @Override
    public void onMemoryAllocated(long size) {
        if (this.allocated.addAndGet(size) > this.quota) {
            this.allocated.addAndGet(-size);
            throw new IgniteException("Global memory quota for SQL queries exceeded [quota=" + this.quota + ']');
        }
    }

    @Override
    public void onMemoryReleased(long size) {
        this.allocated.addAndGet(-size);
    }

    @Override
    public void reset() {
        this.allocated.set(0L);
    }

    @Override
    public long allocated() {
        return this.allocated.get();
    }
}

