/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ConverterUtils;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.IgniteRexBuilder;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.IgniteSqlFunctions;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RexImpTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteMethod;

public class RexToLixTranslator
implements RexVisitor<Result> {
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    private final RexProgram program;
    final SqlConformance conformance;
    private final Expression root;
    final InputGetter inputGetter;
    private final BlockBuilder list;
    private final Function1<String, InputGetter> correlates;
    private final Map<Expression, Expression> literalMap = new HashMap<Expression, Expression>();
    private final Map<RexCall, List<Result>> callOperandResultMap = new HashMap<RexCall, List<Result>>();
    private final Map<Pair<RexNode, Type>, Result> rexWithStorageTypeResultMap = new HashMap<Pair<RexNode, Type>, Result>();
    private final Map<RexNode, Result> rexResultMap = new HashMap<RexNode, Result>();
    private Type currentStorageType;

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, Expression root, InputGetter inputGetter, BlockBuilder list, RexBuilder builder, SqlConformance conformance, Function1<String, InputGetter> correlates) {
        this.program = program;
        this.typeFactory = Objects.requireNonNull(typeFactory);
        this.conformance = Objects.requireNonNull(conformance);
        this.root = Objects.requireNonNull(root);
        this.inputGetter = inputGetter;
        this.list = Objects.requireNonNull(list);
        this.builder = Objects.requireNonNull(builder);
        this.correlates = correlates;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, PhysType outputPhysType, Expression root, InputGetter inputGetter, Function1<String, InputGetter> correlates) {
        ArrayList<Type> storageTypes = null;
        if (outputPhysType != null) {
            RelDataType rowType = outputPhysType.getRowType();
            storageTypes = new ArrayList<Type>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                storageTypes.add(outputPhysType.getJavaFieldType(i));
            }
        }
        return new RexToLixTranslator(program, typeFactory, root, inputGetter, list, new IgniteRexBuilder((RelDataTypeFactory)typeFactory), conformance, null).setCorrelates(correlates).translateList(program.getProjectList(), storageTypes);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        return this.translate(expr, nullAs, null);
    }

    Expression translate(RexNode expr, Type storageType) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs, storageType);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        this.currentStorageType = storageType;
        Result result = (Result)expr.accept((RexVisitor)this);
        Expression translated = ConverterUtils.toInternal((Expression)result.valueVariable, storageType);
        assert (translated != null);
        if (RexImpTable.NullAs.NOT_POSSIBLE == nullAs && translated.type.equals(storageType)) {
            return translated;
        }
        return nullAs.handle(translated);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand) {
        Expression convert = null;
        switch (targetType.getSqlTypeName()) {
            case ANY: {
                convert = operand;
                break;
            }
            case DATE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_DATE.method, (Expression[])new Expression[]{operand});
                        break;
                    }
                    case TIMESTAMP: {
                        convert = Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.FLOOR_DIV.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)86400000L)}), Integer.TYPE);
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                    }
                }
                break;
            }
            case TIME: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_TIME.method, (Expression[])new Expression[]{operand});
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIME.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                        break;
                    }
                    case TIMESTAMP: {
                        convert = Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)86400000L)}), Integer.TYPE);
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                    }
                }
                break;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{operand});
                        break;
                    }
                    case TIME: {
                        convert = Expressions.call((Method)BuiltInMethod.TIME_STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIME_TO_STRING.method, (Expression[])new Expression[]{operand})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
                        break;
                    }
                    case TIMESTAMP: {
                        convert = Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{operand})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{operand}));
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand});
                        break;
                    }
                    case DATE: {
                        convert = Expressions.multiply((Expression)Expressions.convert_((Expression)operand, Long.TYPE), (Expression)Expressions.constant((Object)86400000L));
                        break;
                    }
                    case TIME: {
                        convert = Expressions.add((Expression)Expressions.multiply((Expression)Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{this.root}), Long.TYPE), (Expression)Expressions.constant((Object)86400000L)), (Expression)Expressions.convert_((Expression)operand, Long.TYPE));
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{this.root})}), operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                    }
                }
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{operand});
                        break;
                    }
                    case DATE: {
                        convert = Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{Expressions.multiply((Expression)Expressions.convert_((Expression)operand, Long.TYPE), (Expression)Expressions.constant((Object)86400000L))})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
                        break;
                    }
                    case TIME: {
                        convert = Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{Expressions.add((Expression)Expressions.multiply((Expression)Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{this.root}), Long.TYPE), (Expression)Expressions.constant((Object)86400000L)), (Expression)Expressions.convert_((Expression)operand, Long.TYPE))})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{this.root})}), operand}));
                        break;
                    }
                    case TIMESTAMP: {
                        convert = Expressions.call((Method)BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, (Expression[])new Expression[]{RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{operand})), Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})});
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call((Method)BuiltInMethod.STRING_TO_BOOLEAN.method, (Expression[])new Expression[]{operand});
                    }
                }
                break;
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_DATE_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break;
                    }
                    case TIME: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIME_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                        break;
                    }
                    case TIMESTAMP: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{this.root})}));
                        break;
                    }
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)interval.timeUnitRange)}));
                        break;
                    }
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)interval.timeUnitRange), Expressions.constant((Object)interval.getFractionalSecondPrecision(this.typeFactory.getTypeSystem()))}));
                        break;
                    }
                    case BOOLEAN: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)BuiltInMethod.BOOLEAN_TO_STRING.method, (Expression[])new Expression[]{operand}));
                        break;
                    }
                    case BINARY: 
                    case VARBINARY: {
                        convert = RexImpTable.optimize2(operand, (Expression)Expressions.call((Method)IgniteMethod.BYTESTRING_TO_STRING.method(), (Expression[])new Expression[]{operand}));
                    }
                }
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                switch (sourceType.getSqlTypeName().getFamily()) {
                    case CHARACTER: {
                        SqlIntervalQualifier intervalQualifier = targetType.getIntervalQualifier();
                        Method method = intervalQualifier.isYearMonth() ? IgniteMethod.PARSE_INTERVAL_YEAR_MONTH.method() : IgniteMethod.PARSE_INTERVAL_DAY_TIME.method();
                        convert = Expressions.call((Method)method, (Expression[])new Expression[]{operand, Expressions.new_(SqlIntervalQualifier.class, (Expression[])new Expression[]{Expressions.constant((Object)intervalQualifier.getStartUnit()), Expressions.constant((Object)intervalQualifier.getStartPrecisionPreservingDefault()), Expressions.constant((Object)intervalQualifier.getEndUnit()), Expressions.constant((Object)intervalQualifier.getFractionalSecondPrecisionPreservingDefault()), Expressions.field(null, SqlParserPos.class, (String)"ZERO")})});
                    }
                }
                break;
            }
            case BINARY: 
            case VARBINARY: {
                switch (sourceType.getSqlTypeName().getFamily()) {
                    case CHARACTER: {
                        convert = Expressions.call((Method)IgniteMethod.STRING_TO_BYTESTRING.method(), (Expression[])new Expression[]{operand});
                    }
                }
            }
        }
        if (targetType.getSqlTypeName() == SqlTypeName.DECIMAL) {
            convert = ConverterUtils.convertToDecimal(operand, targetType);
        }
        if (convert == null) {
            convert = ConverterUtils.convert(operand, this.typeFactory.getJavaClass(targetType));
        }
        boolean pad = false;
        boolean truncate = true;
        switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case BINARY: {
                pad = true;
            }
            case VARCHAR: 
            case VARBINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) break;
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: 
                    case VARBINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (SqlTypeUtil.comparePrecision((int)sourcePrecision, (int)targetPrecision) <= 0) {
                            truncate = false;
                        }
                        if (SqlTypeUtil.comparePrecision((int)sourcePrecision, (int)targetPrecision) < 0) break;
                        pad = false;
                    }
                }
                if (!truncate && !pad) break;
                convert = Expressions.call((Method)(pad ? BuiltInMethod.TRUNCATE_OR_PAD.method : BuiltInMethod.TRUNCATE.method), (Expression[])new Expression[]{convert, Expressions.constant((Object)targetPrecision)});
                break;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale >= sourceType.getScale()) break;
                convert = Expressions.call((Method)BuiltInMethod.ROUND_LONG.method, (Expression[])new Expression[]{convert, Expressions.constant((Object)((long)Math.pow(10.0, 3 - targetScale)))});
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                switch (sourceType.getSqlTypeName().getFamily()) {
                    case NUMERIC: {
                        BigDecimal multiplier = targetType.getSqlTypeName().getEndUnit().multiplier;
                        BigDecimal divider = BigDecimal.ONE;
                        convert = RexImpTable.multiplyDivide(convert, multiplier, divider);
                    }
                }
            }
        }
        return RexToLixTranslator.scaleIntervalToNumber(sourceType, targetType, convert);
    }

    public RexNode deref(RexNode expr) {
        if (expr instanceof RexLocalRef) {
            RexLocalRef ref = (RexLocalRef)expr;
            RexNode e2 = (RexNode)this.program.getExprList().get(ref.getIndex());
            assert (ref.getType().equals(e2.getType()));
            return e2;
        }
        return expr;
    }

    public static Expression translateLiteral(RexLiteral literal, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        if (literal.isNull()) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw new ControlFlowException();
                }
            }
            return RexImpTable.NULL_EXPR;
        }
        switch (nullAs) {
            case IS_NOT_NULL: {
                return RexImpTable.TRUE_EXPR;
            }
            case IS_NULL: {
                return RexImpTable.FALSE_EXPR;
            }
        }
        Class<Number> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)literal.getValueAs(BigDecimal.class);
                if (javaClass == Float.TYPE) {
                    return Expressions.constant((Object)bd, javaClass);
                }
                if (javaClass == Double.TYPE) {
                    return Expressions.constant((Object)bd, javaClass);
                }
                assert (javaClass == BigDecimal.class);
                return Expressions.call(IgniteSqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{Expressions.constant((Object)bd.toString()), Expressions.constant((Object)type.getPrecision()), Expressions.constant((Object)type.getScale())});
            }
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIME: 
            case DATE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                value2 = literal.getValueAs(Integer.class);
                javaClass = Integer.TYPE;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                value2 = literal.getValueAs(Long.class);
                javaClass = Long.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = literal.getValueAs(String.class);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                return Expressions.new_(ByteString.class, (Expression[])new Expression[]{Expressions.constant((Object)literal.getValueAs(byte[].class), byte[].class)});
            }
            case GEOMETRY: {
                throw new IllegalStateException("Unsupported data type: " + literal.getType());
            }
            case SYMBOL: {
                value2 = literal.getValueAs(Enum.class);
                javaClass = value2.getClass();
                break;
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr((Type)javaClass);
                Comparable value = (Comparable)literal.getValueAs(Comparable.class);
                value2 = primitive != null && value instanceof Number ? primitive.number((Number)((Object)value)) : value;
            }
        }
        return Expressions.constant((Object)value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        return this.translateList(operandList, nullAs, ConverterUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs, List<? extends Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Pair e : Pair.zip(operandList, storageTypes)) {
            list.add(this.translate((RexNode)e.left, nullAs, (Type)e.right));
        }
        return list;
    }

    public List<Expression> translateList(List<? extends RexNode> operandList) {
        return this.translateList(operandList, ConverterUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<? extends RexNode> operandList, List<? extends Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>(operandList.size());
        for (int i = 0; i < operandList.size(); ++i) {
            RexNode rex = operandList.get(i);
            Type desiredType = null;
            if (storageTypes != null) {
                desiredType = storageTypes.get(i);
            }
            Expression translate = this.translate(rex, desiredType);
            list.add(translate);
            if (desiredType == null && !this.isNullable(rex)) assert (!Primitive.isBox((Type)translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rex + ", " + translate.getType();
        }
        return list;
    }

    public boolean isNullable(RexNode e) {
        return e.getType().isNullable();
    }

    public RexToLixTranslator setBlock(BlockBuilder block) {
        if (block == this.list) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, block, this.builder, this.conformance, this.correlates);
    }

    public RexToLixTranslator setCorrelates(Function1<String, InputGetter> correlates) {
        if (this.correlates == correlates) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, this.builder, this.conformance, correlates);
    }

    public Expression getRoot() {
        return this.root;
    }

    private static Expression scaleIntervalToNumber(RelDataType sourceType, RelDataType targetType, Expression operand) {
        switch (targetType.getSqlTypeName().getFamily()) {
            case NUMERIC: {
                switch (sourceType.getSqlTypeName()) {
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        BigDecimal multiplier = BigDecimal.ONE;
                        BigDecimal divider = sourceType.getSqlTypeName().getEndUnit().multiplier;
                        return RexImpTable.multiplyDivide(operand, multiplier, divider);
                    }
                }
            }
        }
        return operand;
    }

    public Result visitInputRef(RexInputRef inputRef) {
        Pair key = Pair.of((Object)inputRef, (Object)this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        Expression valueExpression = this.inputGetter.field(this.list, inputRef.getIndex(), this.currentStorageType);
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName("input_value"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        Expression isNullExpression = this.checkNull((Expression)valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("input_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result);
        return new Result(isNullVariable, valueVariable);
    }

    public Result visitLocalRef(RexLocalRef localRef) {
        return (Result)this.deref((RexNode)localRef).accept((RexVisitor)this);
    }

    public Result visitLiteral(RexLiteral literal) {
        if (this.rexResultMap.containsKey(literal)) {
            return this.rexResultMap.get(literal);
        }
        ConstantExpression valueExpression = literal.isNull() ? this.getTypedNullLiteral(literal) : RexToLixTranslator.translateLiteral(literal, literal.getType(), this.typeFactory, RexImpTable.NullAs.NOT_POSSIBLE);
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName("literal_value"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        ConstantExpression isNullExpression = literal.isNull() ? RexImpTable.TRUE_EXPR : RexImpTable.FALSE_EXPR;
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("literal_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        this.literalMap.put((Expression)valueVariable, (Expression)valueExpression);
        Result result = new Result(isNullVariable, valueVariable);
        this.rexResultMap.put((RexNode)literal, result);
        return result;
    }

    private ConstantExpression getTypedNullLiteral(RexLiteral literal) {
        assert (literal.isNull());
        Class<Long> javaClass = this.typeFactory.getJavaClass(literal.getType());
        switch (literal.getType().getSqlTypeName()) {
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIME: 
            case DATE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                javaClass = Integer.class;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                javaClass = Long.class;
            }
        }
        return javaClass == null || javaClass == Void.class ? RexImpTable.NULL_EXPR : Expressions.constant(null, javaClass);
    }

    public Result visitCall(RexCall call) {
        if (this.rexResultMap.containsKey(call)) {
            return this.rexResultMap.get(call);
        }
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.CASE) {
            return this.implementCaseWhen(call);
        }
        if (operator == SqlStdOperatorTable.SEARCH) {
            return (Result)RexUtil.expandSearch((RexBuilder)this.builder, (RexProgram)this.program, (RexNode)call).accept((RexVisitor)this);
        }
        RexImpTable.RexCallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        List operandList = call.getOperands();
        List<Type> storageTypes = ConverterUtils.internalTypes(operandList);
        ArrayList<Result> operandResults = new ArrayList<Result>();
        for (int i = 0; i < operandList.size(); ++i) {
            Result operandResult = RexToLixTranslator.implementCallOperand((RexNode)operandList.get(i), storageTypes.get(i), this);
            operandResults.add(operandResult);
        }
        this.callOperandResultMap.put(call, operandResults);
        Result result = implementor.implement(this, call, operandResults);
        this.rexResultMap.put((RexNode)call, result);
        return result;
    }

    private static Result implementCallOperand(RexNode operand, Type storageType, RexToLixTranslator translator) {
        Type originalStorageType = translator.currentStorageType;
        translator.currentStorageType = storageType;
        Result operandResult = (Result)operand.accept((RexVisitor)translator);
        if (storageType != null) {
            operandResult = translator.toInnerStorageType(operandResult, storageType);
        }
        translator.currentStorageType = originalStorageType;
        return operandResult;
    }

    private static Expression implementCallOperand2(RexNode operand, Type storageType, RexToLixTranslator translator) {
        Type originalStorageType = translator.currentStorageType;
        translator.currentStorageType = storageType;
        Expression result = translator.translate(operand);
        translator.currentStorageType = originalStorageType;
        return result;
    }

    private Result implementCaseWhen(RexCall call) {
        Type returnType = this.typeFactory.getJavaClass(call.getType());
        ParameterExpression valueVariable = Expressions.parameter((Type)returnType, (String)this.list.newName("case_when_value"));
        this.list.add((Statement)Expressions.declare((int)0, (ParameterExpression)valueVariable, null));
        List operandList = call.getOperands();
        this.implementRecursively(this, operandList, valueVariable, 0);
        Expression isNullExpression = this.checkNull((Expression)valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("case_when_isNull"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexResultMap.put((RexNode)call, result);
        return result;
    }

    private void implementRecursively(RexToLixTranslator currentTranslator, List<RexNode> operandList, ParameterExpression valueVariable, int pos) {
        BlockBuilder currentBlockBuilder = currentTranslator.getBlockBuilder();
        List<Type> storageTypes = ConverterUtils.internalTypes(operandList);
        if (pos == operandList.size() - 1) {
            Expression res = RexToLixTranslator.implementCallOperand2(operandList.get(pos), storageTypes.get(pos), currentTranslator);
            currentBlockBuilder.add(Expressions.statement((Expression)Expressions.assign((Expression)valueVariable, (Expression)ConverterUtils.convert(res, valueVariable.getType()))));
            return;
        }
        RexNode testerNode = operandList.get(pos);
        Result testerResult = RexToLixTranslator.implementCallOperand(testerNode, storageTypes.get(pos), currentTranslator);
        BinaryExpression tester = Expressions.andAlso((Expression)Expressions.not((Expression)testerResult.isNullVariable), (Expression)testerResult.valueVariable);
        RexNode ifTrueNode = operandList.get(pos + 1);
        BlockBuilder ifTrueBlockBuilder = new BlockBuilder(true, currentBlockBuilder);
        RexToLixTranslator ifTrueTranslator = currentTranslator.setBlock(ifTrueBlockBuilder);
        Expression ifTrueRes = RexToLixTranslator.implementCallOperand2(ifTrueNode, storageTypes.get(pos + 1), ifTrueTranslator);
        ifTrueBlockBuilder.add(Expressions.statement((Expression)Expressions.assign((Expression)valueVariable, (Expression)ConverterUtils.convert(ifTrueRes, valueVariable.getType()))));
        BlockStatement ifTrue = ifTrueBlockBuilder.toBlock();
        if (pos + 1 == operandList.size() - 1) {
            currentBlockBuilder.add((Statement)Expressions.ifThen((Expression)tester, (Node)ifTrue));
            return;
        }
        BlockBuilder ifFalseBlockBuilder = new BlockBuilder(true, currentBlockBuilder);
        RexToLixTranslator ifFalseTranslator = currentTranslator.setBlock(ifFalseBlockBuilder);
        this.implementRecursively(ifFalseTranslator, operandList, valueVariable, pos + 2);
        BlockStatement ifFalse = ifFalseBlockBuilder.toBlock();
        currentBlockBuilder.add((Statement)Expressions.ifThenElse((Expression)tester, (Node)ifTrue, (Node)ifFalse));
    }

    private Result toInnerStorageType(Result result, Type storageType) {
        Expression valueExpression = ConverterUtils.toInternal((Expression)result.valueVariable, storageType);
        if (valueExpression.equals((Object)result.valueVariable)) {
            return result;
        }
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName(result.valueVariable.name + "_inner_type"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        ParameterExpression isNullVariable = result.isNullVariable;
        return new Result(isNullVariable, valueVariable);
    }

    public Result visitDynamicParam(RexDynamicParam dynamicParam) {
        Pair key = Pair.of((Object)dynamicParam, (Object)this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        Type storageType = this.currentStorageType != null ? this.currentStorageType : this.typeFactory.getJavaClass(dynamicParam.getType());
        Type paramType = ((IgniteTypeFactory)this.typeFactory).getResultClass(dynamicParam.getType());
        MethodCallExpression ctxGet = Expressions.call((Expression)this.root, (Method)IgniteMethod.CONTEXT_GET_PARAMETER_VALUE.method(), (Expression[])new Expression[]{Expressions.constant((Object)("?" + dynamicParam.getIndex())), Expressions.constant((Object)paramType)});
        Expression valueExpression = SqlTypeUtil.isDecimal((RelDataType)dynamicParam.getType()) ? ConverterUtils.convertToDecimal((Expression)ctxGet, dynamicParam.getType()) : ConverterUtils.convert((Expression)ctxGet, storageType);
        ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)this.list.newName("value_dynamic_param"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("isNull_dynamic_param"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)this.checkNull((Expression)valueVariable)));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result);
        return result;
    }

    public Result visitFieldAccess(RexFieldAccess fieldAccess) {
        Pair key = Pair.of((Object)fieldAccess, (Object)this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        RexNode target = this.deref(fieldAccess.getReferenceExpr());
        int fieldIndex = fieldAccess.getField().getIndex();
        String fieldName = fieldAccess.getField().getName();
        switch (target.getKind()) {
            case CORREL_VARIABLE: {
                if (this.correlates == null) {
                    throw new RuntimeException("Cannot translate " + fieldAccess + " since correlate variables resolver is not defined");
                }
                InputGetter getter = (InputGetter)this.correlates.apply((Object)((RexCorrelVariable)target).getName());
                Expression input = getter.field(this.list, fieldIndex, this.currentStorageType);
                Expression condition = this.checkNull(input);
                ParameterExpression valueVariable = Expressions.parameter((Type)input.getType(), (String)this.list.newName("corInp_value"));
                this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)input));
                ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)this.list.newName("corInp_isNull"));
                Expression isNullExpression = Expressions.condition((Expression)condition, (Expression)RexImpTable.TRUE_EXPR, (Expression)this.checkNull((Expression)valueVariable));
                this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
                Result result1 = new Result(isNullVariable, valueVariable);
                this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result1);
                return result1;
            }
        }
        RexNode rxIndex = this.builder.makeLiteral((Object)fieldIndex, this.typeFactory.createType(Integer.TYPE), true);
        RexNode rxName = this.builder.makeLiteral((Object)fieldName, this.typeFactory.createType(String.class), true);
        RexCall accessCall = (RexCall)this.builder.makeCall(fieldAccess.getType(), (SqlOperator)SqlStdOperatorTable.STRUCT_ACCESS, (List)ImmutableList.of((Object)target, (Object)rxIndex, (Object)rxName));
        Result result2 = (Result)accessCall.accept((RexVisitor)this);
        this.rexWithStorageTypeResultMap.put((Pair<RexNode, Type>)key, result2);
        return result2;
    }

    public Result visitOver(RexOver over) {
        throw new RuntimeException("cannot translate expression " + over);
    }

    public Result visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new RuntimeException("Cannot translate " + correlVariable + ". Correlated variables should always be referenced by field access");
    }

    public Result visitRangeRef(RexRangeRef rangeRef) {
        throw new RuntimeException("cannot translate expression " + rangeRef);
    }

    public Result visitSubQuery(RexSubQuery subQuery) {
        throw new RuntimeException("cannot translate expression " + subQuery);
    }

    public Result visitTableInputRef(RexTableInputRef fieldRef) {
        throw new RuntimeException("cannot translate expression " + fieldRef);
    }

    public Result visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return this.visitInputRef((RexInputRef)fieldRef);
    }

    Expression checkNull(Expression expr) {
        if (Primitive.flavor((Type)expr.getType()) == Primitive.Flavor.PRIMITIVE) {
            return RexImpTable.FALSE_EXPR;
        }
        return Expressions.equal((Expression)expr, (Expression)RexImpTable.NULL_EXPR);
    }

    Expression checkNotNull(Expression expr) {
        if (Primitive.flavor((Type)expr.getType()) == Primitive.Flavor.PRIMITIVE) {
            return RexImpTable.TRUE_EXPR;
        }
        return Expressions.notEqual((Expression)expr, (Expression)RexImpTable.NULL_EXPR);
    }

    BlockBuilder getBlockBuilder() {
        return this.list;
    }

    Expression getLiteral(Expression literalVariable) {
        return this.literalMap.get(literalVariable);
    }

    Object getLiteralValue(Expression expr) {
        if (expr instanceof ParameterExpression) {
            Expression constantExpr = this.literalMap.get(expr);
            return this.getLiteralValue(constantExpr);
        }
        if (expr instanceof ConstantExpression) {
            return ((ConstantExpression)expr).value;
        }
        return null;
    }

    List<Result> getCallOperandResult(RexCall call) {
        return this.callOperandResultMap.get(call);
    }

    Expression handleMethodCheckedExceptions(Expression callExpr) {
        ParameterExpression methodCall = Expressions.parameter((Type)callExpr.getType(), (String)this.list.newName("method_call"));
        this.list.add((Statement)Expressions.declare((int)16, (ParameterExpression)methodCall, null));
        Statement st = Expressions.statement((Expression)Expressions.assign((Expression)methodCall, (Expression)callExpr));
        ParameterExpression e = Expressions.parameter((int)0, Exception.class, (String)"e");
        NewExpression uncheckedException = Expressions.new_(RuntimeException.class, (Expression[])new Expression[]{e});
        CatchBlock cb = Expressions.catch_((ParameterExpression)e, (Statement)Expressions.throw_((Expression)uncheckedException));
        this.list.add((Statement)Expressions.tryCatch((Statement)st, (CatchBlock[])new CatchBlock[]{cb}));
        return methodCall;
    }

    public static class Result {
        final ParameterExpression isNullVariable;
        final ParameterExpression valueVariable;

        public Result(ParameterExpression isNullVariable, ParameterExpression valueVariable) {
            this.isNullVariable = isNullVariable;
            this.valueVariable = valueVariable;
        }
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2, Type var3);
    }
}

