/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.BiScalar;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeCondition;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.Scalar;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.SingleScalar;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AccumulatorsFactory;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.MultiBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.RangeBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteMethod;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class ExpressionFactoryImpl<Row>
implements ExpressionFactory<Row> {
    private static final Map<String, Scalar> SCALAR_CACHE = new GridBoundedConcurrentLinkedHashMap(1024);
    private final IgniteTypeFactory typeFactory;
    private final SqlConformance conformance;
    private final RexBuilder rexBuilder;
    private final RelDataType emptyType;
    private final RelDataType nullType;
    private final ExecutionContext<Row> ctx;

    public ExpressionFactoryImpl(ExecutionContext<Row> ctx, IgniteTypeFactory typeFactory, SqlConformance conformance, RexBuilder rexBuilder) {
        this.ctx = ctx;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
        this.rexBuilder = rexBuilder;
        this.emptyType = new RelDataTypeFactory.Builder((RelDataTypeFactory)this.typeFactory).build();
        this.nullType = typeFactory.createSqlType(SqlTypeName.NULL);
    }

    @Override
    public Supplier<List<AccumulatorWrapper<Row>>> accumulatorsFactory(AggregateType type, List<AggregateCall> calls, RelDataType rowType) {
        if (calls.isEmpty()) {
            return null;
        }
        return new AccumulatorsFactory<Row>(this.ctx, type, calls, rowType);
    }

    @Override
    public Comparator<Row> comparator(final RelCollation collation) {
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            return null;
        }
        return new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                RowHandler hnd = ExpressionFactoryImpl.this.ctx.rowHandler();
                Object unspecifiedVal = ExpressionFactoryImpl.this.ctx.unspecifiedValue();
                for (RelFieldCollation field : collation.getFieldCollations()) {
                    int fieldIdx = field.getFieldIndex();
                    int nullComparison = field.nullDirection.nullComparison;
                    Object c1 = hnd.get(fieldIdx, o1);
                    Object c2 = hnd.get(fieldIdx, o2);
                    if (c1 == unspecifiedVal || c2 == unspecifiedVal) {
                        return 0;
                    }
                    int res = field.direction == RelFieldCollation.Direction.ASCENDING ? ExpressionFactoryImpl.compare(c1, c2, nullComparison) : ExpressionFactoryImpl.compare(c2, c1, -nullComparison);
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        };
    }

    @Override
    public Comparator<Row> comparator(final List<RelFieldCollation> left, final List<RelFieldCollation> right) {
        if (F.isEmpty(left) || F.isEmpty(right) || left.size() != right.size()) {
            throw new IllegalArgumentException("Both inputs should be non-empty and have the same size: left=" + (left != null ? Integer.valueOf(left.size()) : "null") + ", right=" + (right != null ? Integer.valueOf(right.size()) : "null"));
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get((int)i).nullDirection.nullComparison != right.get((int)i).nullDirection.nullComparison) {
                throw new IllegalArgumentException("Can't be compared: left=" + left.get(i) + ", right=" + right.get(i));
            }
            if (left.get((int)i).direction == right.get((int)i).direction) continue;
            throw new IllegalArgumentException("Can't be compared: left=" + left.get(i) + ", right=" + right.get(i));
        }
        return new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                boolean hasNulls = false;
                RowHandler hnd = ExpressionFactoryImpl.this.ctx.rowHandler();
                for (int i = 0; i < left.size(); ++i) {
                    int res;
                    RelFieldCollation leftField = (RelFieldCollation)left.get(i);
                    RelFieldCollation rightField = (RelFieldCollation)right.get(i);
                    int lIdx = leftField.getFieldIndex();
                    int rIdx = rightField.getFieldIndex();
                    Object c1 = hnd.get(lIdx, o1);
                    Object c2 = hnd.get(rIdx, o2);
                    if (c1 == null && c2 == null) {
                        hasNulls = true;
                        continue;
                    }
                    int nullComparison = leftField.nullDirection.nullComparison;
                    int n = res = leftField.direction == RelFieldCollation.Direction.ASCENDING ? ExpressionFactoryImpl.compare(c1, c2, nullComparison) : ExpressionFactoryImpl.compare(c2, c1, -nullComparison);
                    if (res == 0) continue;
                    return res;
                }
                return hasNulls ? 1 : 0;
            }
        };
    }

    private static int compare(Object o1, Object o2, int nullComparison) {
        Comparable c1 = (Comparable)o1;
        Comparable c2 = (Comparable)o2;
        return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
    }

    @Override
    public Predicate<Row> predicate(RexNode filter, RelDataType rowType) {
        return new PredicateImpl(this.scalar(filter, rowType));
    }

    @Override
    public BiPredicate<Row, Row> biPredicate(RexNode filter, RelDataType rowType) {
        return new BiPredicateImpl(this.biScalar(filter, rowType));
    }

    @Override
    public Function<Row, Row> project(List<RexNode> projects, RelDataType rowType) {
        return new ProjectImpl(this.scalar(projects, rowType), this.ctx.rowHandler().factory(this.typeFactory, RexUtil.types(projects)));
    }

    @Override
    public Supplier<Row> rowSource(List<RexNode> values) {
        return new ValuesImpl(this.scalar(values, null), this.ctx.rowHandler().factory(this.typeFactory, Commons.transform(values, v -> v != null ? v.getType() : this.nullType)));
    }

    @Override
    public <T> Supplier<T> execute(RexNode node) {
        return new ValueImpl(this.scalar(node, null), this.ctx.rowHandler().factory(this.typeFactory.getJavaClass(node.getType())));
    }

    @Override
    public Iterable<Row> values(List<RexLiteral> values, RelDataType rowType) {
        RowHandler<Row> handler = this.ctx.rowHandler();
        RowHandler.RowFactory<Row> factory = handler.factory(this.typeFactory, rowType);
        int columns = rowType.getFieldCount();
        assert (values.size() % columns == 0);
        ArrayList<Class> types = new ArrayList<Class>(columns);
        for (RelDataType type : RelOptUtil.getFieldTypeList((RelDataType)rowType)) {
            types.add(Primitives.wrap((Class)((Class)this.typeFactory.getJavaClass(type))));
        }
        ArrayList<Row> rows = new ArrayList<Row>(values.size() / columns);
        Object currRow = null;
        for (int i = 0; i < values.size(); ++i) {
            int field = i % columns;
            if (field == 0) {
                Row Row = factory.create();
                currRow = Row;
                rows.add(Row);
            }
            RexLiteral literal = values.get(i);
            handler.set(field, currRow, literal.getValueAs((Class)types.get(field)));
        }
        return rows;
    }

    @Override
    public RangeIterable<Row> ranges(List<SearchBounds> searchBounds, RelCollation collation, RelDataType rowType) {
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.typeFactory, rowType);
        ArrayList<RangeCondition<Row>> ranges = new ArrayList<RangeCondition<Row>>();
        this.expandBounds(ranges, searchBounds, rowType, rowFactory, (List<Integer>)collation.getKeys(), 0, Arrays.asList(new RexNode[searchBounds.size()]), Arrays.asList(new RexNode[searchBounds.size()]), true, true);
        return new RangeIterableImpl(ranges, this.comparator(collation));
    }

    private void expandBounds(List<RangeCondition<Row>> ranges, List<SearchBounds> searchBounds, RelDataType rowType, RowHandler.RowFactory<Row> rowFactory, List<Integer> collationKeys, int collationKeyIdx, List<RexNode> curLower, List<RexNode> curUpper, boolean lowerInclude, boolean upperInclude) {
        if (collationKeyIdx >= collationKeys.size() || !lowerInclude && !upperInclude || searchBounds.get(collationKeys.get(collationKeyIdx)) == null) {
            ranges.add(new RangeConditionImpl(this.scalar(curLower, rowType), this.scalar(curUpper, rowType), lowerInclude, upperInclude, rowFactory));
            return;
        }
        int fieldIdx = collationKeys.get(collationKeyIdx);
        SearchBounds fieldBounds = searchBounds.get(fieldIdx);
        Collection<SearchBounds> fieldMultiBounds = fieldBounds instanceof MultiBounds ? ((MultiBounds)fieldBounds).bounds() : Collections.singleton(fieldBounds);
        for (SearchBounds fieldSingleBounds : fieldMultiBounds) {
            boolean fieldLowerInclude;
            boolean fieldUpperInclude;
            RexNode fieldLowerBound;
            RexNode fieldUpperBound;
            if (fieldSingleBounds instanceof ExactBounds) {
                fieldLowerBound = fieldUpperBound = ((ExactBounds)fieldSingleBounds).bound();
                fieldUpperInclude = true;
                fieldLowerInclude = true;
            } else if (fieldSingleBounds instanceof RangeBounds) {
                RangeBounds fieldRangeBounds = (RangeBounds)fieldSingleBounds;
                fieldLowerBound = fieldRangeBounds.lowerBound();
                fieldUpperBound = fieldRangeBounds.upperBound();
                fieldLowerInclude = fieldRangeBounds.lowerInclude();
                fieldUpperInclude = fieldRangeBounds.upperInclude();
            } else {
                throw new IllegalStateException("Unexpected bounds: " + fieldSingleBounds);
            }
            if (lowerInclude) {
                curLower.set(fieldIdx, fieldLowerBound);
            }
            if (upperInclude) {
                curUpper.set(fieldIdx, fieldUpperBound);
            }
            this.expandBounds(ranges, searchBounds, rowType, rowFactory, collationKeys, collationKeyIdx + 1, curLower, curUpper, lowerInclude && fieldLowerInclude, upperInclude && fieldUpperInclude);
        }
        curLower.set(fieldIdx, null);
        curLower.set(fieldIdx, null);
    }

    private SingleScalar scalar(RexNode node, RelDataType type) {
        return this.scalar((List<RexNode>)ImmutableList.of((Object)node), type);
    }

    private SingleScalar scalar(List<RexNode> nodes, RelDataType type) {
        return (SingleScalar)SCALAR_CACHE.computeIfAbsent(this.digest(nodes, type, false), k -> this.compile(nodes, type, false));
    }

    private BiScalar biScalar(RexNode node, RelDataType type) {
        ImmutableList nodes = ImmutableList.of((Object)node);
        return (BiScalar)SCALAR_CACHE.computeIfAbsent(this.digest((List<RexNode>)nodes, type, true), k -> this.compile((List<RexNode>)nodes, type, true));
    }

    private Scalar compile(List<RexNode> nodes, RelDataType type, boolean biInParams) {
        if (type == null) {
            type = this.emptyType;
        }
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        BitSet unspecifiedValues = new BitSet(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            RexNode node = nodes.get(i);
            if (node != null) {
                programBuilder.addProject(node, null);
                continue;
            }
            unspecifiedValues.set(i);
            programBuilder.addProject((RexNode)this.rexBuilder.makeNullLiteral(type == this.emptyType ? this.nullType : ((RelDataTypeField)type.getFieldList().get(i)).getType()), null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx_ = Expressions.parameter(ExecutionContext.class, (String)"ctx");
        ParameterExpression in1_ = Expressions.parameter(Object.class, (String)"in1");
        ParameterExpression in2_ = Expressions.parameter(Object.class, (String)"in2");
        ParameterExpression out_ = Expressions.parameter(Object.class, (String)"out");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx_, DataContext.class)));
        Expression hnd_ = builder.append("hnd", (Expression)Expressions.call((Expression)ctx_, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        CommonFieldGetter inputGetter = biInParams ? new BiFieldGetter(hnd_, (Expression)in1_, (Expression)in2_, type) : new FieldGetter(hnd_, (Expression)in1_, type);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx_, hnd_).build(nodes);
        List<Expression> projects = RexToLixTranslator.translateProjects(program, (JavaTypeFactory)this.typeFactory, this.conformance, builder, null, (Expression)ctx_, inputGetter, correlates);
        assert (nodes.size() == projects.size());
        for (int i = 0; i < projects.size(); ++i) {
            Expression val = unspecifiedValues.get(i) ? Expressions.call((Expression)ctx_, (Method)IgniteMethod.CONTEXT_UNSPECIFIED_VALUE.method(), (Expression[])new Expression[0]) : projects.get(i);
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)hnd_, (Method)IgniteMethod.ROW_HANDLER_SET.method(), (Expression[])new Expression[]{Expressions.constant((Object)i), out_, val})));
        }
        String methodName = biInParams ? IgniteMethod.BI_SCALAR_EXECUTE.method().getName() : IgniteMethod.SCALAR_EXECUTE.method().getName();
        ImmutableList params = biInParams ? ImmutableList.of((Object)ctx_, (Object)in1_, (Object)in2_, (Object)out_) : ImmutableList.of((Object)ctx_, (Object)in1_, (Object)out_);
        MethodDeclaration decl = Expressions.methodDecl((int)1, Void.TYPE, (String)methodName, (Iterable)params, (BlockStatement)builder.toBlock());
        Class clazz = biInParams ? BiScalar.class : SingleScalar.class;
        return Commons.compile(clazz, Expressions.toString((List)F.asList((Object)decl), (String)"\n", (boolean)false));
    }

    private String digest(List<RexNode> nodes, RelDataType type, boolean biParam) {
        final StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < nodes.size(); ++i) {
            if (i > 0) {
                b.append(';');
            }
            RexNode node = nodes.get(i);
            b.append(node);
            if (node == null) continue;
            b.append(':');
            b.append(node.getType().getFullTypeString());
            new RexShuttle(){

                public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                    b.append(", fldIdx=").append(fieldAccess.getField().getIndex());
                    return super.visitFieldAccess(fieldAccess);
                }

                public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
                    b.append(", paramType=").append(dynamicParam.getType().getFullTypeString());
                    return super.visitDynamicParam(dynamicParam);
                }
            }.apply(node);
        }
        b.append(", biParam=").append(biParam);
        b.append(']');
        if (type != null) {
            b.append(':').append(type.getFullTypeString());
        }
        return b.toString();
    }

    private class CorrelatesBuilder
    extends RexShuttle {
        private final BlockBuilder builder;
        private final Expression ctx_;
        private final Expression hnd_;
        private Map<String, FieldGetter> correlates;

        public CorrelatesBuilder(BlockBuilder builder, Expression ctx_, Expression hnd_) {
            this.builder = builder;
            this.hnd_ = hnd_;
            this.ctx_ = ctx_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Function1<String, RexToLixTranslator.InputGetter> build(Iterable<RexNode> nodes) {
            try {
                for (RexNode node : nodes) {
                    if (node == null) continue;
                    node.accept((RexVisitor)this);
                }
                Iterator<RexNode> iterator = this.correlates == null ? null : this.correlates::get;
                return iterator;
            }
            finally {
                this.correlates = null;
            }
        }

        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            Expression corr_ = this.builder.append("corr", (Expression)Expressions.call((Expression)this.ctx_, (Method)IgniteMethod.CONTEXT_GET_CORRELATED_VALUE.method(), (Expression[])new Expression[]{Expressions.constant((Object)variable.id.getId())}));
            if (this.correlates == null) {
                this.correlates = new HashMap<String, FieldGetter>();
            }
            this.correlates.put(variable.getName(), new FieldGetter(this.hnd_, corr_, variable.getType()));
            return variable;
        }
    }

    private abstract class CommonFieldGetter
    implements RexToLixTranslator.InputGetter {
        protected final Expression hnd_;
        protected final Expression row1_;
        protected final RelDataType rowType;

        protected abstract Expression fillExpressions(BlockBuilder var1, int var2);

        private CommonFieldGetter(Expression hnd_, Expression row_, RelDataType rowType) {
            this.hnd_ = hnd_;
            this.row1_ = row_;
            this.rowType = rowType;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type desiredType) {
            Expression fldExpression = this.fillExpressions(list, index);
            Class<Object> fieldType = ExpressionFactoryImpl.this.typeFactory.getJavaClass(((RelDataTypeField)this.rowType.getFieldList().get(index)).getType());
            if (desiredType == null) {
                desiredType = fieldType;
                fieldType = Object.class;
            } else if (fieldType != Date.class && fieldType != Time.class && fieldType != Timestamp.class) {
                fieldType = Object.class;
            }
            return EnumUtils.convert((Expression)fldExpression, (Type)((Object)fieldType), (Type)desiredType);
        }
    }

    private class FieldGetter
    extends CommonFieldGetter {
        private FieldGetter(Expression hnd_, Expression row1_, RelDataType rowType) {
            super(hnd_, row1_, rowType);
        }

        @Override
        protected Expression fillExpressions(BlockBuilder list, int index) {
            Expression row_ = list.append("row", this.row1_);
            MethodCallExpression field = Expressions.call((Expression)this.hnd_, (Method)IgniteMethod.ROW_HANDLER_GET.method(), (Expression[])new Expression[]{Expressions.constant((Object)index), row_});
            return field;
        }
    }

    private class BiFieldGetter
    extends CommonFieldGetter {
        private final Expression row2_;

        private BiFieldGetter(Expression hnd_, Expression row1_, Expression row2_, RelDataType rowType) {
            super(hnd_, row1_, rowType);
            this.row2_ = row2_;
        }

        @Override
        protected Expression fillExpressions(BlockBuilder list, int index) {
            Expression row1_ = list.append("row1", this.row1_);
            Expression row2_ = list.append("row2", this.row2_);
            MethodCallExpression field = Expressions.call((Method)IgniteMethod.ROW_HANDLER_BI_GET.method(), (Expression[])new Expression[]{this.hnd_, Expressions.constant((Object)index), row1_, row2_});
            return field;
        }
    }

    private class RangeIterableImpl
    implements RangeIterable<Row> {
        private final List<RangeCondition<Row>> ranges;
        private final Comparator<Row> comparator;
        private boolean sorted;

        public RangeIterableImpl(List<RangeCondition<Row>> ranges, Comparator<Row> comparator) {
            this.ranges = ranges;
            this.comparator = comparator;
        }

        @Override
        public boolean multiBounds() {
            return this.ranges.size() > 1;
        }

        @Override
        public Iterator<RangeCondition<Row>> iterator() {
            this.ranges.forEach(b -> ((RangeConditionImpl)b).clearCache());
            if (this.ranges.size() == 1) {
                if (((RangeConditionImpl)this.ranges.get(0)).skip()) {
                    return Collections.emptyIterator();
                }
                return this.ranges.iterator();
            }
            if (!this.sorted) {
                this.ranges.sort((o1, o2) -> this.comparator.compare(o1.lower(), o2.lower()));
                this.sorted = true;
            }
            return F.iterator(this.ranges.iterator(), (IgniteClosure & Serializable)r -> r, (boolean)true, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)r -> !((RangeConditionImpl)r).skip()});
        }
    }

    private class RangeConditionImpl
    implements RangeCondition<Row> {
        private final SingleScalar lowerBound;
        private final SingleScalar upperBound;
        private final boolean lowerInclude;
        private final boolean upperInclude;
        private Row lowerRow;
        private Row upperRow;
        private Boolean skip;
        private final RowHandler.RowFactory<Row> factory;

        private RangeConditionImpl(SingleScalar lowerBound, SingleScalar upperBound, boolean lowerInclude, boolean upperInclude, RowHandler.RowFactory<Row> factory) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.lowerInclude = lowerInclude;
            this.upperInclude = upperInclude;
            this.factory = factory;
        }

        @Override
        public Row lower() {
            return this.lowerRow != null ? this.lowerRow : (this.lowerRow = this.getRow(this.lowerBound));
        }

        @Override
        public Row upper() {
            return this.upperRow != null ? this.upperRow : (this.upperRow = this.getRow(this.upperBound));
        }

        @Override
        public boolean lowerInclude() {
            return this.lowerInclude;
        }

        @Override
        public boolean upperInclude() {
            return this.upperInclude;
        }

        private Row getRow(SingleScalar scalar) {
            Object res = this.factory.create();
            scalar.execute(ExpressionFactoryImpl.this.ctx, null, res);
            RowHandler hnd = ExpressionFactoryImpl.this.ctx.rowHandler();
            for (int i = 0; i < hnd.columnCount(res); ++i) {
                Object fldVal = hnd.get(i, res);
                if (fldVal == null) {
                    this.skip = Boolean.TRUE;
                }
                if (fldVal != ExpressionFactoryImpl.this.ctx.nullBound()) continue;
                hnd.set(i, res, null);
            }
            return res;
        }

        public void clearCache() {
            this.upperRow = null;
            this.lowerRow = null;
            this.skip = null;
        }

        public boolean skip() {
            if (this.skip == null) {
                this.lower();
                this.upper();
                if (this.skip == null) {
                    this.skip = Boolean.FALSE;
                }
            }
            return this.skip;
        }
    }

    private class ValueImpl<T>
    implements Supplier<T> {
        private final SingleScalar scalar;
        private final RowHandler.RowFactory<Row> factory;

        private ValueImpl(SingleScalar scalar, RowHandler.RowFactory<Row> factory) {
            this.scalar = scalar;
            this.factory = factory;
        }

        @Override
        public T get() {
            Object res = this.factory.create();
            this.scalar.execute(ExpressionFactoryImpl.this.ctx, null, res);
            return (T)ExpressionFactoryImpl.this.ctx.rowHandler().get(0, res);
        }
    }

    private class ValuesImpl
    implements Supplier<Row> {
        private final SingleScalar scalar;
        private final RowHandler.RowFactory<Row> factory;

        private ValuesImpl(SingleScalar scalar, RowHandler.RowFactory<Row> factory) {
            this.scalar = scalar;
            this.factory = factory;
        }

        @Override
        public Row get() {
            Object res = this.factory.create();
            this.scalar.execute(ExpressionFactoryImpl.this.ctx, null, res);
            return res;
        }
    }

    private class ProjectImpl
    implements Function<Row, Row> {
        private final SingleScalar scalar;
        private final RowHandler.RowFactory<Row> factory;

        private ProjectImpl(SingleScalar scalar, RowHandler.RowFactory<Row> factory) {
            this.scalar = scalar;
            this.factory = factory;
        }

        @Override
        public Row apply(Row r) {
            Object res = this.factory.create();
            this.scalar.execute(ExpressionFactoryImpl.this.ctx, r, res);
            return res;
        }
    }

    private class BiPredicateImpl
    extends AbstractScalarPredicate<BiScalar>
    implements BiPredicate<Row, Row> {
        private BiPredicateImpl(BiScalar scalar) {
            super(ExpressionFactoryImpl.this, scalar);
        }

        @Override
        public boolean test(Row r1, Row r2) {
            ((BiScalar)this.scalar).execute(ExpressionFactoryImpl.this.ctx, r1, r2, this.out);
            return Boolean.TRUE == this.hnd.get(0, this.out);
        }
    }

    private class PredicateImpl
    extends AbstractScalarPredicate<SingleScalar>
    implements Predicate<Row> {
        private PredicateImpl(SingleScalar scalar) {
            super(ExpressionFactoryImpl.this, scalar);
        }

        @Override
        public boolean test(Row r) {
            ((SingleScalar)this.scalar).execute(ExpressionFactoryImpl.this.ctx, r, this.out);
            return Boolean.TRUE == this.hnd.get(0, this.out);
        }
    }

    private static abstract class AbstractScalarPredicate<T extends Scalar> {
        protected final T scalar;
        protected final Row out;
        protected final RowHandler<Row> hnd;
        final /* synthetic */ ExpressionFactoryImpl this$0;

        private AbstractScalarPredicate(T scalar) {
            this.this$0 = var1_1;
            this.scalar = scalar;
            this.hnd = ((ExpressionFactoryImpl)var1_1).ctx.rowHandler();
            this.out = this.hnd.factory(((ExpressionFactoryImpl)var1_1).typeFactory, ((ExpressionFactoryImpl)var1_1).typeFactory.createJavaType(Boolean.class)).create();
        }
    }
}

