/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexPlainRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.calcite.exec.AbstractIndexScan;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.Nullable;

public class IndexScan<Row>
extends AbstractIndexScan<Row, IndexRow> {
    private final GridKernalContext kctx;
    private final GridCacheContext<?, ?> cctx;
    private final CacheTableDescriptor desc;
    private final RowHandler.RowFactory<Row> factory;
    private final AffinityTopologyVersion topVer;
    private final int[] parts;
    private final MvccSnapshot mvccSnapshot;
    private volatile List<GridDhtLocalPartition> reserved;
    private final ImmutableBitSet requiredColumns;
    protected final InlineIndex idx;
    private final ImmutableIntList idxFieldMapping;
    private final int[] fieldIdxMapping;
    private final Type[] fieldsStoreTypes;

    public IndexScan(ExecutionContext<Row> ectx, CacheTableDescriptor desc, InlineIndex idx, ImmutableIntList idxFieldMapping, int[] parts, RangeIterable<Row> ranges, @Nullable ImmutableBitSet requiredColumns) {
        this(ectx, desc, new TreeIndexWrapper(idx), idxFieldMapping, parts, ranges, requiredColumns);
    }

    protected IndexScan(ExecutionContext<Row> ectx, CacheTableDescriptor desc, TreeIndexWrapper treeIdx, ImmutableIntList idxFieldMapping, int[] parts, RangeIterable<Row> ranges, @Nullable ImmutableBitSet requiredColumns) {
        super(ectx, desc.rowType(ectx.getTypeFactory(), requiredColumns), treeIdx, ranges);
        this.desc = desc;
        this.idx = treeIdx.idx;
        this.cctx = desc.cacheContext();
        this.kctx = this.cctx.kernalContext();
        this.factory = ectx.rowHandler().factory(ectx.getTypeFactory(), this.rowType);
        this.topVer = ectx.topologyVersion();
        this.parts = parts;
        this.mvccSnapshot = ectx.mvccSnapshot();
        this.requiredColumns = requiredColumns;
        this.idxFieldMapping = idxFieldMapping;
        RelDataType srcRowType = desc.rowType(ectx.getTypeFactory(), null);
        IgniteTypeFactory typeFactory = ectx.getTypeFactory();
        this.fieldsStoreTypes = new Type[srcRowType.getFieldCount()];
        for (int i = 0; i < srcRowType.getFieldCount(); ++i) {
            this.fieldsStoreTypes[i] = typeFactory.getResultClass(((RelDataTypeField)srcRowType.getFieldList().get(i)).getType());
        }
        this.fieldIdxMapping = this.fieldToInlinedKeysMapping(srcRowType.getFieldCount());
    }

    private int[] fieldToInlinedKeysMapping(int srcFieldsCnt) {
        List inlinedKeys = this.idx.segment(0).rowHandler().inlineIndexKeyTypes();
        if (!this.cctx.config().isEagerTtl()) {
            return null;
        }
        if (inlinedKeys.size() < this.idx.segment(0).rowHandler().indexKeyDefinitions().size() || inlinedKeys.size() < (this.requiredColumns == null ? srcFieldsCnt : this.requiredColumns.cardinality())) {
            return null;
        }
        for (InlineIndexKeyType keyType : inlinedKeys) {
            if (keyType.keySize() >= 0 && keyType.type() != IndexKeyType.JAVA_OBJECT) continue;
            return null;
        }
        ImmutableBitSet reqCols = this.requiredColumns == null ? ImmutableBitSet.range((int)0, (int)srcFieldsCnt) : this.requiredColumns;
        int[] fieldIdxMapping = new int[this.rowType.getFieldCount()];
        int i = 0;
        int j = reqCols.nextSetBit(0);
        while (j != -1) {
            int keyIdx = this.idxFieldMapping.indexOf(j);
            if (keyIdx < 0 || keyIdx >= inlinedKeys.size()) {
                return null;
            }
            fieldIdxMapping[i] = keyIdx;
            j = reqCols.nextSetBit(j + 1);
            ++i;
        }
        return fieldIdxMapping;
    }

    @Override
    public synchronized Iterator<Row> iterator() {
        this.reserve();
        try {
            return super.iterator();
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    @Override
    protected IndexRow row2indexRow(Row bound) {
        if (bound == null) {
            return null;
        }
        InlineIndexRowHandler idxRowHnd = this.idx.segment(0).rowHandler();
        RowHandler<Row> rowHnd = this.ectx.rowHandler();
        IndexKey[] keys = new IndexKey[idxRowHnd.indexKeyDefinitions().size()];
        assert (keys.length >= this.idxFieldMapping.size()) : "Unexpected index keys [keys.length=" + keys.length + ", idxFieldMapping.size()=" + this.idxFieldMapping.size() + ']';
        boolean nullSearchRow = true;
        for (int i = 0; i < this.idxFieldMapping.size(); ++i) {
            int fieldIdx = this.idxFieldMapping.getInt(i);
            Object key = rowHnd.get(fieldIdx, bound);
            if (key == this.ectx.unspecifiedValue()) continue;
            key = TypeUtils.fromInternal(this.ectx, key, this.fieldsStoreTypes[fieldIdx]);
            keys[i] = IndexKeyFactory.wrap((Object)key, (IndexKeyType)((IndexKeyDefinition)idxRowHnd.indexKeyDefinitions().get(i)).idxType(), (CacheObjectValueContext)this.cctx.cacheObjectContext(), (IndexKeyTypeSettings)idxRowHnd.indexKeyTypeSettings());
            nullSearchRow = false;
        }
        return nullSearchRow ? null : new IndexPlainRowImpl(keys, idxRowHnd);
    }

    @Override
    protected Row indexRow2Row(IndexRow row) throws IgniteCheckedException {
        if (row.indexPlainRow()) {
            return this.inlineIndexRow2Row(row);
        }
        return this.desc.toRow(this.ectx, row.cacheDataRow(), this.factory, this.requiredColumns);
    }

    private Row inlineIndexRow2Row(IndexRow row) {
        RowHandler<Row> hnd = this.ectx.rowHandler();
        Row res = this.factory.create();
        for (int i = 0; i < this.fieldIdxMapping.length; ++i) {
            hnd.set(i, res, TypeUtils.toInternal(this.ectx, row.key(this.fieldIdxMapping[i]).key()));
        }
        return res;
    }

    @Override
    public void close() {
        this.release();
    }

    private synchronized void reserve() {
        List<GridDhtLocalPartition> toReserve;
        if (this.reserved != null) {
            return;
        }
        GridDhtPartitionTopology top = this.cctx.topology();
        top.readLock();
        GridDhtTopologyFuture topFut = top.topologyVersionFuture();
        boolean done = topFut.isDone();
        if (!done || topFut.topologyVersion().compareTo(this.topVer) < 0 || this.cctx.shared().exchange().lastAffinityChangedTopologyVersion(topFut.initialVersion()).compareTo(this.topVer) > 0) {
            top.readUnlock();
            throw new ClusterTopologyException("Topology was changed. Please retry on stable topology.");
        }
        if (this.cctx.isReplicated()) {
            int partsCnt = this.cctx.affinity().partitions();
            toReserve = new ArrayList<GridDhtLocalPartition>(partsCnt);
            for (int i = 0; i < partsCnt; ++i) {
                toReserve.add(top.localPartition(i));
            }
        } else if (this.cctx.isPartitioned()) {
            assert (this.parts != null);
            toReserve = new ArrayList<GridDhtLocalPartition>(this.parts.length);
            for (int i = 0; i < this.parts.length; ++i) {
                toReserve.add(top.localPartition(this.parts[i]));
            }
        } else {
            toReserve = Collections.emptyList();
        }
        this.reserved = new ArrayList<GridDhtLocalPartition>(toReserve.size());
        try {
            for (GridDhtLocalPartition part : toReserve) {
                if (part == null || !part.reserve()) {
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                if (part.state() != GridDhtPartitionState.OWNING) {
                    part.release();
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                this.reserved.add(part);
            }
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
        finally {
            top.readUnlock();
        }
    }

    private synchronized void release() {
        if (this.reserved == null) {
            return;
        }
        for (GridDhtLocalPartition part : this.reserved) {
            part.release();
        }
        this.reserved = null;
    }

    @Override
    protected IndexQueryContext indexQueryContext() {
        IndexingQueryFilterImpl filter = new IndexingQueryFilterImpl(this.kctx, this.topVer, this.parts);
        InlineIndexRowHandler rowHnd = this.idx.segment(0).rowHandler();
        InlineIndexRowFactory rowFactory = this.isInlineScan() ? new InlineIndexRowFactory(rowHnd.inlineIndexKeyTypes().toArray(new InlineIndexKeyType[0]), rowHnd) : null;
        BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter = this.isInlineScan() ? null : IndexScan.createNotExpiredRowFilter();
        return new IndexQueryContext((IndexingQueryFilter)filter, rowFilter, (BPlusTree.TreeRowFactory)rowFactory, this.mvccSnapshot);
    }

    public boolean isInlineScan() {
        return this.fieldIdxMapping != null;
    }

    public static BPlusTree.TreeRowClosure<IndexRow, IndexRow> createNotNullRowFilter(InlineIndex idx, final boolean checkExpired) {
        List inlineKeyTypes = idx.segment(0).rowHandler().inlineIndexKeyTypes();
        final InlineIndexKeyType keyType = F.isEmpty((Collection)inlineKeyTypes) ? null : (InlineIndexKeyType)inlineKeyTypes.get(0);
        return new BPlusTree.TreeRowClosure<IndexRow, IndexRow>(){

            public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                Boolean keyIsNull;
                if (!checkExpired && keyType != null && io instanceof InlineIO && (keyIsNull = keyType.isNull(pageAddr, io.offset(idx), ((InlineIO)io).inlineSize())) == Boolean.TRUE) {
                    return false;
                }
                IndexRow idxRow = (IndexRow)io.getLookupRow(tree, pageAddr, idx);
                if (checkExpired && idxRow.cacheDataRow().expireTime() > 0L && idxRow.cacheDataRow().expireTime() <= U.currentTimeMillis()) {
                    return false;
                }
                return idxRow.key(0).type() != IndexKeyType.NULL;
            }
        };
    }

    public static BPlusTree.TreeRowClosure<IndexRow, IndexRow> createNotExpiredRowFilter() {
        return (tree, io, pageAddr, idx) -> {
            IndexRow idxRow = (IndexRow)io.getLookupRow(tree, pageAddr, idx);
            return idxRow.cacheDataRow().expireTime() <= 0L || idxRow.cacheDataRow().expireTime() > U.currentTimeMillis();
        };
    }

    protected static class TreeIndexWrapper
    implements TreeIndex<IndexRow> {
        protected final InlineIndex idx;

        protected TreeIndexWrapper(InlineIndex idx) {
            this.idx = idx;
        }

        @Override
        public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, boolean lowerInclude, boolean upperInclude, IndexQueryContext qctx) {
            try {
                return this.idx.find(lower, upper, lowerInclude, upperInclude, qctx);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to find index rows", (Throwable)e);
            }
        }
    }

    private static class InlineIndexRowFactory
    implements BPlusTree.TreeRowFactory<IndexRow, IndexRow> {
        private final InlineIndexKeyType[] keyTypes;
        private final InlineIndexRowHandler idxRowHnd;
        private boolean useCacheRow;

        private InlineIndexRowFactory(InlineIndexKeyType[] keyTypes, InlineIndexRowHandler idxRowHnd) {
            this.keyTypes = keyTypes;
            this.idxRowHnd = idxRowHnd;
        }

        public IndexRow create(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
            if (this.useCacheRow) {
                return (IndexRow)io.getLookupRow(tree, pageAddr, idx);
            }
            int inlineSize = ((InlineIO)io).inlineSize();
            int rowOffset = io.offset(idx);
            int keyOffset = 0;
            IndexKey[] keys = new IndexKey[this.keyTypes.length];
            for (int keyIdx = 0; keyIdx < this.keyTypes.length; ++keyIdx) {
                InlineIndexKeyType keyType = this.keyTypes[keyIdx];
                if (!keyType.inlinedFullValue(pageAddr, rowOffset + keyOffset, inlineSize - keyOffset)) {
                    this.useCacheRow = true;
                    return (IndexRow)io.getLookupRow(tree, pageAddr, idx);
                }
                keys[keyIdx] = keyType.get(pageAddr, rowOffset + keyOffset, inlineSize - keyOffset);
                keyOffset += keyType.inlineSize(pageAddr, rowOffset + keyOffset);
            }
            return new IndexPlainRowImpl(keys, this.idxRowHnd);
        }
    }
}

