/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.metric.LongMetric;

public class CacheGroupIoView {
    private final CacheGroupContext grpCtx;
    private final MetricRegistry mreg;

    public CacheGroupIoView(CacheGroupContext grpCtx, MetricRegistry mreg) {
        this.grpCtx = grpCtx;
        this.mreg = mreg;
    }

    @Order
    public int cacheGroupId() {
        return this.grpCtx.groupId();
    }

    @Order(value=1)
    public String cacheGroupName() {
        return this.grpCtx.cacheOrGroupName();
    }

    @Order(value=2)
    public long physicalReads() {
        LongMetric metric = (LongMetric)this.mreg.findMetric("PHYSICAL_READS");
        return metric != null ? metric.value() : 0L;
    }

    @Order(value=3)
    public long logicalReads() {
        LongMetric metric = (LongMetric)this.mreg.findMetric("LOGICAL_READS");
        return metric != null ? metric.value() : 0L;
    }
}

