/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.aware;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexRebuildCacheInfo
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private boolean recreate;

    public IndexRebuildCacheInfo() {
    }

    public IndexRebuildCacheInfo(String cacheName, boolean recreate) {
        this.cacheName = cacheName;
        this.recreate = recreate;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeLongString(out, this.cacheName);
        out.writeBoolean(this.recreate);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readLongString(in);
        this.recreate = protoVer == 2 && in.readBoolean();
    }

    public String cacheName() {
        return this.cacheName;
    }

    public boolean recreate() {
        return this.recreate;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public String toString() {
        return S.toString(IndexRebuildCacheInfo.class, this);
    }
}

