/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.sql.SQLException;

public final class IgniteQueryErrorCode {
    public static final int UNKNOWN = 1;
    public static final int PARSING = 1001;
    public static final int UNSUPPORTED_OPERATION = 1002;
    public static final int UNEXPECTED_OPERATION = 2001;
    public static final int UNEXPECTED_ELEMENT_TYPE = 2002;
    public static final int KEY_UPDATE = 2003;
    public static final int TABLE_NOT_FOUND = 3001;
    public static final int NULL_TABLE_DESCRIPTOR = 3002;
    public static final int STMT_TYPE_MISMATCH = 3003;
    public static final int TABLE_DROP_FAILED = 3004;
    public static final int INDEX_ALREADY_EXISTS = 3005;
    public static final int INDEX_NOT_FOUND = 3006;
    public static final int TABLE_ALREADY_EXISTS = 3007;
    public static final int COLUMN_NOT_FOUND = 3008;
    public static final int COLUMN_ALREADY_EXISTS = 3009;
    public static final int CONVERSION_FAILED = 3013;
    public static final int QUERY_CANCELED = 3014;
    public static final int SCHEMA_NOT_FOUND = 3015;
    public static final int DB_UNRECOVERABLE_ERROR = 3016;
    public static final int DUPLICATE_KEY = 4001;
    public static final int CONCURRENT_UPDATE = 4002;
    public static final int NULL_KEY = 4003;
    public static final int NULL_VALUE = 4004;
    public static final int ENTRY_PROCESSING = 4005;
    public static final int CACHE_NOT_FOUND = 4006;
    public static final int TOO_LONG_KEY = 4007;
    public static final int TOO_LONG_VALUE = 4008;
    public static final int VALUE_SCALE_OUT_OF_RANGE = 4009;
    public static final int KEY_SCALE_OUT_OF_RANGE = 4010;
    public static final int CLUSTER_READ_ONLY_MODE_ENABLED = 4011;
    public static final int TRANSACTION_EXISTS = 5001;
    public static final int MVCC_DISABLED = 5002;
    public static final int TRANSACTION_TYPE_MISMATCH = 5003;
    public static final int TRANSACTION_COMPLETED = 5004;
    public static final int TRANSACTION_SERIALIZATION_ERROR = 5005;
    public static final int FIELD_TYPE_MISMATCH = 5006;

    private IgniteQueryErrorCode() {
    }

    public static SQLException createJdbcSqlException(String msg, int code) {
        return new SQLException(msg, IgniteQueryErrorCode.codeToSqlState(code));
    }

    public static String codeToSqlState(int statusCode) {
        switch (statusCode) {
            case 4001: 
            case 4007: 
            case 4008: 
            case 4009: 
            case 4010: {
                return "23000";
            }
            case 4003: 
            case 4004: {
                return "22004";
            }
            case 1002: {
                return "0A000";
            }
            case 3013: {
                return "0700B";
            }
            case 1001: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 3001: 
            case 3003: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: {
                return "42000";
            }
            case 5001: 
            case 5002: 
            case 5003: 
            case 5004: {
                return "25000";
            }
            case 5005: {
                return "40001";
            }
            case 3014: {
                return "57014";
            }
            case 4011: {
                return "90097";
            }
        }
        return "50000";
    }
}

