/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.IncrementalSnapshotFinishRecord;
import org.apache.ignite.internal.pagemem.wal.record.IncrementalSnapshotStartRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.ClusterSnapshotRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

abstract class IncrementalSnapshotProcessor {
    private final GridCacheSharedContext<?, ?> cctx;
    private final IgniteLogger log;
    private final String snpName;
    private final String snpPath;
    private final int incIdx;
    private final Set<Integer> cacheIds;

    IncrementalSnapshotProcessor(GridCacheSharedContext<?, ?> cctx, String snpName, String snpPath, int incIdx, Set<Integer> cacheIds) {
        this.cctx = cctx;
        this.snpName = snpName;
        this.snpPath = snpPath;
        this.incIdx = incIdx;
        this.cacheIds = cacheIds;
        this.log = cctx.logger(this.getClass());
    }

    void process(Consumer<DataEntry> dataEntryHnd, @Nullable Consumer<TxRecord> txHnd) throws IgniteCheckedException, IOException {
        IncrementalSnapshotMetadata meta = this.cctx.snapshotMgr().readIncrementalSnapshotMetadata(this.snpName, this.snpPath, this.incIdx);
        File[] segments = this.walSegments(meta.folderName());
        this.totalWalSegments(segments.length);
        UUID incSnpId = meta.requestId();
        File lastSeg = Arrays.stream(segments).map(File::toPath).max(Comparator.comparingLong(FileWriteAheadLogManager::segmentIndex)).orElseThrow(() -> new IgniteCheckedException("Last WAL segment wasn't found [snpName=" + this.snpName + ']')).toFile();
        IncrementalSnapshotFinishRecord incSnpFinRec = this.readFinishRecord(lastSeg, incSnpId);
        if (incSnpFinRec == null) {
            throw new IgniteCheckedException("System WAL record for incremental snapshot wasn't found [id=" + incSnpId + ", walSegFile=" + lastSeg + ']');
        }
        LongAdder applied = new LongAdder();
        this.initWalEntries(applied);
        this.processedWalSegments(0);
        HashSet<WALRecord.RecordType[]> recTypes = new HashSet<WALRecord.RecordType[]>(F.asList(new WALRecord.RecordType[]{WALRecord.RecordType.CLUSTER_SNAPSHOT, WALRecord.RecordType.INCREMENTAL_SNAPSHOT_START_RECORD, WALRecord.RecordType.INCREMENTAL_SNAPSHOT_FINISH_RECORD, WALRecord.RecordType.DATA_RECORD_V2}));
        if (txHnd != null) {
            recTypes.add((WALRecord.RecordType[])WALRecord.RecordType.TX_RECORD);
        }
        try (WALIterator it = this.walIter(this.log, recTypes, segments);){
            long startIdx = -1L;
            while (it.hasNext()) {
                IgniteBiTuple walRec = (IgniteBiTuple)it.next();
                WALRecord rec = (WALRecord)walRec.getValue();
                if (rec.type() != WALRecord.RecordType.CLUSTER_SNAPSHOT || !((ClusterSnapshotRecord)rec).clusterSnapshotName().equals(this.snpName)) continue;
                startIdx = ((WALPointer)walRec.getKey()).index();
                break;
            }
            if (startIdx < 0L) {
                throw new IgniteCheckedException("System WAL record for full snapshot wasn't found [snpName=" + this.snpName + ", walSegFile=" + segments[0] + ']');
            }
            UUID prevIncSnpId = this.incIdx > 1 ? this.cctx.snapshotMgr().readIncrementalSnapshotMetadata(this.snpName, this.snpPath, this.incIdx - 1).requestId() : null;
            IgnitePredicate<GridCacheVersion> txVerFilter = prevIncSnpId != null ? txVer -> true : txVer -> !incSnpFinRec.excluded().contains(txVer);
            long lastProcessedIdx = 0L;
            while (it.hasNext()) {
                TxRecord tx;
                WALRecord rec;
                IgniteBiTuple walRec = (IgniteBiTuple)it.next();
                long curIdx = ((WALPointer)walRec.getKey()).index();
                if (curIdx != lastProcessedIdx) {
                    this.processedWalSegments((int)(curIdx - startIdx));
                    lastProcessedIdx = curIdx;
                }
                if ((rec = (WALRecord)walRec.getValue()).type() == WALRecord.RecordType.INCREMENTAL_SNAPSHOT_START_RECORD) {
                    IncrementalSnapshotStartRecord startRec = (IncrementalSnapshotStartRecord)rec;
                    if (!startRec.id().equals(incSnpFinRec.id())) continue;
                    txVerFilter = v -> incSnpFinRec.included().contains(v);
                    continue;
                }
                if (rec.type() == WALRecord.RecordType.INCREMENTAL_SNAPSHOT_FINISH_RECORD) {
                    IncrementalSnapshotFinishRecord finRec = (IncrementalSnapshotFinishRecord)rec;
                    if (!finRec.id().equals(prevIncSnpId)) continue;
                    txVerFilter = txVer -> !incSnpFinRec.excluded().contains(txVer);
                    continue;
                }
                if (rec.type() == WALRecord.RecordType.DATA_RECORD_V2) {
                    DataRecord data = (DataRecord)rec;
                    for (DataEntry e : data.writeEntries()) {
                        if (!this.cacheIds.contains(e.cacheId()) || !txVerFilter.apply(e.nearXidVersion())) continue;
                        dataEntryHnd.accept(e);
                        applied.increment();
                    }
                    continue;
                }
                if (rec.type() != WALRecord.RecordType.TX_RECORD || !txVerFilter.apply((tx = (TxRecord)rec).nearXidVersion())) continue;
                txHnd.accept(tx);
            }
            this.processedWalSegments(segments.length);
        }
    }

    private File[] walSegments(String folderName) throws IgniteCheckedException {
        File[] segments = null;
        for (int i = 1; i <= this.incIdx; ++i) {
            File incSnpDir = this.cctx.snapshotMgr().incrementalSnapshotLocalDir(this.snpName, this.snpPath, i);
            if (!incSnpDir.exists()) {
                throw new IgniteCheckedException("Incremental snapshot doesn't exists [dir=" + incSnpDir + ']');
            }
            File incSnpWalDir = IgniteSnapshotManager.incrementalSnapshotWalsDir(incSnpDir, folderName);
            if (!incSnpWalDir.exists()) {
                throw new IgniteCheckedException("Incremental snapshot WAL directory doesn't exists [dir=" + incSnpWalDir + ']');
            }
            File[] incSegs = incSnpWalDir.listFiles(FileWriteAheadLogManager.WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER);
            if (incSegs == null) {
                throw new IgniteCheckedException("Failed to list WAL segments from snapshot directory [dir=" + incSnpDir + ']');
            }
            if (segments == null) {
                segments = incSegs;
                continue;
            }
            int segLen = segments.length;
            segments = Arrays.copyOf(segments, segLen + incSegs.length);
            System.arraycopy(incSegs, 0, segments, segLen, incSegs.length);
        }
        if (F.isEmpty(segments)) {
            throw new IgniteCheckedException("No WAL segments found for incremental snapshot [snpName=" + this.snpName + ", snpPath=" + this.snpPath + ", incrementIndex=" + this.incIdx + ']');
        }
        return segments;
    }

    @Nullable
    private IncrementalSnapshotFinishRecord readFinishRecord(File segment, UUID incSnpId) throws IgniteCheckedException {
        try (WALIterator it = this.walIter(this.log, Collections.singleton(WALRecord.RecordType.INCREMENTAL_SNAPSHOT_FINISH_RECORD), segment);){
            while (it.hasNext()) {
                IncrementalSnapshotFinishRecord finRec = (IncrementalSnapshotFinishRecord)((IgniteBiTuple)it.next()).getValue();
                if (!finRec.id().equals(incSnpId)) continue;
                IncrementalSnapshotFinishRecord incrementalSnapshotFinishRecord = finRec;
                return incrementalSnapshotFinishRecord;
            }
        }
        return null;
    }

    private WALIterator walIter(IgniteLogger log, Set<WALRecord.RecordType> types, File ... segments) throws IgniteCheckedException {
        return new IgniteWalIteratorFactory(log).iterator(new IgniteWalIteratorFactory.IteratorParametersBuilder().filter((recType, recPtr) -> types.contains(recType)).sharedContext(this.cctx).filesOrDirs(segments));
    }

    abstract void totalWalSegments(int var1);

    abstract void processedWalSegments(int var1);

    abstract void initWalEntries(LongAdder var1);
}

