/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.events.CacheRebalancingEvent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderCache;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheGroupMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManagerImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopologyImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.query.continuous.CounterSkipContext;
import org.apache.ignite.internal.processors.compress.CompressionHandler;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.StripedCompositeReadWriteLock;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.CacheTopologyValidatorProvider;
import org.jetbrains.annotations.Nullable;

public class CacheGroupContext {
    private final int grpId;
    private volatile UUID rcvdFrom;
    private volatile AffinityTopologyVersion locStartVer;
    private final CacheConfiguration<?, ?> ccfg;
    private final GridCacheSharedContext ctx;
    private volatile boolean affNode;
    private final CacheType cacheType;
    private final byte ioPlc;
    private final boolean depEnabled;
    private final boolean storeCacheId;
    private volatile List<GridCacheContext> caches = Collections.unmodifiableList(new ArrayList());
    private List<GridCacheContext> contQryCaches;
    private final StripedCompositeReadWriteLock listenerLock = new StripedCompositeReadWriteLock(Runtime.getRuntime().availableProcessors());
    private final IgniteLogger log;
    private volatile GridAffinityAssignmentCache aff;
    private volatile GridDhtPartitionTopologyImpl top;
    private volatile IgniteCacheOffheapManager offheapMgr;
    private volatile GridCachePreloader preldr;
    private final DataRegion dataRegion;
    private final boolean persistenceEnabled;
    private final CacheObjectContext cacheObjCtx;
    private final FreeList freeList;
    private final ReuseList reuseList;
    private volatile boolean drEnabled;
    private volatile boolean qryEnabled;
    private final boolean mvccEnabled;
    private volatile boolean localWalEnabled;
    private volatile boolean globalWalEnabled;
    private volatile boolean idxWalEnabled;
    private final AtomicBoolean recoveryMode;
    private final IoStatisticsHolder statHolderIdx;
    private final IoStatisticsHolder statHolderData;
    private volatile boolean hasAtomicCaches;
    private final CacheGroupMetricsImpl metrics;
    private final Collection<TopologyValidator> topValidators;
    private final CompressionHandler compressHandler;
    private volatile boolean preparedToStop;

    public CacheGroupContext(GridCacheSharedContext ctx, int grpId, UUID rcvdFrom, CacheType cacheType, CacheConfiguration ccfg, boolean affNode, DataRegion dataRegion, CacheObjectContext cacheObjCtx, FreeList freeList, ReuseList reuseList, AffinityTopologyVersion locStartVer, boolean persistenceEnabled, boolean walEnabled, boolean recoveryMode, CompressionHandler compressHandler) {
        assert (ccfg != null);
        assert (dataRegion != null || !affNode);
        assert (grpId != 0) : "Invalid group ID [cache=" + ccfg.getName() + ", grpName=" + ccfg.getGroupName() + ']';
        this.grpId = grpId;
        this.rcvdFrom = rcvdFrom;
        this.ctx = ctx;
        this.ccfg = ccfg;
        this.affNode = affNode;
        this.dataRegion = dataRegion;
        this.cacheObjCtx = cacheObjCtx;
        this.freeList = freeList;
        this.reuseList = reuseList;
        this.locStartVer = locStartVer;
        this.cacheType = cacheType;
        this.globalWalEnabled = walEnabled;
        this.persistenceEnabled = persistenceEnabled;
        this.localWalEnabled = true;
        this.idxWalEnabled = true;
        this.recoveryMode = new AtomicBoolean(recoveryMode);
        this.compressHandler = compressHandler;
        this.ioPlc = cacheType.ioPolicy();
        this.depEnabled = ctx.kernalContext().deploy().enabled() && !ctx.kernalContext().cacheObjects().isBinaryEnabled(ccfg);
        this.storeCacheId = affNode && dataRegion.config().getPageEvictionMode() != DataPageEvictionMode.DISABLED;
        this.mvccEnabled = false;
        this.log = ctx.kernalContext().log(this.getClass());
        this.metrics = new CacheGroupMetricsImpl(this);
        if (this.systemCache()) {
            this.statHolderIdx = IoStatisticsHolderNoOp.INSTANCE;
            this.statHolderData = IoStatisticsHolderNoOp.INSTANCE;
        } else {
            GridMetricManager mmgr = ctx.kernalContext().metric();
            this.statHolderIdx = new IoStatisticsHolderIndex(IoStatisticsType.HASH_INDEX, this.cacheOrGroupName(), "HASH_PK", mmgr);
            this.statHolderData = new IoStatisticsHolderCache(this.cacheOrGroupName(), grpId, mmgr);
        }
        this.hasAtomicCaches = ccfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC;
        this.topValidators = Collections.unmodifiableCollection(this.topologyValidators(ccfg, ctx.kernalContext().plugins()));
    }

    public boolean systemCache() {
        return !this.sharedGroup() && CU.isSystemCache(this.ccfg.getName());
    }

    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public boolean storeCacheIdInDataPage() {
        return this.storeCacheId;
    }

    public boolean deploymentEnabled() {
        return this.depEnabled;
    }

    public GridCachePreloader preloader() {
        return this.preldr;
    }

    public byte ioPolicy() {
        return this.ioPlc;
    }

    void onCacheStarted(GridCacheContext cctx) throws IgniteCheckedException {
        this.addCacheContext(cctx);
        this.offheapMgr.onCacheStarted(cctx);
    }

    public boolean hasCache(String cacheName) {
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cacheContext : caches) {
            if (!cacheContext.name().equals(cacheName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCacheContext(GridCacheContext cctx) {
        boolean add;
        assert (this.cacheType.userCache() == cctx.userCache()) : cctx.name();
        assert (this.grpId == cctx.groupId()) : cctx.name();
        CacheGroupContext cacheGroupContext = this;
        synchronized (cacheGroupContext) {
            ArrayList<GridCacheContext> copy = new ArrayList<GridCacheContext>(this.caches);
            assert (this.sharedGroup() || copy.isEmpty());
            add = copy.add(cctx);
            this.caches = Collections.unmodifiableList(copy);
        }
        assert (add) : cctx.name();
        if (!this.qryEnabled && QueryUtils.isEnabled(cctx.config())) {
            this.qryEnabled = true;
        }
        if (!this.drEnabled && cctx.isDrEnabled()) {
            this.drEnabled = true;
        }
        if (!this.hasAtomicCaches) {
            this.hasAtomicCaches = cctx.config().getAtomicityMode() == CacheAtomicityMode.ATOMIC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheContext(GridCacheContext cctx) {
        ArrayList<GridCacheContext> copy;
        CacheGroupContext cacheGroupContext = this;
        synchronized (cacheGroupContext) {
            copy = new ArrayList<GridCacheContext>(this.caches);
            for (GridCacheContext next : copy) {
                if (next != cctx) continue;
                assert (this.sharedGroup() || copy.size() == 1) : copy.size();
                copy.remove(next);
                break;
            }
            this.caches = Collections.unmodifiableList(copy);
        }
        if (QueryUtils.isEnabled(cctx.config())) {
            boolean qryEnabled = false;
            for (GridCacheContext cacheContext : copy) {
                if (!QueryUtils.isEnabled(cacheContext.config())) continue;
                qryEnabled = true;
                break;
            }
            this.qryEnabled = qryEnabled;
        }
        if (cctx.isDrEnabled()) {
            boolean drEnabled = false;
            for (GridCacheContext cacheContext : copy) {
                if (!QueryUtils.isEnabled(cacheContext.config())) continue;
                drEnabled = true;
                break;
            }
            this.drEnabled = drEnabled;
        }
    }

    public GridCacheContext singleCacheContext() {
        List<GridCacheContext> caches = this.caches;
        if (caches.isEmpty()) {
            return null;
        }
        assert (!this.sharedGroup() && caches.size() == 1) : "stopping=" + this.ctx.kernalContext().isStopping() + ", groupName=" + this.ccfg.getGroupName() + ", caches=" + caches;
        return caches.get(0);
    }

    public void unwindUndeploys() {
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            cctx.deploy().unwind(cctx);
        }
    }

    public boolean eventRecordable(int type) {
        return this.cacheType.userCache() && this.ctx.gridEvents().isRecordable(type);
    }

    public boolean userCache() {
        return this.cacheType.userCache();
    }

    public void addRebalanceEvent(int part, int type, ClusterNode discoNode, int discoType, long discoTs) {
        assert (discoNode != null);
        assert (type > 0);
        assert (discoType > 0);
        assert (discoTs > 0L);
        if (!this.eventRecordable(type)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(type));
        }
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            if (cctx.config().isEventsDisabled().booleanValue() || !cctx.recordEvent(type)) continue;
            cctx.gridEvents().record(new CacheRebalancingEvent(cctx.name(), cctx.localNode(), "Cache rebalancing event.", type, part, discoNode, discoType, discoTs));
        }
    }

    public void addUnloadEvent(int part) {
        if (!this.eventRecordable(83)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(83));
        }
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            if (cctx.config().isEventsDisabled().booleanValue()) continue;
            cctx.gridEvents().record(new CacheRebalancingEvent(cctx.name(), cctx.localNode(), "Cache unloading event.", 83, part, null, 0, 0L));
        }
    }

    public void addRebalanceSupplyEvent(int part) {
        if (!this.eventRecordable(87)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(87));
        }
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            if (cctx.config().isEventsDisabled().booleanValue()) continue;
            cctx.gridEvents().record(new CacheRebalancingEvent(cctx.name(), cctx.localNode(), "Cache partition supplied event.", 87, part, null, 0, 0L));
        }
    }

    public void addRebalanceMissEvent(int part) {
        if (!this.eventRecordable(88)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(88));
        }
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            if (cctx.config().isEventsDisabled().booleanValue()) continue;
            cctx.gridEvents().record(new CacheRebalancingEvent(cctx.name(), cctx.localNode(), "Cache partition missed event.", 88, part, null, 0, 0L));
        }
    }

    public void addCacheEvent(int part, KeyCacheObject key, UUID evtNodeId, int type, @Nullable CacheObject newVal, boolean hasNewVal, @Nullable CacheObject oldVal, boolean hasOldVal, boolean keepBinary) {
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            if (cctx.config().isEventsDisabled().booleanValue()) continue;
            cctx.events().addEvent(part, key, evtNodeId, null, null, null, type, newVal, hasNewVal, oldVal, hasOldVal, null, null, keepBinary);
        }
    }

    public boolean queriesEnabled() {
        return this.qryEnabled;
    }

    public boolean isDrEnabled() {
        return this.drEnabled;
    }

    public FreeList freeList() {
        return this.freeList;
    }

    public ReuseList reuseList() {
        return this.reuseList;
    }

    public CacheObjectContext cacheObjectContext() {
        return this.cacheObjCtx;
    }

    public GridCacheSharedContext<?, ?> shared() {
        return this.ctx;
    }

    public DataRegion dataRegion() {
        return this.dataRegion;
    }

    public boolean affinityNode() {
        return this.affNode;
    }

    public GridDhtPartitionTopology topology() {
        if (this.top == null) {
            throw new IllegalStateException("Topology is not initialized: " + this.cacheOrGroupName());
        }
        return this.top;
    }

    public boolean isTopologyLocked() {
        if (this.top == null) {
            return false;
        }
        return this.top.holdsLock();
    }

    public IgniteCacheOffheapManager offheap() {
        return this.offheapMgr;
    }

    public AffinityTopologyVersion localStartVersion() {
        return this.locStartVer;
    }

    public boolean isReplicated() {
        return this.ccfg.getCacheMode() == CacheMode.REPLICATED;
    }

    public CacheConfiguration config() {
        return this.ccfg;
    }

    public IgnitePredicate<ClusterNode> nodeFilter() {
        return this.ccfg.getNodeFilter();
    }

    Collection<?> configuredUserObjects() {
        return Arrays.asList(this.ccfg.getAffinity(), this.ccfg.getNodeFilter(), this.ccfg.getTopologyValidator());
    }

    public Collection<TopologyValidator> topologyValidators() {
        return this.topValidators;
    }

    public AffinityFunction affinityFunction() {
        return this.ccfg.getAffinity();
    }

    public GridAffinityAssignmentCache affinity() {
        return this.aff;
    }

    @Nullable
    public String name() {
        return this.ccfg.getGroupName();
    }

    public String cacheOrGroupName() {
        return CU.cacheOrGroupName(this.ccfg);
    }

    public int groupId() {
        return this.grpId;
    }

    public boolean sharedGroup() {
        return this.ccfg.getGroupName() != null;
    }

    public void onKernalStop() {
        if (!this.isRecoveryMode()) {
            this.aff.cancelFutures(new IgniteCheckedException("Failed to wait for topology update, node is stopping."));
            if (this.preldr != null) {
                this.preldr.onKernalStop();
            }
        }
        this.offheapMgr.onKernalStop();
    }

    void stopCache(GridCacheContext cctx, boolean destroy) {
        if (this.top != null) {
            this.top.onCacheStopped(cctx.cacheId());
        }
        this.offheapMgr.stopCache(cctx.cacheId(), destroy);
        this.removeCacheContext(cctx);
    }

    void stopGroup() {
        this.offheapMgr.stop();
        if (this.isRecoveryMode()) {
            return;
        }
        IgniteCheckedException err = new IgniteCheckedException("Failed to wait for topology update, cache (or node) is stopping.");
        this.aff.cancelFutures(err);
        this.preldr.onKernalStop();
        this.ctx.io().removeCacheGroupHandlers(this.grpId);
    }

    public void finishRecovery(AffinityTopologyVersion startVer, UUID originalReceivedFrom, boolean affinityNode) throws IgniteCheckedException {
        if (!this.recoveryMode.compareAndSet(true, false)) {
            return;
        }
        this.affNode = affinityNode;
        this.rcvdFrom = originalReceivedFrom;
        this.locStartVer = startVer;
        this.persistGlobalWalState(this.globalWalEnabled);
        this.initializeIO();
        this.ctx.affinity().onCacheGroupCreated(this);
    }

    public boolean isRecoveryMode() {
        return this.recoveryMode.get();
    }

    private void initializeIO() throws IgniteCheckedException {
        assert (!this.recoveryMode.get()) : "Couldn't initialize I/O handlers, recovery mode is on for group " + this;
        if (!this.ctx.kernalContext().clientNode()) {
            this.ctx.io().addCacheGroupHandler(this.groupId(), GridDhtAffinityAssignmentRequest.class, this::processAffinityAssignmentRequest);
        }
        this.preldr = new GridDhtPreloader(this);
        this.preldr.start();
    }

    public Set<Integer> cacheIds() {
        List<GridCacheContext> caches = this.caches;
        HashSet<Integer> ids = U.newHashSet(caches.size());
        for (GridCacheContext cctx : caches) {
            ids.add(cctx.cacheId());
        }
        return ids;
    }

    public List<GridCacheContext> caches() {
        return this.caches;
    }

    public boolean hasCaches() {
        List<GridCacheContext> caches = this.caches;
        return !caches.isEmpty();
    }

    public void onPartitionEvicted(int part) {
        List<GridCacheContext> caches = this.caches;
        for (GridCacheContext cctx : caches) {
            if (cctx.isDrEnabled()) {
                cctx.dr().partitionEvicted(part);
            }
            cctx.continuousQueries().onPartitionEvicted(part);
        }
    }

    public void addCacheWithContinuousQuery(GridCacheContext cctx) {
        assert (this.sharedGroup()) : this.cacheOrGroupName();
        assert (cctx.group() == this) : cctx.name();
        List<GridCacheContext> contQryCaches = this.contQryCaches;
        if (contQryCaches == null) {
            contQryCaches = new ArrayList<GridCacheContext>();
        }
        contQryCaches.add(cctx);
        this.contQryCaches = contQryCaches;
    }

    public void removeCacheWithContinuousQuery(GridCacheContext cctx) {
        assert (this.sharedGroup()) : this.cacheOrGroupName();
        assert (cctx.group() == this) : cctx.name();
        assert (this.listenerLock.isWriteLockedByCurrentThread());
        List<GridCacheContext> contQryCaches = this.contQryCaches;
        if (contQryCaches == null) {
            return;
        }
        contQryCaches.remove(cctx);
        if (contQryCaches.isEmpty()) {
            contQryCaches = null;
        }
        this.contQryCaches = contQryCaches;
    }

    public ReadWriteLock listenerLock() {
        return this.listenerLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartitionCounterUpdate(int cacheId, int part, long cntr, AffinityTopologyVersion topVer, boolean primary) {
        List<Runnable> procC;
        List<GridCacheContext> contQryCaches;
        assert (this.sharedGroup());
        this.listenerLock.readLock().lock();
        try {
            contQryCaches = this.contQryCaches;
        }
        finally {
            this.listenerLock.readLock().unlock();
        }
        if (contQryCaches == null) {
            return;
        }
        CounterSkipContext skipCtx = null;
        for (int i = 0; i < contQryCaches.size(); ++i) {
            GridCacheContext cctx = contQryCaches.get(i);
            if (cacheId == cctx.cacheId()) continue;
            skipCtx = cctx.continuousQueries().skipUpdateCounter(skipCtx, part, cntr, topVer, primary);
        }
        List<Runnable> list = procC = skipCtx != null ? skipCtx.processClosures() : null;
        if (procC != null) {
            this.ctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    for (Runnable c : procC) {
                        c.run();
                    }
                }
            });
        }
    }

    public boolean hasContinuousQueryCaches() {
        this.listenerLock.readLock().lock();
        try {
            List<GridCacheContext> contQryCaches = this.contQryCaches;
            boolean bl = !F.isEmpty(contQryCaches);
            return bl;
        }
        finally {
            this.listenerLock.readLock().unlock();
        }
    }

    public void start() throws IgniteCheckedException {
        GridAffinityAssignmentCache affCache = this.ctx.affinity().groupAffinity(this.grpId);
        this.aff = affCache == null ? GridAffinityAssignmentCache.create(this.ctx.kernalContext(), this.ccfg.getAffinity(), this.ccfg) : affCache;
        this.top = this.ctx.kernalContext().resource().resolve(new GridDhtPartitionTopologyImpl(this.ctx, this));
        this.metrics.onTopologyInitialized();
        try {
            this.offheapMgr = this.ctx.kernalContext().resource().resolve(this.persistenceEnabled ? new GridCacheOffheapManager() : new IgniteCacheOffheapManagerImpl());
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to initialize offheap manager", e);
        }
        this.offheapMgr.start(this.ctx, this);
        if (!this.isRecoveryMode()) {
            this.initializeIO();
            this.ctx.affinity().onCacheGroupCreated(this);
            this.ctx.evict().onCacheGroupStarted(this);
        }
    }

    public boolean persistenceEnabled() {
        return this.persistenceEnabled;
    }

    public boolean logDataRecords() {
        return this.walEnabled() && (this.persistenceEnabled || this.cdcEnabled());
    }

    public boolean cdcEnabled() {
        return this.dataRegion != null && this.dataRegion.config().isCdcEnabled();
    }

    private void processAffinityAssignmentRequest(final UUID nodeId, final GridDhtAffinityAssignmentRequest req) {
        IgniteInternalFuture<AffinityTopologyVersion> fut;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing affinity assignment request [node=" + nodeId + ", req=" + req + ']');
        }
        if ((fut = this.aff.readyFuture(req.topologyVersion())) != null) {
            fut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    CacheGroupContext.this.processAffinityAssignmentRequest0(nodeId, req);
                }
            });
        } else {
            this.processAffinityAssignmentRequest0(nodeId, req);
        }
    }

    private void processAffinityAssignmentRequest0(UUID nodeId, GridDhtAffinityAssignmentRequest req) {
        GridDhtAffinityAssignmentResponse res;
        AffinityTopologyVersion topVer = req.topologyVersion();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Affinity is ready for topology version, will send response [topVer=" + topVer + ", node=" + nodeId + ']');
        }
        try {
            AffinityAssignment assignment = this.aff.cachedAffinity(topVer);
            res = new GridDhtAffinityAssignmentResponse(req.futureId(), this.grpId, topVer, assignment.assignment());
            if (this.aff.centralizedAffinityFunction()) {
                assert (assignment.idealAssignment() != null);
                res.idealAffinityAssignment(assignment.idealAssignment());
            }
            if (req.sendPartitionsState()) {
                res.partitionMap(this.top.partitionMap(true));
            }
        }
        catch (IllegalStateException err) {
            res = new GridDhtAffinityAssignmentResponse(req.futureId(), this.grpId, topVer, Collections.emptyList());
            res.affinityAssignmentsError(new IgniteCheckedException("Failed to prepare the required affinity assignment [nodeId=" + nodeId + ", topVer=" + topVer + ']', err));
        }
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, (byte)4);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send affinity assignment response to remote node [node=" + nodeId + ']', e);
        }
    }

    public void onDisconnected(IgniteFuture reconnectFut) {
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(reconnectFut, "Failed to wait for topology update, client disconnected.");
        if (this.aff != null) {
            this.aff.cancelFutures(err);
        }
    }

    public boolean rebalanceEnabled() {
        return this.ccfg.getRebalanceMode() != CacheRebalanceMode.NONE;
    }

    public void onReconnected() {
        this.aff.onReconnected();
        if (this.top != null) {
            this.top.onReconnected();
        }
        this.preldr.onReconnected();
    }

    public String toString() {
        return "CacheGroupContext [grp=" + this.cacheOrGroupName() + ']';
    }

    public boolean walEnabled() {
        return this.localWalEnabled && this.globalWalEnabled;
    }

    public boolean localWalEnabled() {
        return this.localWalEnabled;
    }

    public boolean globalWalEnabled() {
        return this.globalWalEnabled;
    }

    public boolean indexWalEnabled() {
        return this.idxWalEnabled;
    }

    public void indexWalEnabled(boolean idxWalEnabled) {
        this.idxWalEnabled = idxWalEnabled;
    }

    public void globalWalEnabled(boolean enabled) {
        if (this.globalWalEnabled != enabled) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Global state for group durability has changed [name=" + this.cacheOrGroupName() + ", enabled=" + enabled + ']');
            }
            this.persistGlobalWalState(enabled);
            this.globalWalEnabled = enabled;
        }
    }

    public void localWalEnabled(boolean enabled, boolean persist) {
        if (this.localWalEnabled != enabled) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Local state for group durability has changed [name=" + this.cacheOrGroupName() + ", enabled=" + enabled + ']');
            }
            this.localWalEnabled = enabled;
        }
        if (persist) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Local state for group durability has been logged to WAL [name=" + this.cacheOrGroupName() + ", enabled=" + enabled + ']');
            }
            this.persistLocalWalState(enabled);
        }
    }

    private void persistGlobalWalState(boolean enabled) {
        this.shared().database().walEnabled(this.grpId, enabled, false);
    }

    private void persistLocalWalState(boolean enabled) {
        this.shared().database().walEnabled(this.grpId, enabled, true);
    }

    public IoStatisticsHolder statisticsHolderIdx() {
        return this.statHolderIdx;
    }

    public IoStatisticsHolder statisticsHolderData() {
        return this.statHolderData;
    }

    public boolean hasAtomicCaches() {
        return this.hasAtomicCaches;
    }

    public CacheGroupMetricsImpl metrics() {
        return this.metrics;
    }

    public void removeIOStatistic(boolean destroy) {
        if (this.statHolderData != IoStatisticsHolderNoOp.INSTANCE) {
            this.ctx.kernalContext().metric().remove(this.statHolderData.metricRegistryName(), destroy);
        }
        if (this.statHolderIdx != IoStatisticsHolderNoOp.INSTANCE) {
            this.ctx.kernalContext().metric().remove(this.statHolderIdx.metricRegistryName(), destroy);
        }
    }

    public IgniteWriteAheadLogManager wal() {
        return this.ctx.wal(this.cdcEnabled());
    }

    public CompressionHandler compressionHandler() {
        return this.compressHandler;
    }

    public void prepareToStop() {
        this.preparedToStop = true;
        this.offheap().prepareToStop();
    }

    public boolean isPreparedToStop() {
        return this.preparedToStop;
    }

    private Collection<TopologyValidator> topologyValidators(CacheConfiguration<?, ?> ccfg, IgnitePluginProcessor plugins) {
        CacheTopologyValidatorProvider[] topValidatorProviders;
        ArrayList<TopologyValidator> res = new ArrayList<TopologyValidator>();
        TopologyValidator ccfgTopValidator = ccfg.getTopologyValidator();
        if (ccfgTopValidator != null) {
            res.add(ccfgTopValidator);
        }
        if (F.isEmpty(topValidatorProviders = (CacheTopologyValidatorProvider[])plugins.extensions(CacheTopologyValidatorProvider.class))) {
            return res;
        }
        for (CacheTopologyValidatorProvider topValidatorProvider : topValidatorProviders) {
            TopologyValidator validator = topValidatorProvider.topologyValidator(this.cacheOrGroupName());
            if (validator == null) continue;
            res.add(validator);
        }
        return res;
    }
}

