/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.direct.DirectMessageReader;
import org.apache.ignite.internal.direct.DirectMessageWriter;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.communication.ChunkReceiver;
import org.apache.ignite.internal.managers.communication.FileReceiver;
import org.apache.ignite.internal.managers.communication.FileSender;
import org.apache.ignite.internal.managers.communication.GridDisconnectListener;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.managers.communication.GridIoMessageFactory;
import org.apache.ignite.internal.managers.communication.GridIoPolicy;
import org.apache.ignite.internal.managers.communication.GridIoSecurityAwareMessage;
import org.apache.ignite.internal.managers.communication.GridIoUserMessage;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.communication.IgniteIoTestMessage;
import org.apache.ignite.internal.managers.communication.IgniteMessageFactoryImpl;
import org.apache.ignite.internal.managers.communication.SessionChannelMessage;
import org.apache.ignite.internal.managers.communication.TraceRunnable;
import org.apache.ignite.internal.managers.communication.TransmissionCancelledException;
import org.apache.ignite.internal.managers.communication.TransmissionHandler;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.managers.communication.TransmissionPolicy;
import org.apache.ignite.internal.managers.communication.TransmissionReceiver;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccMessage;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.platform.message.PlatformMessageFilter;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessagesTable;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedCompositeReadWriteLock;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.nio.GridNioBackPressureControl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationListenerEx;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionRequestor;
import org.apache.ignite.spi.communication.tcp.internal.TcpConnectionRequestDiscoveryMessage;
import org.apache.ignite.spi.communication.tcp.internal.TcpInverseConnectionResponseMessage;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridIoManager
extends GridManagerAdapter<CommunicationSpi<Serializable>> {
    public static final String COMM_METRICS = MetricUtils.metricName("io", "communication");
    public static final String OUTBOUND_MSG_QUEUE_CNT = "OutboundMessagesQueueSize";
    public static final String SENT_MSG_CNT = "SentMessagesCount";
    public static final String SENT_BYTES_CNT = "SentBytesCount";
    public static final String RCVD_MSGS_CNT = "ReceivedMessagesCount";
    public static final String RCVD_BYTES_CNT = "ReceivedBytesCount";
    public static final MessageFactory[] EMPTY = new MessageFactory[0];
    public static final int MAX_CLOSED_TOPICS = 10240;
    public static final String DIRECT_PROTO_VER_ATTR = "comm.direct.proto.ver";
    public static final byte DIRECT_PROTO_VER = 3;
    private static final ThreadLocal<Byte> CUR_PLC = new ThreadLocal();
    private static final int DFLT_CHUNK_SIZE_BYTES = 262144;
    private final Object rcvMux = new Object();
    private final ConcurrentMap<Object, TransmissionHandler> topicTransmissionHnds = new ConcurrentHashMap<Object, TransmissionHandler>();
    private final ConcurrentMap<Object, ReceiverContext> rcvCtxs = new ConcurrentHashMap<Object, ReceiverContext>();
    private final ConcurrentMap<T2<UUID, IgniteUuid>, AtomicBoolean> senderStopFlags = new ConcurrentHashMap<T2<UUID, IgniteUuid>, AtomicBoolean>();
    private final FileIOFactory fileIoFactory = new RandomAccessFileIOFactory();
    private final int retryCnt;
    private final int netTimeoutMs;
    private final ConcurrentMap<Object, GridMessageListener> lsnrMap = new ConcurrentHashMap<Object, GridMessageListener>();
    private volatile GridMessageListener[] sysLsnrs;
    private final Object sysLsnrsMux = new Object();
    private final Collection<GridDisconnectListener> disconnectLsnrs = new ConcurrentLinkedQueue<GridDisconnectListener>();
    private final PoolProcessor pools;
    private GridLocalEventListener discoLsnr;
    private final ConcurrentMap<Object, ConcurrentMap<UUID, GridCommunicationMessageSet>> msgSetMap = new ConcurrentHashMap<Object, ConcurrentMap<UUID, GridCommunicationMessageSet>>();
    private volatile UUID locNodeId;
    private final ConcurrentMap<UUID, Deque<DelayedMessage>> waitMap = new ConcurrentHashMap<UUID, Deque<DelayedMessage>>();
    private CommunicationListenerEx<Serializable> commLsnr;
    private final Marshaller marsh;
    private final ReadWriteLock busyLock = new StripedCompositeReadWriteLock(Runtime.getRuntime().availableProcessors());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean started;
    private final GridBoundedConcurrentLinkedHashSet<Object> closedTopics = new GridBoundedConcurrentLinkedHashSet(10240, 10240, 0.75f, 256, ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q_OPTIMIZED_RMV);
    private MessageFactory msgFactory;
    private MessageFormatter formatter;
    private volatile boolean stopping;
    private final AtomicReference<ConcurrentHashMap<Long, IoTestFuture>> ioTestMap = new AtomicReference();
    private final AtomicLong ioTestId = new AtomicLong();
    private final TcpCommunicationInverseConnectionHandler invConnHandler = new TcpCommunicationInverseConnectionHandler();
    private static final IgniteRunnable NOOP = () -> {};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridIoManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new CommunicationSpi[]{ctx.config().getCommunicationSpi()});
        this.pools = ctx.pools();
        assert (this.pools != null);
        this.locNodeId = ctx.localNodeId();
        this.marsh = ctx.config().getMarshaller();
        Object object = this.sysLsnrsMux;
        synchronized (object) {
            this.sysLsnrs = new GridMessageListener[GridTopic.values().length];
        }
        this.retryCnt = ctx.config().getNetworkSendRetryCount();
        this.netTimeoutMs = (int)ctx.config().getNetworkTimeout();
    }

    public MessageFactory messageFactory() {
        assert (this.msgFactory != null);
        return this.msgFactory;
    }

    public MessageFormatter formatter() {
        assert (this.formatter != null);
        return this.formatter;
    }

    public void resetMetrics() {
        ((CommunicationSpi)this.getSpi()).resetMetrics();
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute(DIRECT_PROTO_VER_ATTR, (byte)3);
        MessageFormatter[] formatterExt = (MessageFormatter[])this.ctx.plugins().extensions(MessageFormatter.class);
        if (formatterExt != null && formatterExt.length > 0) {
            if (formatterExt.length > 1) {
                throw new IgniteCheckedException("More than one MessageFormatter extension is defined. Check your plugins configuration and make sure that only one of them provides custom message format.");
            }
            this.formatter = formatterExt[0];
        } else {
            this.formatter = new MessageFormatter(){

                @Override
                public MessageWriter writer(UUID rmtNodeId) throws IgniteCheckedException {
                    assert (rmtNodeId != null);
                    return new DirectMessageWriter(U.directProtocolVersion(GridIoManager.this.ctx, rmtNodeId));
                }

                @Override
                public MessageReader reader(UUID rmtNodeId, MessageFactory msgFactory) throws IgniteCheckedException {
                    return new DirectMessageReader(msgFactory, rmtNodeId != null ? U.directProtocolVersion(GridIoManager.this.ctx, rmtNodeId) : (byte)3);
                }
            };
        }
        MessageFactory[] msgs = (MessageFactory[])this.ctx.plugins().extensions(MessageFactory.class);
        if (msgs == null) {
            msgs = EMPTY;
        }
        ArrayList<MessageFactory> compMsgs = new ArrayList<MessageFactory>();
        compMsgs.add(new GridIoMessageFactory());
        for (IgniteComponentType compType : IgniteComponentType.values()) {
            MessageFactory f = compType.messageFactory();
            if (f == null) continue;
            compMsgs.add(f);
        }
        if (!compMsgs.isEmpty()) {
            msgs = F.concat(msgs, compMsgs.toArray(new MessageFactory[compMsgs.size()]));
        }
        this.msgFactory = new IgniteMessageFactoryImpl(msgs);
        CommunicationSpi spi = (CommunicationSpi)this.getSpi();
        if (spi instanceof TcpCommunicationSpi) {
            this.getTcpCommunicationSpi().setConnectionRequestor(this.invConnHandler);
        }
        this.startSpi();
        MetricRegistry ioMetric = this.ctx.metric().registry(COMM_METRICS);
        ioMetric.register(OUTBOUND_MSG_QUEUE_CNT, spi::getOutboundMessagesQueueSize, "Outbound messages queue size.");
        ioMetric.register(SENT_MSG_CNT, spi::getSentMessagesCount, "Sent messages count.");
        ioMetric.register(SENT_BYTES_CNT, spi::getSentBytesCount, "Sent bytes count.");
        ioMetric.register(RCVD_MSGS_CNT, spi::getReceivedMessagesCount, "Received messages count.");
        ioMetric.register(RCVD_BYTES_CNT, spi::getReceivedBytesCount, "Received bytes count.");
        this.commLsnr = new CommunicationListenerEx<Serializable>(){

            @Override
            public void onMessage(UUID nodeId, Serializable msg, IgniteRunnable msgC) {
                try {
                    GridIoManager.this.onMessage0(nodeId, (GridIoMessage)msg, msgC);
                }
                catch (ClassCastException ignored) {
                    U.error(GridIoManager.this.log, "Communication manager received message of unknown type (will ignore): " + msg.getClass().getName() + ". Most likely GridCommunicationSpi is being used directly, which is illegal - make sure to send messages only via GridProjection API.");
                }
            }

            @Override
            public void onDisconnected(UUID nodeId) {
                for (GridDisconnectListener lsnr : GridIoManager.this.disconnectLsnrs) {
                    lsnr.onNodeDisconnected(nodeId);
                }
            }

            @Override
            public void onChannelOpened(UUID rmtNodeId, Serializable initMsg, Channel channel) {
                try {
                    GridIoManager.this.onChannelOpened0(rmtNodeId, (GridIoMessage)initMsg, channel);
                }
                catch (ClassCastException ignored) {
                    U.error(GridIoManager.this.log, "Communication manager received message of unknown type (will ignore): " + initMsg.getClass().getName() + ". Most likely GridCommunicationSpi is being used directly, which is illegal - make sure to send messages only via GridProjection API.");
                }
            }
        };
        ((CommunicationSpi)this.getSpi()).setListener(this.commLsnr);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
        this.addMessageListener(GridTopic.TOPIC_IO_TEST, new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                ClusterNode node = GridIoManager.this.ctx.discovery().node(nodeId);
                if (node == null) {
                    return;
                }
                IgniteIoTestMessage msg0 = (IgniteIoTestMessage)msg;
                msg0.senderNodeId(nodeId);
                if (msg0.request()) {
                    IgniteIoTestMessage res = new IgniteIoTestMessage(msg0.id(), false, null);
                    res.flags(msg0.flags());
                    res.onRequestProcessed();
                    res.copyDataFromRequest(msg0);
                    try {
                        GridIoManager.this.sendToGridTopic(node, GridTopic.TOPIC_IO_TEST, (Message)res, (byte)2);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(GridIoManager.this.log, "Failed to send IO test response [msg=" + msg0 + "]", e);
                    }
                } else {
                    IoTestFuture fut = (IoTestFuture)GridIoManager.this.ioTestMap().get(msg0.id());
                    msg0.onResponseProcessed();
                    if (fut == null) {
                        U.warn(GridIoManager.this.log, "Failed to find IO test future [msg=" + msg0 + ']');
                    } else {
                        fut.onResponse(msg0);
                    }
                }
            }
        });
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        this.locNodeId = this.ctx.localNodeId();
        return super.onReconnected(clusterRestarted);
    }

    public IgniteInternalFuture sendIoTest(List<ClusterNode> nodes, byte[] payload, boolean procFromNioThread) {
        long id = this.ioTestId.getAndIncrement();
        IoTestFuture fut = new IoTestFuture(id, nodes.size());
        IgniteIoTestMessage msg = new IgniteIoTestMessage(id, true, payload);
        msg.processFromNioThread(procFromNioThread);
        this.ioTestMap().put(id, fut);
        for (int i = 0; i < nodes.size(); ++i) {
            ClusterNode node = nodes.get(i);
            try {
                this.sendToGridTopic(node, GridTopic.TOPIC_IO_TEST, (Message)msg, (byte)2);
                continue;
            }
            catch (IgniteCheckedException e) {
                this.ioTestMap().remove(msg.id());
                return new GridFinishedFuture(e);
            }
        }
        return fut;
    }

    public IgniteInternalFuture<List<IgniteIoTestMessage>> sendIoTest(ClusterNode node, byte[] payload, boolean procFromNioThread) {
        long id = this.ioTestId.getAndIncrement();
        IoTestFuture fut = new IoTestFuture(id, 1);
        IgniteIoTestMessage msg = new IgniteIoTestMessage(id, true, payload);
        msg.processFromNioThread(procFromNioThread);
        this.ioTestMap().put(id, fut);
        try {
            this.sendToGridTopic(node, GridTopic.TOPIC_IO_TEST, (Message)msg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            this.ioTestMap().remove(msg.id());
            return new GridFinishedFuture<List<IgniteIoTestMessage>>(e);
        }
        return fut;
    }

    private ConcurrentHashMap<Long, IoTestFuture> ioTestMap() {
        ConcurrentHashMap<Long, IoTestFuture> map = this.ioTestMap.get();
        if (map == null && !this.ioTestMap.compareAndSet(null, map = new ConcurrentHashMap())) {
            map = this.ioTestMap.get();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIoTest(final long warmup, final long duration, final int threads, final long latencyLimit, final int rangesCnt, final int payLoadSize, final boolean procFromNioThread, final List<ClusterNode> nodes) {
        ExecutorService svc = Executors.newFixedThreadPool(threads + 1);
        final AtomicBoolean warmupFinished = new AtomicBoolean();
        final AtomicBoolean done = new AtomicBoolean();
        final CyclicBarrier bar = new CyclicBarrier(threads + 1);
        final LongAdder cnt = new LongAdder();
        long sleepDuration = 5000L;
        final byte[] payLoad = new byte[payLoadSize];
        final Map[] res = new Map[threads];
        boolean failed = true;
        try {
            svc.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean failed = true;
                    try {
                        bar.await();
                        long start = System.currentTimeMillis();
                        if (GridIoManager.this.log.isInfoEnabled()) {
                            GridIoManager.this.log.info("IO test started [warmup=" + warmup + ", duration=" + duration + ", threads=" + threads + ", latencyLimit=" + latencyLimit + ", rangesCnt=" + rangesCnt + ", payLoadSize=" + payLoadSize + ", procFromNioThreads=" + procFromNioThread + ']');
                        }
                        while (true) {
                            if (!warmupFinished.get() && System.currentTimeMillis() - start > warmup) {
                                if (GridIoManager.this.log.isInfoEnabled()) {
                                    GridIoManager.this.log.info("IO test warmup finished.");
                                }
                                warmupFinished.set(true);
                                start = System.currentTimeMillis();
                            }
                            if (warmupFinished.get() && System.currentTimeMillis() - start > duration) {
                                if (GridIoManager.this.log.isInfoEnabled()) {
                                    GridIoManager.this.log.info("IO test finished, will wait for all threads to finish.");
                                }
                                break;
                            }
                            if (GridIoManager.this.log.isInfoEnabled()) {
                                GridIoManager.this.log.info("IO test [opsCnt/sec=" + cnt.sumThenReset() * 1000L / 5000L + ", warmup=" + !warmupFinished.get() + ", elapsed=" + (System.currentTimeMillis() - start) + ']');
                            }
                            Thread.sleep(5000L);
                        }
                        done.set(true);
                        bar.await();
                        failed = false;
                        GridIoManager.this.printIoTestResults(res);
                    }
                    catch (InterruptedException | BrokenBarrierException e) {
                        U.error(GridIoManager.this.log, "IO test failed.", e);
                    }
                    finally {
                        if (failed) {
                            bar.reset();
                        }
                    }
                }
            });
            for (int i = 0; i < threads; ++i) {
                final int i0 = i;
                res[i] = U.newHashMap(nodes.size());
                svc.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean failed = true;
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        int size = nodes.size();
                        Map res0 = res[i0];
                        try {
                            boolean warmupFinished0 = false;
                            bar.await();
                            while (!done.get()) {
                                if (!warmupFinished0) {
                                    warmupFinished0 = warmupFinished.get();
                                }
                                ClusterNode node = (ClusterNode)nodes.get(rnd.nextInt(size));
                                List<IgniteIoTestMessage> msgs = GridIoManager.this.sendIoTest(node, payLoad, procFromNioThread).get();
                                cnt.increment();
                                for (IgniteIoTestMessage msg : msgs) {
                                    UUID nodeId = msg.senderNodeId();
                                    assert (nodeId != null);
                                    IoTestThreadLocalNodeResults nodeRes = (IoTestThreadLocalNodeResults)res0.get(nodeId);
                                    if (nodeRes == null) {
                                        nodeRes = new IoTestThreadLocalNodeResults(rangesCnt, latencyLimit);
                                        res0.put(nodeId, nodeRes);
                                    }
                                    nodeRes.onResult(msg);
                                }
                            }
                            bar.await();
                            failed = false;
                        }
                        catch (Exception e) {
                            U.error(GridIoManager.this.log, "IO test worker thread failed.", e);
                        }
                        finally {
                            if (failed) {
                                bar.reset();
                            }
                        }
                    }
                });
            }
            failed = false;
        }
        finally {
            if (failed) {
                U.shutdownNow(GridIoManager.class, svc, this.log);
            }
        }
    }

    private void printIoTestResults(Map<UUID, IoTestThreadLocalNodeResults>[] rawRes) {
        HashMap<UUID, IoTestNodeResults> res = new HashMap<UUID, IoTestNodeResults>();
        for (Map<UUID, IoTestThreadLocalNodeResults> r : rawRes) {
            for (Map.Entry<UUID, IoTestThreadLocalNodeResults> e : r.entrySet()) {
                IoTestNodeResults r0 = (IoTestNodeResults)res.get(e.getKey());
                if (r0 == null) {
                    r0 = new IoTestNodeResults();
                    res.put(e.getKey(), r0);
                }
                r0.add(e.getValue());
            }
        }
        StringBuilder b = new StringBuilder(U.nl()).append("IO test results (round-trip count per each latency bin).").append(U.nl());
        for (Map.Entry e : res.entrySet()) {
            ClusterNode node = this.ctx.discovery().node((UUID)e.getKey());
            long binLatencyMcs = ((IoTestNodeResults)e.getValue()).binLatencyMcs();
            b.append("Node ID: ").append(e.getKey()).append(" (addrs=").append(node != null ? node.addresses().toString() : "n/a").append(", binLatency=").append(binLatencyMcs).append("mcs").append(')').append(U.nl());
            b.append("Latency bin, mcs | Count exclusive | Percentage exclusive | Count inclusive | Percentage inclusive ").append(U.nl());
            long[] nodeRes = ((IoTestNodeResults)e.getValue()).resLatency;
            long sum = 0L;
            for (int i = 0; i < nodeRes.length; ++i) {
                sum += nodeRes[i];
            }
            long curSum = 0L;
            for (int i = 0; i < nodeRes.length; ++i) {
                curSum += nodeRes[i];
                if (i < nodeRes.length - 1) {
                    b.append(String.format("<%11d mcs | %15d | %19.6f%% | %15d | %19.6f%%\n", (long)(i + 1) * binLatencyMcs, nodeRes[i], 100.0 * (double)nodeRes[i] / (double)sum, curSum, 100.0 * (double)curSum / (double)sum));
                    continue;
                }
                b.append(String.format(">%11d mcs | %15d | %19.6f%% | %15d | %19.6f%%\n", (long)i * binLatencyMcs, nodeRes[i], 100.0 * (double)nodeRes[i] / (double)sum, curSum, 100.0 * (double)curSum / (double)sum));
            }
            b.append(U.nl()).append("Total latency (ns): ").append(U.nl()).append(String.format("%15d", ((IoTestNodeResults)e.getValue()).totalLatency)).append(U.nl());
            b.append(U.nl()).append("Max latencies (ns):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxLatency);
            b.append(U.nl()).append("Max request send queue times (ns):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxReqSendQueueTime);
            b.append(U.nl()).append("Max request receive queue times (ns):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxReqRcvQueueTime);
            b.append(U.nl()).append("Max response send queue times (ns):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxResSendQueueTime);
            b.append(U.nl()).append("Max response receive queue times (ns):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxResRcvQueueTime);
            b.append(U.nl()).append("Max request wire times (millis):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxReqWireTimeMillis);
            b.append(U.nl()).append("Max response wire times (millis):").append(U.nl());
            GridIoManager.format(b, ((IoTestNodeResults)e.getValue()).maxResWireTimeMillis);
            b.append(U.nl());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(b.toString());
        }
    }

    private static void format(StringBuilder b, Collection<IgnitePair<Long>> pairs) {
        for (IgnitePair<Long> p : pairs) {
            b.append(String.format("%15d", p.get1())).append(" ").append(IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli((Long)p.get2()))).append(U.nl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onKernalStart0() throws IgniteCheckedException {
        this.discoLsnr = new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent) : "Invalid event: " + evt;
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                UUID nodeId = discoEvt.eventNode().id();
                switch (evt.type()) {
                    case 10: {
                        assert (GridIoManager.this.waitMap.get(nodeId) == null);
                        break;
                    }
                    case 11: 
                    case 12: {
                        GridIoManager.this.busyLock.readLock().lock();
                        try {
                            for (Map.Entry writeSesEntry : GridIoManager.this.senderStopFlags.entrySet()) {
                                if (!((UUID)((T2)writeSesEntry.getKey()).get1()).equals(nodeId)) continue;
                                ((AtomicBoolean)writeSesEntry.getValue()).set(true);
                            }
                            Iterator iterator = GridIoManager.this.rcvMux;
                            synchronized (iterator) {
                                Iterator it = GridIoManager.this.rcvCtxs.entrySet().iterator();
                                while (it.hasNext()) {
                                    Map.Entry e = it.next();
                                    if (!nodeId.equals(((ReceiverContext)e.getValue()).rmtNodeId)) continue;
                                    it.remove();
                                    GridIoManager.this.interruptReceiver((ReceiverContext)e.getValue(), new ClusterTopologyCheckedException("Remote node left the grid. Receiver has been stopped : " + nodeId));
                                }
                            }
                        }
                        finally {
                            GridIoManager.this.busyLock.readLock().unlock();
                        }
                        for (Map.Entry e : GridIoManager.this.msgSetMap.entrySet()) {
                            boolean empty;
                            GridCommunicationMessageSet set;
                            ConcurrentMap map;
                            ConcurrentMap concurrentMap = map = (ConcurrentMap)e.getValue();
                            synchronized (concurrentMap) {
                                set = (GridCommunicationMessageSet)map.remove(nodeId);
                                empty = map.isEmpty();
                            }
                            if (set != null) {
                                if (GridIoManager.this.log.isDebugEnabled()) {
                                    GridIoManager.this.log.debug("Removed message set due to node leaving grid: " + set);
                                }
                                GridIoManager.this.ctx.timeout().removeTimeoutObject(set);
                                GridIoManager.this.closedTopics.add(set.topic());
                            }
                            if (!empty) continue;
                            GridIoManager.this.msgSetMap.remove(e.getKey(), map);
                        }
                        GridIoManager.this.lock.writeLock().lock();
                        try {
                            Deque waitList = (Deque)GridIoManager.this.waitMap.remove(nodeId);
                            if (!GridIoManager.this.log.isDebugEnabled()) break;
                            GridIoManager.this.log.debug("Removed messages from discovery startup delay list (sender node left topology): " + waitList);
                            break;
                        }
                        finally {
                            GridIoManager.this.lock.writeLock().unlock();
                        }
                    }
                    default: {
                        assert (false) : "Unexpected event: " + evt;
                        break;
                    }
                }
            }
        };
        this.ctx.event().addLocalEventListener(this.discoLsnr, 10, 11, 12);
        this.invConnHandler.onStart();
        ArrayList<Object> delayedMsgs = new ArrayList<Object>();
        this.lock.writeLock().lock();
        try {
            this.started = true;
            for (Map.Entry entry : this.waitMap.entrySet()) {
                if (this.ctx.discovery().node((UUID)entry.getKey()) == null) continue;
                Deque waitList = (Deque)this.waitMap.remove(entry.getKey());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Processing messages from discovery startup delay list: " + waitList);
                }
                if (waitList == null) continue;
                delayedMsgs.add(waitList);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (!delayedMsgs.isEmpty()) {
            for (Collection collection : delayedMsgs) {
                for (DelayedMessage msg : collection) {
                    this.commLsnr.onMessage(msg.nodeId(), msg.message(), msg.callback());
                }
            }
        }
        for (Map.Entry entry : this.msgSetMap.entrySet()) {
            boolean rmv;
            ConcurrentMap map = (ConcurrentMap)entry.getValue();
            for (GridCommunicationMessageSet set : map.values()) {
                void rmv2;
                if (this.ctx.discovery().node(set.nodeId()) != null) continue;
                ConcurrentMap concurrentMap = map;
                synchronized (concurrentMap) {
                    boolean rmv22 = map.remove(set.nodeId(), set);
                }
                if (rmv2 == false) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Removed message set due to node leaving grid: " + set);
                }
                this.ctx.timeout().removeTimeoutObject(set);
            }
            ConcurrentMap concurrentMap = map;
            synchronized (concurrentMap) {
                rmv = map.isEmpty();
            }
            if (!rmv) continue;
            this.msgSetMap.remove(entry.getKey(), map);
            this.closedTopics.add(entry.getKey());
        }
    }

    private boolean isPairedConnection(ClusterNode node, TcpCommunicationSpi tcpCommSpi) {
        return tcpCommSpi.isUsePairedConnections() && Boolean.TRUE.equals(node.attribute(U.spiAttribute(tcpCommSpi, "comm.tcp.pairedConnection")));
    }

    private TcpCommunicationSpi getTcpCommunicationSpi() {
        CommunicationSpi spi = (CommunicationSpi)this.getSpi();
        assert (spi instanceof TcpCommunicationSpi);
        return (TcpCommunicationSpi)spi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStop0(boolean cancel) {
        ((CommunicationSpi)this.getSpi()).setListener(null);
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.busyLock.writeLock().tryLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        try {
            HashSet rcvs;
            GridEventStorageManager evtMgr;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if ((evtMgr = this.ctx.event()) != null && this.discoLsnr != null) {
                evtMgr.removeLocalEventListener(this.discoLsnr, new int[0]);
            }
            this.stopping = true;
            Iterator iterator = this.rcvMux;
            synchronized (iterator) {
                this.topicTransmissionHnds.clear();
                rcvs = new HashSet(this.rcvCtxs.values());
                this.rcvCtxs.clear();
            }
            for (ReceiverContext rctx : rcvs) {
                this.interruptReceiver(rctx, new NodeStoppingException("Local node io manager requested to be stopped: " + this.ctx.localNodeId()));
            }
        }
        finally {
            this.busyLock.writeLock().unlock();
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        this.invConnHandler.onStop();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChannelOpened0(final UUID rmtNodeId, final GridIoMessage initMsg, final Channel channel) {
        Lock busyLock0 = this.busyLock.readLock();
        busyLock0.lock();
        try {
            if (this.stopping) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received communication channel create event while node stopping (will ignore) [rmtNodeId=" + rmtNodeId + ", initMsg=" + initMsg + ']');
                }
                return;
            }
            if (initMsg.topic() == null) {
                int topicOrd = initMsg.topicOrdinal();
                initMsg.topic((Object)(topicOrd >= 0 ? GridTopic.fromOrdinal(topicOrd) : U.unmarshal(this.marsh, initMsg.topicBytes(), U.resolveClassLoader(this.ctx.config()))));
            }
            byte plc = initMsg.policy();
            this.pools.poolForPolicy(plc).execute(new Runnable(){

                @Override
                public void run() {
                    GridIoManager.this.processOpenedChannel(initMsg.topic(), rmtNodeId, (SessionChannelMessage)initMsg.message(), (SocketChannel)channel);
                }
            });
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to process channel creation event due to exception [rmtNodeId=" + rmtNodeId + ", initMsg=" + initMsg + ']', e);
        }
        finally {
            busyLock0.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onMessage0(UUID nodeId, GridIoMessage msg, IgniteRunnable msgC) {
        assert (nodeId != null);
        assert (msg != null);
        Lock busyLock0 = this.busyLock.readLock();
        busyLock0.lock();
        try {
            if (this.stopping) {
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Received communication message while stopping (will ignore) [nodeId=" + nodeId + ", msg=" + msg + ']');
                return;
            }
            if (msg.topic() == null) {
                int topicOrd = msg.topicOrdinal();
                msg.topic((Object)(topicOrd >= 0 ? GridTopic.fromOrdinal(topicOrd) : U.unmarshal(this.marsh, msg.topicBytes(), U.resolveClassLoader(this.ctx.config()))));
            }
            if (!this.started) {
                this.lock.readLock().lock();
                try {
                    if (!this.started) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Adding message to waiting list [senderId=" + nodeId + ", msg=" + msg + ']');
                        }
                        Deque list = (Deque)((Object)F.addIfAbsent(this.waitMap, nodeId, ConcurrentLinkedDeque::new));
                        assert (list != null);
                        list.add(new DelayedMessage(nodeId, msg, msgC));
                        return;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            byte plc = msg.policy();
            switch (plc) {
                case 1: {
                    this.processP2PMessage(nodeId, msg, msgC);
                    return;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (msg.isOrdered()) {
                        this.processOrderedMessage(nodeId, msg, plc, msgC);
                        return;
                    } else {
                        this.processRegularMessage(nodeId, msg, plc, msgC);
                        return;
                    }
                }
                default: {
                    assert (plc >= 0) : "Negative policy [plc=" + plc + ", msg=" + msg + ']';
                    if (GridIoPolicy.isReservedGridIoPolicy(plc)) {
                        throw new IgniteCheckedException("Failed to process message with policy of reserved range. [policy=" + plc + ']');
                    }
                    if (msg.isOrdered()) {
                        this.processOrderedMessage(nodeId, msg, plc, msgC);
                        return;
                    } else {
                        this.processRegularMessage(nodeId, msg, plc, msgC);
                    }
                    return;
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to process message (will ignore): " + msg, e);
            return;
        }
        finally {
            busyLock0.unlock();
        }
    }

    private void processP2PMessage(final UUID nodeId, final GridIoMessage msg, final IgniteRunnable msgC) {
        Runnable c = new Runnable(){

            @Override
            public void run() {
                try {
                    GridNioBackPressureControl.threadProcessingMessage(true, msgC);
                    GridMessageListener lsnr = GridIoManager.this.listenerGet0(msg.topic());
                    if (lsnr == null) {
                        return;
                    }
                    Message obj = msg.message();
                    assert (obj != null);
                    GridIoManager.this.invokeListener(msg.policy(), lsnr, nodeId, obj, GridIoManager.this.secSubjId(msg));
                }
                finally {
                    GridNioBackPressureControl.threadProcessingMessage(false, null);
                    msgC.run();
                }
            }
        };
        try {
            this.pools.getPeerClassLoadingExecutorService().execute(c);
        }
        catch (RejectedExecutionException e) {
            U.error(this.log, "Failed to process P2P message due to execution rejection. Increase the upper bound on 'ExecutorService' provided by 'IgniteConfiguration.getPeerClassLoadingThreadPoolSize()'. Will attempt to process message in the listener thread instead.", e);
            c.run();
        }
    }

    private void processRegularMessage(final UUID nodeId, final GridIoMessage msg, byte plc, final IgniteRunnable msgC) throws IgniteCheckedException {
        block12: {
            IgniteIoTestMessage msg0;
            TraceRunnable c = new TraceRunnable(this.ctx.tracing(), SpanType.COMMUNICATION_REGULAR_PROCESS){

                @Override
                public void execute() {
                    try {
                        MTC.span().addTag("message", () -> TraceableMessagesTable.traceName(msg));
                        GridNioBackPressureControl.threadProcessingMessage(true, msgC);
                        GridIoManager.this.processRegularMessage0(msg, nodeId);
                    }
                    finally {
                        GridNioBackPressureControl.threadProcessingMessage(false, null);
                        msgC.run();
                    }
                }

                public String toString() {
                    return "Message closure [msg=" + msg + ']';
                }
            };
            MTC.span().addLog(() -> "Regular process queued");
            if (msg.topicOrdinal() == GridTopic.TOPIC_IO_TEST.ordinal()) {
                IgniteIoTestMessage msg02 = (IgniteIoTestMessage)msg.message();
                if (msg02.processFromNioThread()) {
                    c.run();
                } else {
                    this.ctx.pools().getStripedExecutorService().execute(-1, c);
                }
                return;
            }
            if (msg.topicOrdinal() == GridTopic.TOPIC_CACHE_COORDINATOR.ordinal()) {
                MvccMessage msg03 = (MvccMessage)msg.message();
                this.ctx.pools().getStripedExecutorService().execute(-1, c);
                return;
            }
            int part = msg.partition();
            if (plc == 2 && part != GridIoMessage.STRIPE_DISABLED_PART) {
                this.ctx.pools().getStripedExecutorService().execute(part, c);
                return;
            }
            if (plc == 9 && part != GridIoMessage.STRIPE_DISABLED_PART) {
                this.ctx.pools().getDataStreamerExecutorService().execute(part, c);
                return;
            }
            if (msg.topicOrdinal() == GridTopic.TOPIC_IO_TEST.ordinal() && (msg0 = (IgniteIoTestMessage)msg.message()).processFromNioThread()) {
                c.run();
                return;
            }
            try {
                String execName = msg.executorName();
                if (execName != null) {
                    Executor exec = this.pools.customExecutor(execName);
                    if (exec != null) {
                        exec.execute(c);
                        return;
                    }
                    LT.warn(this.log, "Custom executor doesn't exist (message will be processed in default thread pool): " + execName);
                }
                this.pools.poolForPolicy(plc).execute(c);
            }
            catch (RejectedExecutionException e) {
                if (!this.ctx.isStopping()) {
                    U.error(this.log, "Failed to process regular message due to execution rejection. Will attempt to process message in the listener thread instead.", e);
                    c.run();
                }
                if (!this.log.isDebugEnabled()) break block12;
                this.log.debug("Failed to process regular message due to execution rejection: " + msg);
            }
        }
    }

    private void processRegularMessage0(GridIoMessage msg, UUID nodeId) {
        GridMessageListener lsnr = this.listenerGet0(msg.topic());
        if (lsnr == null) {
            return;
        }
        Message obj = msg.message();
        assert (obj != null);
        this.invokeListener(msg.policy(), lsnr, nodeId, obj, this.secSubjId(msg));
    }

    @Nullable
    private GridMessageListener listenerGet0(Object topic) {
        if (topic instanceof GridTopic) {
            return this.sysLsnrs[this.systemListenerIndex(topic)];
        }
        return (GridMessageListener)this.lsnrMap.get(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GridMessageListener listenerPutIfAbsent0(Object topic, GridMessageListener lsnr) {
        if (topic instanceof GridTopic) {
            Object object = this.sysLsnrsMux;
            synchronized (object) {
                int idx = this.systemListenerIndex(topic);
                GridMessageListener old = this.sysLsnrs[idx];
                if (old == null) {
                    this.changeSystemListener(idx, lsnr);
                }
                return old;
            }
        }
        return this.lsnrMap.putIfAbsent(topic, lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GridMessageListener listenerRemove0(Object topic) {
        if (topic instanceof GridTopic) {
            Object object = this.sysLsnrsMux;
            synchronized (object) {
                int idx = this.systemListenerIndex(topic);
                GridMessageListener old = this.sysLsnrs[idx];
                if (old != null) {
                    this.changeSystemListener(idx, null);
                }
                return old;
            }
        }
        return (GridMessageListener)this.lsnrMap.remove(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean listenerRemove0(Object topic, GridMessageListener exp) {
        if (topic instanceof GridTopic) {
            Object object = this.sysLsnrsMux;
            synchronized (object) {
                return this.systemListenerChange(topic, exp, null);
            }
        }
        return this.lsnrMap.remove(topic, exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean listenerReplace0(Object topic, GridMessageListener exp, GridMessageListener newVal) {
        if (topic instanceof GridTopic) {
            Object object = this.sysLsnrsMux;
            synchronized (object) {
                return this.systemListenerChange(topic, exp, newVal);
            }
        }
        return this.lsnrMap.replace(topic, exp, newVal);
    }

    private boolean systemListenerChange(Object topic, GridMessageListener exp, GridMessageListener newVal) {
        assert (Thread.holdsLock(this.sysLsnrsMux));
        assert (topic instanceof GridTopic);
        int idx = this.systemListenerIndex(topic);
        GridMessageListener old = this.sysLsnrs[idx];
        if (old != null && old.equals(exp)) {
            this.changeSystemListener(idx, newVal);
            return true;
        }
        return false;
    }

    private void changeSystemListener(int idx, @Nullable GridMessageListener lsnr) {
        assert (Thread.holdsLock(this.sysLsnrsMux));
        GridMessageListener[] res = new GridMessageListener[this.sysLsnrs.length];
        System.arraycopy(this.sysLsnrs, 0, res, 0, this.sysLsnrs.length);
        res[idx] = lsnr;
        this.sysLsnrs = res;
    }

    private int systemListenerIndex(Object topic) {
        assert (topic instanceof GridTopic);
        return ((GridTopic)((Object)topic)).ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOrderedMessage(UUID nodeId, GridIoMessage msg, byte plc, final @Nullable IgniteRunnable msgC) throws IgniteCheckedException {
        GridMessageListener lsnr;
        ConcurrentHashMap0<UUID, GridCommunicationMessageSet> concurrentHashMap0;
        ConcurrentMap map;
        GridCommunicationMessageSet set;
        boolean isNew;
        block32: {
            assert (msg != null);
            long timeout = msg.timeout();
            boolean skipOnTimeout = msg.skipOnTimeout();
            isNew = false;
            set = null;
            while (true) {
                if ((map = (ConcurrentHashMap0<UUID, GridCommunicationMessageSet>)this.msgSetMap.get(msg.topic())) == null) {
                    set = new GridCommunicationMessageSet(plc, msg.topic(), nodeId, timeout, skipOnTimeout, msg, msgC);
                    map = new ConcurrentHashMap0<UUID, GridCommunicationMessageSet>();
                    map.put(nodeId, set);
                    ConcurrentMap old = this.msgSetMap.putIfAbsent(msg.topic(), map);
                    if (old == null) {
                        isNew = true;
                        break block32;
                    }
                    map = old;
                }
                boolean rmv = false;
                concurrentHashMap0 = map;
                synchronized (concurrentHashMap0) {
                    if (map.isEmpty()) {
                        rmv = true;
                    } else {
                        set = (GridCommunicationMessageSet)map.get(nodeId);
                        if (set == null) {
                            set = new GridCommunicationMessageSet(plc, msg.topic(), nodeId, timeout, skipOnTimeout, msg, msgC);
                            GridCommunicationMessageSet old = map.putIfAbsent(nodeId, set);
                            assert (old == null);
                            isNew = true;
                            break block32;
                        }
                    }
                }
                if (!rmv) break;
                this.msgSetMap.remove(msg.topic(), map);
            }
            assert (set != null);
            assert (!isNew);
            set.add(msg, msgC);
        }
        if (isNew && this.ctx.discovery().node(nodeId) == null) {
            boolean rmv;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Message is ignored as sender has left the grid: " + msg);
            }
            assert (map != null);
            concurrentHashMap0 = map;
            synchronized (concurrentHashMap0) {
                map.remove(nodeId);
                rmv = map.isEmpty();
            }
            if (rmv) {
                this.msgSetMap.remove(msg.topic(), map);
            }
            return;
        }
        if (isNew && set.endTime() != Long.MAX_VALUE) {
            this.ctx.timeout().addTimeoutObject(set);
        }
        if ((lsnr = this.listenerGet0(msg.topic())) == null) {
            if (this.closedTopics.contains(msg.topic())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message is ignored as it came for the closed topic: " + msg);
                }
                assert (map != null);
                this.msgSetMap.remove(msg.topic(), map);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Received message for unknown listener (messages will be kept until a listener is registered): " + msg);
            }
            if (msgC != null) {
                msgC.run();
            }
            return;
        }
        if (msgC == null) {
            assert (this.locNodeId.equals(nodeId));
            this.unwindMessageSet(set, lsnr);
            return;
        }
        final GridCommunicationMessageSet msgSet0 = set;
        Runnable c = new Runnable(){

            @Override
            public void run() {
                try {
                    GridNioBackPressureControl.threadProcessingMessage(true, msgC);
                    GridIoManager.this.unwindMessageSet(msgSet0, lsnr);
                }
                finally {
                    GridNioBackPressureControl.threadProcessingMessage(false, null);
                }
            }
        };
        try {
            MTC.span().addLog(() -> "Ordered process queued");
            this.pools.poolForPolicy(plc).execute(c);
        }
        catch (RejectedExecutionException e) {
            U.error(this.log, "Failed to process ordered message due to execution rejection. Increase the upper bound on executor service provided by corresponding configuration property. Will attempt to process message in the listener thread instead [msgPlc=" + plc + ']', e);
            c.run();
        }
    }

    private void unwindMessageSet(GridCommunicationMessageSet msgSet, GridMessageListener lsnr) {
        block7: {
            while (msgSet.reserve()) {
                try {
                    msgSet.unwind(lsnr);
                }
                finally {
                    msgSet.release();
                }
                if (msgSet.changed()) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message set has not been changed: " + msgSet);
                }
                break block7;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Another thread owns reservation: " + msgSet);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListener(Byte plc, GridMessageListener lsnr, UUID nodeId, Object msg, UUID secSubjId) {
        boolean change;
        MTC.span().addLog(() -> "Invoke listener");
        Byte oldPlc = CUR_PLC.get();
        boolean bl = change = !F.eq(oldPlc, plc);
        if (change) {
            CUR_PLC.set(plc);
        }
        UUID newSecSubjId = secSubjId != null ? secSubjId : nodeId;
        try (OperationSecurityContext s = this.ctx.security().withContext(newSecSubjId);){
            lsnr.onMessage(nodeId, msg, plc);
        }
        finally {
            if (change) {
                CUR_PLC.set(oldPlc);
            }
        }
    }

    @Nullable
    public static Byte currentPolicy() {
        return CUR_PLC.get();
    }

    public boolean checkNodeLeft(UUID nodeId, IgniteCheckedException sndErr, boolean ping) throws IgniteClientDisconnectedCheckedException {
        return sndErr instanceof ClusterTopologyCheckedException || this.ctx.discovery().node(nodeId) == null || ping && !this.ctx.discovery().pingNode(nodeId);
    }

    public TransmissionSender openTransmissionSender(UUID remoteId, Object topic) {
        return new TransmissionSender(remoteId, topic);
    }

    public void addTransmissionHandler(Object topic, TransmissionHandler hnd) {
        TransmissionHandler hnd0 = this.topicTransmissionHnds.putIfAbsent(topic, hnd);
        assert (hnd0 == null) : "The topic already have an appropriate session handler [topic=" + topic + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransmissionHandler(Object topic) {
        ReceiverContext rcvCtx0;
        Object object = this.rcvMux;
        synchronized (object) {
            this.topicTransmissionHnds.remove(topic);
            rcvCtx0 = (ReceiverContext)this.rcvCtxs.remove(topic);
        }
        this.interruptReceiver(rcvCtx0, new IgniteCheckedException("Receiver has been closed due to removing corresponding transmission handler on local node [nodeId=" + this.ctx.localNodeId() + ']'));
    }

    public boolean fileTransmissionSupported(ClusterNode node) {
        return (CommunicationSpi)this.getSpi() instanceof TcpCommunicationSpi && IgniteFeatures.nodeSupports(node, IgniteFeatures.CHANNEL_COMMUNICATION);
    }

    private IgniteInternalFuture<Channel> openChannel(UUID nodeId, Object topic, Message initMsg) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (topic != null);
        assert (!this.locNodeId.equals(nodeId)) : "Channel cannot be opened to the local node itself: " + nodeId;
        assert ((CommunicationSpi)this.getSpi() instanceof TcpCommunicationSpi) : "Only TcpCommunicationSpi supports direct connections between nodes: " + ((CommunicationSpi)this.getSpi()).getClass();
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            throw new ClusterTopologyCheckedException("Failed to open a new channel to remote node (node left): " + nodeId);
        }
        int topicOrd = topic instanceof GridTopic ? ((Enum)topic).ordinal() : -1;
        GridIoMessage ioMsg = this.createGridIoMessage(topic, topicOrd, initMsg, (byte)0, false, 0L, false);
        try {
            if (topicOrd < 0) {
                ioMsg.topicBytes(U.marshal(this.marsh, topic));
            }
            return ((TcpCommunicationSpi)((CommunicationSpi)this.getSpi())).openChannel(node, ioMsg);
        }
        catch (IgniteSpiException e) {
            if (e.getCause() instanceof ClusterTopologyCheckedException) {
                throw (ClusterTopologyCheckedException)e.getCause();
            }
            if (!this.ctx.discovery().alive(node)) {
                throw new ClusterTopologyCheckedException("Failed to create channel (node left): " + node.id(), e);
            }
            throw new IgniteCheckedException("Failed to create channel (node may have left the grid or TCP connection cannot be established due to unknown issues) [node=" + node + ", topic=" + topic + ']', e);
        }
    }

    private void send(ClusterNode node, Object topic, int topicOrd, Message msg, byte plc, boolean ordered, long timeout, boolean skipOnTimeout, IgniteInClosure<IgniteException> ackC, boolean async) throws IgniteCheckedException {
        block32: {
            assert (node != null);
            assert (topic != null);
            assert (msg != null);
            assert (!async || msg instanceof GridIoUserMessage) : msg;
            assert (topicOrd >= 0 || !(topic instanceof GridTopic)) : msg;
            try (MTC.TraceSurroundings ignored = MTC.support(null);){
                MTC.span().addLog(() -> "Create communication msg - " + TraceableMessagesTable.traceName(msg));
                GridIoMessage ioMsg = this.createGridIoMessage(topic, topicOrd, msg, plc, ordered, timeout, skipOnTimeout);
                if (this.locNodeId.equals(node.id())) {
                    assert (plc != 1);
                    CommunicationListenerEx<Serializable> commLsnr = this.commLsnr;
                    if (commLsnr == null) {
                        throw new IgniteCheckedException("Trying to send message when grid is not fully started.");
                    }
                    if (ordered) {
                        this.processOrderedMessage(this.locNodeId, ioMsg, plc, null);
                    } else if (async) {
                        this.processRegularMessage(this.locNodeId, ioMsg, plc, NOOP);
                    } else {
                        this.processRegularMessage0(ioMsg, this.locNodeId);
                    }
                    if (ackC != null) {
                        ackC.apply(null);
                    }
                    break block32;
                }
                if (topicOrd < 0) {
                    ioMsg.topicBytes(U.marshal(this.marsh, topic));
                }
                try {
                    if ((CommunicationSpi)this.getSpi() instanceof TcpCommunicationSpi) {
                        this.getTcpCommunicationSpi().sendMessage(node, ioMsg, ackC);
                    } else {
                        ((CommunicationSpi)this.getSpi()).sendMessage(node, ioMsg);
                    }
                }
                catch (IgniteSpiException e) {
                    if (e.getCause() instanceof ClusterTopologyCheckedException) {
                        throw (ClusterTopologyCheckedException)e.getCause();
                    }
                    if (!this.ctx.discovery().alive(node)) {
                        throw new ClusterTopologyCheckedException("Failed to send message, node left: " + node.id(), e);
                    }
                    throw new IgniteCheckedException("Failed to send message (node may have left the grid or TCP connection cannot be established due to firewall issues) [node=" + node + ", topic=" + topic + ", msg=" + msg + ", policy=" + plc + ']', e);
                }
            }
        }
    }

    private long getInverseConnectionWaitTimeout() {
        return this.ctx.config().getFailureDetectionTimeout();
    }

    @NotNull
    private GridIoMessage createGridIoMessage(Object topic, int topicOrd, Message msg, byte plc, boolean ordered, long timeout, boolean skipOnTimeout) {
        if (this.ctx.security().enabled()) {
            UUID secSubjId = null;
            if (!this.ctx.security().isDefaultContext()) {
                secSubjId = this.ctx.security().securityContext().subject().id();
            }
            return new GridIoSecurityAwareMessage(secSubjId, plc, topic, topicOrd, msg, ordered, timeout, skipOnTimeout);
        }
        return new GridIoMessage(plc, topic, topicOrd, msg, ordered, timeout, skipOnTimeout);
    }

    public void sendToCustomTopic(UUID nodeId, Object topic, Message msg, byte plc) throws IgniteCheckedException {
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            throw new ClusterTopologyCheckedException("Failed to send message to node (has node left grid?): " + nodeId);
        }
        this.sendToCustomTopic(node, topic, msg, plc);
    }

    public void sendToGridTopic(UUID nodeId, GridTopic topic, Message msg, byte plc) throws IgniteCheckedException {
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            throw new ClusterTopologyCheckedException("Failed to send message to node (has node left grid?): " + nodeId);
        }
        this.send(node, (Object)topic, topic.ordinal(), msg, plc, false, 0L, false, null, false);
    }

    public void sendToGridTopic(ClusterNode node, GridTopic topic, Message msg, byte plc) throws IgniteCheckedException {
        this.send(node, (Object)topic, topic.ordinal(), msg, plc, false, 0L, false, null, false);
    }

    public void sendToCustomTopic(ClusterNode node, Object topic, Message msg, byte plc) throws IgniteCheckedException {
        this.send(node, topic, -1, msg, plc, false, 0L, false, null, false);
    }

    public void sendToGridTopic(ClusterNode node, GridTopic topic, Message msg, byte plc, Span span) throws IgniteCheckedException {
        this.send(node, (Object)topic, topic.ordinal(), msg, plc, false, 0L, false, null, false);
    }

    public void sendGeneric(ClusterNode node, Object topic, int topicOrd, Message msg, byte plc) throws IgniteCheckedException {
        this.send(node, topic, topicOrd, msg, plc, false, 0L, false, null, false);
    }

    public void sendOrderedMessage(ClusterNode node, Object topic, Message msg, byte plc, long timeout, boolean skipOnTimeout) throws IgniteCheckedException {
        assert (timeout > 0L || skipOnTimeout);
        this.send(node, topic, -1, msg, plc, true, timeout, skipOnTimeout, null, false);
    }

    public void sendToGridTopic(ClusterNode node, GridTopic topic, Message msg, byte plc, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        this.send(node, (Object)topic, topic.ordinal(), msg, plc, false, 0L, false, ackC, false);
    }

    void sendOrderedMessageToGridTopic(Collection<? extends ClusterNode> nodes, GridTopic topic, Message msg, byte plc, long timeout, boolean skipOnTimeout) throws IgniteCheckedException {
        assert (timeout > 0L || skipOnTimeout);
        IgniteCheckedException err = null;
        for (ClusterNode clusterNode : nodes) {
            try {
                this.send(clusterNode, (Object)topic, topic.ordinal(), msg, plc, true, timeout, skipOnTimeout, null, false);
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                err.addSuppressed(e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    public void sendToGridTopic(Collection<? extends ClusterNode> nodes, GridTopic topic, Message msg, byte plc) throws IgniteCheckedException {
        IgniteCheckedException err = null;
        for (ClusterNode clusterNode : nodes) {
            try {
                this.send(clusterNode, (Object)topic, topic.ordinal(), msg, plc, false, 0L, false, null, false);
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = e;
                    continue;
                }
                err.addSuppressed(e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    public void sendOrderedMessage(ClusterNode node, Object topic, Message msg, byte plc, long timeout, boolean skipOnTimeout, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        assert (timeout > 0L || skipOnTimeout);
        this.send(node, topic, -1, msg, plc, true, timeout, skipOnTimeout, ackC, false);
    }

    public void sendUserMessage(Collection<? extends ClusterNode> nodes, Object msg, @Nullable Object topic, boolean ordered, long timeout, boolean async) throws IgniteCheckedException {
        boolean loc = nodes.size() == 1 && F.first(nodes).id().equals(this.locNodeId);
        byte[] serMsg = null;
        byte[] serTopic = null;
        if (!loc) {
            serMsg = U.marshal(this.marsh, msg);
            if (topic != null) {
                serTopic = U.marshal(this.marsh, topic);
            }
        }
        GridDeployment dep = null;
        String depClsName = null;
        if (this.ctx.config().isPeerClassLoadingEnabled()) {
            Class<?> cls0 = U.detectClass(msg);
            if (U.isJdk(cls0) && topic != null) {
                cls0 = U.detectClass(topic);
            }
            if ((dep = this.ctx.deploy().deploy(cls0, U.detectClassLoader(cls0))) == null) {
                throw new IgniteDeploymentCheckedException("Failed to deploy user message: " + msg);
            }
            depClsName = cls0.getName();
        }
        GridIoUserMessage ioMsg = new GridIoUserMessage(msg, serMsg, depClsName, topic, serTopic, dep != null ? dep.classLoaderId() : null, dep != null ? dep.deployMode() : null, dep != null ? dep.userVersion() : null, dep != null ? dep.participants() : null);
        if (ordered) {
            this.sendOrderedMessageToGridTopic(nodes, GridTopic.TOPIC_COMM_USER, ioMsg, (byte)0, timeout, true);
        } else if (loc) {
            this.send(F.first(nodes), (Object)GridTopic.TOPIC_COMM_USER, GridTopic.TOPIC_COMM_USER.ordinal(), ioMsg, (byte)0, false, 0L, false, null, async);
        } else {
            ClusterNode locNode = F.find(nodes, null, F.localNode(this.locNodeId));
            Collection<? extends ClusterNode> rmtNodes = F.view(nodes, F.remoteNodes(this.locNodeId));
            if (!rmtNodes.isEmpty()) {
                this.sendToGridTopic(rmtNodes, GridTopic.TOPIC_COMM_USER, (Message)ioMsg, (byte)0);
            }
            if (locNode != null) {
                this.send(locNode, (Object)GridTopic.TOPIC_COMM_USER, GridTopic.TOPIC_COMM_USER.ordinal(), ioMsg, (byte)0, false, 0L, false, null, async);
            }
        }
    }

    public void addUserMessageListener(@Nullable Object topic, @Nullable IgniteBiPredicate<UUID, ?> p) {
        this.addUserMessageListener(topic, p, this.ctx.localNodeId());
    }

    public void addUserMessageListener(@Nullable Object topic, @Nullable IgniteBiPredicate<UUID, ?> p, UUID nodeId) {
        if (p != null) {
            try {
                if (p instanceof PlatformMessageFilter) {
                    ((PlatformMessageFilter)p).initialize(this.ctx);
                } else {
                    this.ctx.resource().injectGeneric(p);
                }
                this.addMessageListener(GridTopic.TOPIC_COMM_USER, (GridMessageListener)new GridUserMessageListener(topic, p, nodeId));
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }

    public void removeUserMessageListener(@Nullable Object topic, IgniteBiPredicate<UUID, ?> p) {
        this.removeMessageListener(GridTopic.TOPIC_COMM_USER, (GridMessageListener)new GridUserMessageListener(topic, p));
    }

    public void addMessageListener(GridTopic topic, GridMessageListener lsnr) {
        this.addMessageListener((Object)topic, lsnr);
    }

    public void addDisconnectListener(GridDisconnectListener lsnr) {
        this.disconnectLsnrs.add(lsnr);
    }

    public void removeDisconnectListener(GridDisconnectListener lsnr) {
        this.disconnectLsnrs.remove(lsnr);
    }

    public void addMessageListener(Object topic, GridMessageListener lsnr) {
        Collection msgSets;
        GridMessageListener lsnrs;
        assert (lsnr != null);
        assert (topic != null);
        this.closedTopics.remove(topic);
        while (true) {
            if ((lsnrs = this.listenerPutIfAbsent0(topic, lsnr)) == null) {
                lsnrs = lsnr;
                break;
            }
            assert (lsnrs != null);
            if (!(lsnrs instanceof ArrayListener)) {
                ArrayListener arrLsnr = new ArrayListener(lsnrs, lsnr);
                if (!this.listenerReplace0(topic, lsnrs, arrLsnr)) continue;
                lsnrs = arrLsnr;
                break;
            }
            if (((ArrayListener)lsnrs).add(lsnr)) break;
            this.listenerRemove0(topic, lsnrs);
        }
        Map map = (Map)this.msgSetMap.get(topic);
        Collection collection = msgSets = map != null ? map.values() : null;
        if (msgSets != null) {
            final GridMessageListener lsnrs0 = lsnrs;
            try {
                for (final GridCommunicationMessageSet msgSet : msgSets) {
                    this.pools.poolForPolicy(msgSet.policy()).execute(new Runnable(){

                        @Override
                        public void run() {
                            GridIoManager.this.unwindMessageSet(msgSet, lsnrs0);
                        }
                    });
                }
            }
            catch (RejectedExecutionException e) {
                U.error(this.log, "Failed to process delayed message due to execution rejection. Increase the upper bound on executor service provided in 'IgniteConfiguration.getPublicThreadPoolSize()'). Will attempt to process message in the listener thread instead.", e);
                for (GridCommunicationMessageSet msgSet : msgSets) {
                    this.unwindMessageSet(msgSet, lsnr);
                }
            }
            catch (IgniteCheckedException ice) {
                throw new IgniteException(ice);
            }
        }
    }

    public boolean removeMessageListener(GridTopic topic) {
        return this.removeMessageListener((Object)topic);
    }

    public boolean removeMessageListener(Object topic) {
        return this.removeMessageListener(topic, null);
    }

    public boolean removeMessageListener(GridTopic topic, @Nullable GridMessageListener lsnr) {
        return this.removeMessageListener((Object)topic, lsnr);
    }

    public boolean removeMessageListener(Object topic, @Nullable GridMessageListener lsnr) {
        Collection msgSets;
        boolean rmv;
        block16: {
            boolean empty;
            block20: {
                GridMessageListener lsnrs;
                block17: {
                    block18: {
                        block19: {
                            assert (topic != null);
                            rmv = true;
                            msgSets = null;
                            if (lsnr != null) break block19;
                            this.closedTopics.add(topic);
                            lsnr = this.listenerRemove0(topic);
                            rmv = lsnr != null;
                            Map map = (Map)this.msgSetMap.remove(topic);
                            if (map != null) {
                                msgSets = map.values();
                            }
                            break block16;
                        }
                        do {
                            if ((lsnrs = this.listenerGet0(topic)) == null) {
                                this.closedTopics.add(topic);
                                Map map = (Map)this.msgSetMap.remove(topic);
                                if (map != null) {
                                    msgSets = map.values();
                                }
                                rmv = false;
                                break block16;
                            }
                            empty = false;
                            if (lsnrs instanceof ArrayListener) break block17;
                            if (!lsnrs.equals(lsnr)) break block18;
                        } while (!this.listenerRemove0(topic, lsnrs));
                        empty = true;
                        break block20;
                    }
                    rmv = false;
                    break block20;
                }
                ArrayListener arrLsnr = (ArrayListener)lsnrs;
                if (arrLsnr.remove(lsnr)) {
                    empty = arrLsnr.isEmpty();
                } else {
                    rmv = false;
                }
                if (empty) {
                    this.listenerRemove0(topic, lsnrs);
                }
            }
            if (empty) {
                this.closedTopics.add(topic);
                Map map = (Map)this.msgSetMap.remove(topic);
                if (map != null) {
                    msgSets = map.values();
                }
            }
        }
        if (msgSets != null) {
            for (GridCommunicationMessageSet msgSet : msgSets) {
                this.ctx.timeout().removeTimeoutObject(msgSet);
            }
        }
        if (rmv && this.log.isDebugEnabled()) {
            this.log.debug("Removed message listener [topic=" + topic + ", lsnr=" + lsnr + ']');
        }
        if (lsnr instanceof ArrayListener) {
            for (GridMessageListener childLsnr : ((ArrayListener)lsnr).arr) {
                this.closeListener(childLsnr);
            }
        } else {
            this.closeListener(lsnr);
        }
        return rmv;
    }

    private void closeListener(GridMessageListener lsnr) {
        GridUserMessageListener userLsnr;
        if (lsnr instanceof GridUserMessageListener && (userLsnr = (GridUserMessageListener)lsnr).predLsnr instanceof PlatformMessageFilter) {
            ((PlatformMessageFilter)userLsnr.predLsnr).onClose();
        }
    }

    public int getSentMessagesCount() {
        return ((CommunicationSpi)this.getSpi()).getSentMessagesCount();
    }

    public long getSentBytesCount() {
        return ((CommunicationSpi)this.getSpi()).getSentBytesCount();
    }

    public int getReceivedMessagesCount() {
        return ((CommunicationSpi)this.getSpi()).getReceivedMessagesCount();
    }

    public long getReceivedBytesCount() {
        return ((CommunicationSpi)this.getSpi()).getReceivedBytesCount();
    }

    public int getOutboundMessagesQueueSize() {
        return ((CommunicationSpi)this.getSpi()).getOutboundMessagesQueueSize();
    }

    private void interruptReceiver(ReceiverContext rctx, Exception ex) {
        if (rctx == null) {
            return;
        }
        if (rctx.interrupted.compareAndSet(false, true)) {
            if (rctx.timeoutObj != null) {
                this.ctx.timeout().removeTimeoutObject(rctx.timeoutObj);
            }
            U.closeQuiet(rctx.rcv);
            rctx.lastState = rctx.lastState == null ? new TransmissionMeta(ex) : rctx.lastState.error(ex);
            if (X.hasCause((Throwable)ex, TransmissionCancelledException.class)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Transmission receiver has been cancelled [rctx=" + rctx + ']');
                }
            } else {
                U.error(this.log, "Receiver has been interrupted due to an exception occurred [rctx=" + rctx + ']', ex);
            }
            rctx.hnd.onException(rctx.rmtNodeId, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processOpenedChannel(Object topic, UUID rmtNodeId, SessionChannelMessage initMsg, SocketChannel ch) {
        ObjectOutputStream out;
        ObjectInputStream in;
        ReceiverContext rcvCtx;
        block21: {
            TransmissionHandler hnd;
            IgniteUuid newSesId;
            block20: {
                block19: {
                    rcvCtx = null;
                    in = null;
                    out = null;
                    if (this.stopping) {
                        throw new NodeStoppingException("Local node is stopping. Channel will be closed [topic=" + topic + ", channel=" + ch + ']');
                    }
                    if (initMsg != null && initMsg.sesId() != null) break block19;
                    U.warn(this.log, "There is no initial message provied for given topic. Opened channel will be closed [rmtNodeId=" + rmtNodeId + ", topic=" + topic + ", initMsg=" + initMsg + ']');
                    U.closeQuiet(in);
                    U.closeQuiet(out);
                    U.closeQuiet(ch);
                    return;
                }
                GridIoManager.configureChannel(ch, this.netTimeoutMs);
                in = new ObjectInputStream(ch.socket().getInputStream());
                out = new ObjectOutputStream(ch.socket().getOutputStream());
                newSesId = initMsg.sesId();
                Object object = this.rcvMux;
                // MONITORENTER : object
                hnd = (TransmissionHandler)this.topicTransmissionHnds.get(topic);
                if (hnd != null) break block20;
                U.warn(this.log, "There is no handler for a given topic. Channel will be closed [rmtNodeId=" + rmtNodeId + ", topic=" + topic + ']');
                // MONITOREXIT : object
                U.closeQuiet(in);
                U.closeQuiet(out);
                U.closeQuiet(ch);
                return;
            }
            rcvCtx = this.rcvCtxs.computeIfAbsent(topic, t -> new ReceiverContext(rmtNodeId, hnd, newSesId));
            // MONITOREXIT : object
            if (newSesId.equals(rcvCtx.sesId)) break block21;
            IgniteCheckedException err = new IgniteCheckedException("Requested topic is busy by another transmission. It's not allowed to process different sessions over the same topic simultaneously. Channel will be closed [initMsg=" + initMsg + ", channel=" + ch + ", nodeId=" + rmtNodeId + ']');
            U.error(this.log, "Error has been sent back to remote node. Receiver holds the local topic [topic=" + topic + ", rmtNodeId=" + rmtNodeId + ", ctx=" + rcvCtx + ']', err);
            out.writeObject(new TransmissionMeta(err));
            U.closeQuiet(in);
            U.closeQuiet(out);
            U.closeQuiet(ch);
            return;
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Trasmission open a new channel [rmtNodeId=" + rmtNodeId + ", topic=" + topic + ", initMsg=" + initMsg + ']');
            }
            if (!rcvCtx.lock.tryLock(this.netTimeoutMs, TimeUnit.MILLISECONDS)) {
                throw new IgniteException("Wait for the previous receiver finished its work timeouted: " + rcvCtx);
            }
            try {
                if (rcvCtx.timeoutObj != null) {
                    this.ctx.timeout().removeTimeoutObject(rcvCtx.timeoutObj);
                }
                out.writeObject(rcvCtx.lastState == null ? new TransmissionMeta() : rcvCtx.lastState);
                if (rcvCtx.lastState == null || rcvCtx.lastState.error() == null) {
                    this.receiveFromChannel(topic, rcvCtx, in, out, ch);
                } else {
                    this.interruptReceiver((ReceiverContext)this.rcvCtxs.remove(topic), rcvCtx.lastState.error());
                }
            }
            finally {
                rcvCtx.lock.unlock();
            }
        }
        catch (Throwable t2) {
            try {
                this.interruptReceiver(rcvCtx, new IgniteCheckedException("Channel processing error [nodeId=" + rmtNodeId + ']', t2));
            }
            catch (Throwable throwable) {
                U.closeQuiet(in);
                U.closeQuiet(out);
                U.closeQuiet(ch);
                throw throwable;
            }
            U.closeQuiet(in);
            U.closeQuiet(out);
            U.closeQuiet(ch);
            return;
        }
        U.closeQuiet(in);
        U.closeQuiet(out);
        U.closeQuiet(ch);
        return;
    }

    /*
     * Exception decompiling
     */
    private void receiveFromChannel(Object topic, ReceiverContext rcvCtx, ObjectInputStream in, ObjectOutputStream out, SocketChannel ch) throws NodeStoppingException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validate(TransmissionMeta prev, TransmissionMeta next) {
        A.ensure(prev.name().equals(next.name()), "Attempt to load different file [prev=" + prev + ", next=" + next + ']');
        A.ensure(prev.offset() == next.offset(), "The next chunk offest is incorrect [prev=" + prev + ", meta=" + next + ']');
        A.ensure(prev.count() == next.count(), " The count of bytes to transfer for the next chunk is incorrect [prev=" + prev + ", next=" + next + ']');
        A.ensure(prev.policy() == next.policy(), "Attemt to continue file upload with different transmission policy [prev=" + prev + ", next=" + next + ']');
    }

    private TransmissionReceiver createReceiver(UUID nodeId, TransmissionHandler hnd, TransmissionMeta meta, BooleanSupplier stopChecker) {
        switch (meta.policy()) {
            case FILE: {
                return new FileReceiver(meta, 262144, stopChecker, this.fileIoFactory, hnd.fileHandler(nodeId, meta), hnd.filePath(nodeId, meta), this.log);
            }
            case CHUNK: {
                return new ChunkReceiver(meta, this.ctx.config().getDataStorageConfiguration().getPageSize(), stopChecker, hnd.chunkHandler(nodeId, meta), this.log);
            }
        }
        throw new IllegalStateException("The type of transmission policy is unknown. An implementation required: " + (Object)((Object)meta.policy()));
    }

    private static void configureChannel(SocketChannel channel, int timeout) throws IOException {
        channel.socket().setSoTimeout(timeout);
        channel.configureBlocking(true);
    }

    public void dumpStats() {
        CommunicationSpi spi = (CommunicationSpi)this.getSpi();
        if (spi instanceof TcpCommunicationSpi) {
            ((TcpCommunicationSpi)spi).dumpStats();
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> IO manager memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>  lsnrMapSize: " + this.lsnrMap.size(), new Object[0]);
        X.println(">>>  msgSetMapSize: " + this.msgSetMap.size(), new Object[0]);
        X.println(">>>  closedTopicsSize: " + this.closedTopics.sizex(), new Object[0]);
        X.println(">>>  discoWaitMapSize: " + this.waitMap.size(), new Object[0]);
    }

    private UUID secSubjId(GridIoMessage msg) {
        if (this.ctx.security().enabled()) {
            assert (msg instanceof GridIoSecurityAwareMessage);
            return ((GridIoSecurityAwareMessage)msg).secSubjId();
        }
        return null;
    }

    private /* synthetic */ boolean lambda$receiveFromChannel$5(ReceiverContext rcvCtx) {
        return this.stopping || rcvCtx.interrupted.get();
    }

    private final class TcpCommunicationInverseConnectionHandler
    implements ConnectionRequestor {
        private ExecutorService responseSendService;
        private CustomEventListener<TcpConnectionRequestDiscoveryMessage> discoConnReqLsnr;

        private TcpCommunicationInverseConnectionHandler() {
            this.responseSendService = Executors.newCachedThreadPool(new IgniteThreadFactory(GridIoManager.this.ctx.igniteInstanceName(), "io-send-service"));
            this.discoConnReqLsnr = (topVer, snd, msg) -> {
                if (!GridIoManager.this.locNodeId.equals(msg.receiverNodeId())) {
                    return;
                }
                int connIdx = msg.connectionIndex();
                if (GridIoManager.this.log.isInfoEnabled()) {
                    GridIoManager.this.log.info("Received inverse communication request from " + snd + " for connection index " + connIdx);
                }
                TcpCommunicationSpi tcpCommSpi = GridIoManager.this.getTcpCommunicationSpi();
                assert (!GridIoManager.this.isPairedConnection(snd, tcpCommSpi));
                this.responseSendService.submit(() -> {
                    try {
                        GridIoManager.this.send(snd, (Object)GridTopic.TOPIC_COMM_SYSTEM, GridTopic.TOPIC_COMM_SYSTEM.ordinal(), new TcpInverseConnectionResponseMessage(connIdx), (byte)2, false, 0L, false, null, false);
                    }
                    catch (IgniteCheckedException e) {
                        GridIoManager.this.log.error("Failed to send response to inverse communication connection request from node: " + snd.id(), e);
                    }
                });
            };
        }

        public void onStart() {
            if (GridIoManager.this.ctx.clientNode()) {
                GridIoManager.this.ctx.discovery().setCustomEventListener(TcpConnectionRequestDiscoveryMessage.class, ((GridIoManager)GridIoManager.this).invConnHandler.discoConnReqLsnr);
            }
            GridIoManager.this.addMessageListener(GridTopic.TOPIC_COMM_SYSTEM, (nodeId, msg, plc) -> {
                if (msg instanceof TcpInverseConnectionResponseMessage && GridIoManager.this.log.isInfoEnabled()) {
                    GridIoManager.this.log.info("Response for inverse connection received from node " + nodeId + ", connection index is " + ((TcpInverseConnectionResponseMessage)msg).connectionIndex());
                }
            });
        }

        @Override
        public void request(ClusterNode node, int connIdx) {
            TcpCommunicationSpi tcpCommSpi = GridIoManager.this.getTcpCommunicationSpi();
            if (GridIoManager.this.isPairedConnection(node, tcpCommSpi)) {
                throw new IgniteSpiException("Inverse connection protocol doesn't support paired connections");
            }
            try {
                if (GridIoManager.this.log.isInfoEnabled()) {
                    GridIoManager.this.log.info("TCP connection failed, node " + node.id() + " is unreachable, will attempt to request inverse connection via discovery SPI.");
                }
                TcpConnectionRequestDiscoveryMessage msg = new TcpConnectionRequestDiscoveryMessage(node.id(), connIdx);
                GridIoManager.this.ctx.discovery().sendCustomEvent(msg);
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteSpiException(ex);
            }
        }

        public void onStop() {
            U.shutdownNow(TcpCommunicationInverseConnectionHandler.class, this.responseSendService, GridIoManager.this.log);
        }
    }

    private static class IoTestNodeResults {
        private long latencyLimit;
        private long[] resLatency;
        private long totalLatency;
        private Collection<IgnitePair<Long>> maxLatency = new ArrayList<IgnitePair<Long>>();
        private Collection<IgnitePair<Long>> maxReqSendQueueTime = new ArrayList<IgnitePair<Long>>();
        private Collection<IgnitePair<Long>> maxReqRcvQueueTime = new ArrayList<IgnitePair<Long>>();
        private Collection<IgnitePair<Long>> maxResSendQueueTime = new ArrayList<IgnitePair<Long>>();
        private Collection<IgnitePair<Long>> maxResRcvQueueTime = new ArrayList<IgnitePair<Long>>();
        private Collection<IgnitePair<Long>> maxReqWireTimeMillis = new ArrayList<IgnitePair<Long>>();
        private Collection<IgnitePair<Long>> maxResWireTimeMillis = new ArrayList<IgnitePair<Long>>();

        private IoTestNodeResults() {
        }

        public void add(IoTestThreadLocalNodeResults res) {
            if (this.resLatency == null) {
                this.resLatency = (long[])res.resLatency.clone();
                this.latencyLimit = res.latencyLimit;
            } else {
                assert (this.latencyLimit == res.latencyLimit);
                assert (this.resLatency.length == res.resLatency.length);
                for (int i = 0; i < this.resLatency.length; ++i) {
                    int n = i;
                    this.resLatency[n] = this.resLatency[n] + res.resLatency[i];
                }
            }
            this.totalLatency += res.totalLatency;
            this.maxLatency.add(F.pair(res.maxLatency, res.maxLatencyTs));
            this.maxReqSendQueueTime.add(F.pair(res.maxReqSendQueueTime, res.maxReqSendQueueTimeTs));
            this.maxReqRcvQueueTime.add(F.pair(res.maxReqRcvQueueTime, res.maxReqRcvQueueTimeTs));
            this.maxResSendQueueTime.add(F.pair(res.maxResSendQueueTime, res.maxResSendQueueTimeTs));
            this.maxResRcvQueueTime.add(F.pair(res.maxResRcvQueueTime, res.maxResRcvQueueTimeTs));
            this.maxReqWireTimeMillis.add(F.pair(res.maxReqWireTimeMillis, res.maxReqWireTimeTs));
            this.maxResWireTimeMillis.add(F.pair(res.maxResWireTimeMillis, res.maxResWireTimeTs));
        }

        public long binLatencyMcs() {
            if (this.resLatency == null) {
                throw new IllegalStateException();
            }
            return this.latencyLimit / (long)(1000 * (this.resLatency.length - 1));
        }
    }

    private static class IoTestThreadLocalNodeResults {
        private final long[] resLatency;
        private final int rangesCnt;
        private long totalLatency;
        private long maxLatency;
        private long maxLatencyTs;
        private long maxReqSendQueueTime;
        private long maxReqSendQueueTimeTs;
        private long maxReqRcvQueueTime;
        private long maxReqRcvQueueTimeTs;
        private long maxResSendQueueTime;
        private long maxResSendQueueTimeTs;
        private long maxResRcvQueueTime;
        private long maxResRcvQueueTimeTs;
        private long maxReqWireTimeMillis;
        private long maxReqWireTimeTs;
        private long maxResWireTimeMillis;
        private long maxResWireTimeTs;
        private final long latencyLimit;

        public IoTestThreadLocalNodeResults(int rangesCnt, long latencyLimit) {
            this.rangesCnt = rangesCnt;
            this.latencyLimit = latencyLimit;
            this.resLatency = new long[rangesCnt + 1];
        }

        public void onResult(IgniteIoTestMessage msg) {
            long resWireTimeMillis;
            long reqWireTimeMillis;
            long resRcvQueueTime;
            long resSndQueueTime;
            long reqRcvQueueTime;
            long reqSndQueueTime;
            int idx;
            long now = System.currentTimeMillis();
            long latency = msg.responseProcessedTs() - msg.requestCreateTs();
            int n = idx = latency >= this.latencyLimit ? this.rangesCnt : (int)Math.floor(1.0 * (double)latency / (1.0 * (double)this.latencyLimit / (double)this.rangesCnt));
            this.resLatency[n] = this.resLatency[n] + 1L;
            this.totalLatency += latency;
            if (this.maxLatency < latency) {
                this.maxLatency = latency;
                this.maxLatencyTs = now;
            }
            if (this.maxReqSendQueueTime < (reqSndQueueTime = msg.requestSendTs() - msg.requestCreateTs())) {
                this.maxReqSendQueueTime = reqSndQueueTime;
                this.maxReqSendQueueTimeTs = now;
            }
            if (this.maxReqRcvQueueTime < (reqRcvQueueTime = msg.requestProcessTs() - msg.requestReceiveTs())) {
                this.maxReqRcvQueueTime = reqRcvQueueTime;
                this.maxReqRcvQueueTimeTs = now;
            }
            if (this.maxResSendQueueTime < (resSndQueueTime = msg.responseSendTs() - msg.requestProcessTs())) {
                this.maxResSendQueueTime = resSndQueueTime;
                this.maxResSendQueueTimeTs = now;
            }
            if (this.maxResRcvQueueTime < (resRcvQueueTime = msg.responseProcessedTs() - msg.responseReceiveTs())) {
                this.maxResRcvQueueTime = resRcvQueueTime;
                this.maxResRcvQueueTimeTs = now;
            }
            if (this.maxReqWireTimeMillis < (reqWireTimeMillis = msg.requestReceivedTsMillis() - msg.requestSendTsMillis())) {
                this.maxReqWireTimeMillis = reqWireTimeMillis;
                this.maxReqWireTimeTs = now;
            }
            if (this.maxResWireTimeMillis < (resWireTimeMillis = msg.responseReceivedTsMillis() - msg.requestSendTsMillis())) {
                this.maxResWireTimeMillis = resWireTimeMillis;
                this.maxResWireTimeTs = now;
            }
        }
    }

    private class IoTestFuture
    extends GridFutureAdapter<List<IgniteIoTestMessage>> {
        private final long id;
        private final int cntr;
        private final List<IgniteIoTestMessage> ress;

        IoTestFuture(long id, int cntr) {
            assert (cntr > 0) : cntr;
            this.id = id;
            this.cntr = cntr;
            this.ress = new ArrayList<IgniteIoTestMessage>(cntr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResponse(IgniteIoTestMessage res) {
            boolean complete;
            IoTestFuture ioTestFuture = this;
            synchronized (ioTestFuture) {
                this.ress.add(res);
                complete = this.cntr == this.ress.size();
            }
            if (complete) {
                this.onDone(this.ress);
            }
        }

        @Override
        public boolean onDone(List<IgniteIoTestMessage> res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                GridIoManager.this.ioTestMap().remove(this.id);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(IoTestFuture.class, this);
        }
    }

    private static class DelayedMessage {
        private final UUID nodeId;
        private final GridIoMessage msg;
        private final IgniteRunnable msgC;

        private DelayedMessage(UUID nodeId, GridIoMessage msg, IgniteRunnable msgC) {
            this.nodeId = nodeId;
            this.msg = msg;
            this.msgC = msgC;
        }

        public IgniteRunnable callback() {
            return this.msgC;
        }

        public GridIoMessage message() {
            return this.msg;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public String toString() {
            return S.toString(DelayedMessage.class, this, super.toString());
        }
    }

    private static class ConcurrentHashMap0<K, V>
    extends ConcurrentHashMap<K, V> {
        private static final long serialVersionUID = 0L;
        private int hash;

        private ConcurrentHashMap0() {
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                int hash0 = System.identityHashCode(this);
                this.hash = hash0 != 0 ? hash0 : -1;
            }
            return this.hash;
        }
    }

    private static class OrderedMessageContainer {
        GridIoMessage message;
        long addedTime;
        IgniteRunnable closure;
        Span parentSpan;

        private OrderedMessageContainer(GridIoMessage msg, Long addedTime, IgniteRunnable c, Span parentSpan) {
            this.message = msg;
            this.addedTime = addedTime;
            this.closure = c;
            this.parentSpan = parentSpan;
        }
    }

    private class GridCommunicationMessageSet
    implements GridTimeoutObject {
        private final UUID nodeId;
        private long endTime;
        private final IgniteUuid timeoutId;
        @GridToStringInclude
        private final Object topic;
        private final byte plc;
        @GridToStringInclude
        private final Queue<OrderedMessageContainer> msgs = new ConcurrentLinkedDeque<OrderedMessageContainer>();
        private final AtomicBoolean reserved = new AtomicBoolean();
        private final long timeout;
        private final boolean skipOnTimeout;
        private long lastTs;

        GridCommunicationMessageSet(byte plc, Object topic, UUID nodeId, long timeout, boolean skipOnTimeout, @Nullable GridIoMessage msg, IgniteRunnable msgC) {
            assert (nodeId != null);
            assert (topic != null);
            assert (msg != null);
            this.plc = plc;
            this.nodeId = nodeId;
            this.topic = topic;
            this.timeout = timeout == 0L ? GridIoManager.this.ctx.config().getNetworkTimeout() : timeout;
            this.skipOnTimeout = skipOnTimeout;
            this.endTime = this.endTime(timeout);
            this.timeoutId = IgniteUuid.randomUuid();
            this.lastTs = U.currentTimeMillis();
            this.msgs.add(new OrderedMessageContainer(msg, this.lastTs, msgC, MTC.span()));
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.timeoutId;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            ConcurrentMap map;
            GridMessageListener lsnr = GridIoManager.this.listenerGet0(this.topic);
            if (lsnr != null) {
                long delta = 0L;
                if (this.skipOnTimeout) {
                    while (true) {
                        delta = 0L;
                        boolean unwind = false;
                        GridCommunicationMessageSet gridCommunicationMessageSet = this;
                        synchronized (gridCommunicationMessageSet) {
                            if (!this.msgs.isEmpty() && (delta = U.currentTimeMillis() - this.lastTs) >= this.timeout) {
                                unwind = true;
                            }
                        }
                        if (!unwind) break;
                        GridIoManager.this.unwindMessageSet(this, lsnr);
                    }
                }
                this.endTime = this.endTime(this.timeout - delta);
                GridIoManager.this.ctx.timeout().addTimeoutObject(this);
                return;
            }
            if (GridIoManager.this.log.isDebugEnabled()) {
                GridIoManager.this.log.debug("Removing message set due to timeout: " + this);
            }
            if ((map = (ConcurrentMap)GridIoManager.this.msgSetMap.get(this.topic)) != null) {
                boolean rmv;
                ConcurrentMap concurrentMap = map;
                synchronized (concurrentMap) {
                    rmv = map.remove(this.nodeId, this) && map.isEmpty();
                }
                if (rmv) {
                    GridIoManager.this.msgSetMap.remove(this.topic, map);
                }
            }
        }

        UUID nodeId() {
            return this.nodeId;
        }

        byte policy() {
            return this.plc;
        }

        Object topic() {
            return this.topic;
        }

        boolean reserve() {
            return this.reserved.compareAndSet(false, true);
        }

        boolean reserved() {
            return this.reserved.get();
        }

        void release() {
            assert (this.reserved.get()) : "Message set was not reserved: " + this;
            this.reserved.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unwind(GridMessageListener lsnr) {
            assert (this.reserved.get());
            OrderedMessageContainer mc = this.msgs.poll();
            while (mc != null) {
                try (MTC.TraceSurroundings ignore = MTC.support(GridIoManager.this.ctx.tracing().create(SpanType.COMMUNICATION_ORDERED_PROCESS, mc.parentSpan));){
                    try {
                        OrderedMessageContainer fmc = mc;
                        MTC.span().addTag("message", () -> TraceableMessagesTable.traceName(fmc.message));
                        GridIoManager.this.invokeListener(this.plc, lsnr, this.nodeId, mc.message.message(), GridIoManager.this.secSubjId(mc.message));
                    }
                    finally {
                        if (mc.closure != null) {
                            mc.closure.run();
                        }
                    }
                }
                mc = this.msgs.poll();
            }
        }

        void add(GridIoMessage msg, @Nullable IgniteRunnable msgC) {
            this.msgs.add(new OrderedMessageContainer(msg, U.currentTimeMillis(), msgC, MTC.span()));
        }

        boolean changed() {
            return !this.msgs.isEmpty();
        }

        private long endTime(long timeout) {
            long endTime = U.currentTimeMillis() + timeout;
            if (endTime < 0L) {
                endTime = Long.MAX_VALUE;
            }
            return endTime;
        }

        public String toString() {
            return S.toString(GridCommunicationMessageSet.class, this);
        }
    }

    private class GridUserMessageListener
    implements GridMessageListener {
        private final IgniteBiPredicate<UUID, Object> predLsnr;
        private final Object topic;
        private final UUID initNodeId;

        GridUserMessageListener(@Nullable Object topic, @Nullable IgniteBiPredicate<UUID, Object> predLsnr, UUID initNodeId) {
            this.topic = topic;
            this.predLsnr = predLsnr;
            this.initNodeId = initNodeId;
        }

        GridUserMessageListener(@Nullable Object topic, IgniteBiPredicate<UUID, Object> predLsnr) {
            this(topic, predLsnr, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            block32: {
                if (!(msg instanceof GridIoUserMessage)) {
                    U.error(GridIoManager.this.log, "Received unknown message (potentially fatal problem): " + msg);
                    return;
                }
                GridIoUserMessage ioMsg = (GridIoUserMessage)msg;
                ClusterNode node = GridIoManager.this.ctx.discovery().node(nodeId);
                if (node == null) {
                    U.warn(GridIoManager.this.log, "Failed to resolve sender node (did the node left grid?): " + nodeId);
                    return;
                }
                Lock lock = GridIoManager.this.busyLock.readLock();
                lock.lock();
                try {
                    GridDeployment dep;
                    Object msgBody;
                    block31: {
                        if (GridIoManager.this.stopping) {
                            if (GridIoManager.this.log.isDebugEnabled()) {
                                GridIoManager.this.log.debug("Received user message while stopping (will ignore) [nodeId=" + nodeId + ", msg=" + msg + ']');
                            }
                            return;
                        }
                        msgBody = ioMsg.body();
                        assert (msgBody != null || ioMsg.bodyBytes() != null);
                        byte[] msgTopicBytes = ioMsg.topicBytes();
                        Object msgTopic = ioMsg.topic();
                        dep = ioMsg.deployment();
                        if (dep == null && GridIoManager.this.ctx.config().isPeerClassLoadingEnabled() && ioMsg.deploymentClassName() != null) {
                            dep = GridIoManager.this.ctx.deploy().getGlobalDeployment(ioMsg.deploymentMode(), ioMsg.deploymentClassName(), ioMsg.deploymentClassName(), ioMsg.userVersion(), nodeId, ioMsg.classLoaderId(), ioMsg.loaderParticipants(), null);
                            if (dep == null) {
                                throw new IgniteDeploymentCheckedException("Failed to obtain deployment information for user message. If you are using custom message or topic class, try implementing GridPeerDeployAware interface. [msg=" + ioMsg + ']');
                            }
                            ioMsg.deployment(dep);
                        }
                        if (msgTopic == null && msgTopicBytes != null) {
                            msgTopic = U.unmarshal(GridIoManager.this.marsh, msgTopicBytes, U.resolveClassLoader(dep != null ? dep.classLoader() : null, GridIoManager.this.ctx.config()));
                            ioMsg.topic(msgTopic);
                        }
                        if (F.eq(this.topic, msgTopic)) break block31;
                        return;
                    }
                    try {
                        if (msgBody == null) {
                            msgBody = U.unmarshal(GridIoManager.this.marsh, ioMsg.bodyBytes(), U.resolveClassLoader(dep != null ? dep.classLoader() : null, GridIoManager.this.ctx.config()));
                            ioMsg.body(msgBody);
                        }
                        if (dep != null) {
                            GridIoManager.this.ctx.resource().inject(dep, dep.deployedClass(ioMsg.deploymentClassName(), new String[0]).get1(), msgBody);
                        }
                    }
                    catch (IgniteCheckedException e) {
                        U.error(GridIoManager.this.log, "Failed to unmarshal user message [node=" + nodeId + ", message=" + msg + ']', e);
                    }
                    if (msgBody == null || this.predLsnr == null) break block32;
                    try (OperationSecurityContext s = GridIoManager.this.ctx.security().withContext(this.initNodeId);){
                        if (!this.predLsnr.apply(nodeId, msgBody)) {
                            GridIoManager.this.removeMessageListener(GridTopic.TOPIC_COMM_USER, (GridMessageListener)this);
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridUserMessageListener l = (GridUserMessageListener)o;
            return F.eq(this.predLsnr, l.predLsnr) && F.eq(this.topic, l.topic);
        }

        public int hashCode() {
            int res = this.predLsnr != null ? this.predLsnr.hashCode() : 0;
            res = 31 * res + (this.topic != null ? this.topic.hashCode() : 0);
            return res;
        }

        public String toString() {
            return S.toString(GridUserMessageListener.class, this);
        }
    }

    private static class ArrayListener
    implements GridMessageListener {
        private volatile GridMessageListener[] arr;

        ArrayListener(GridMessageListener ... arr) {
            this.arr = arr;
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            GridMessageListener[] arr0 = this.arr;
            if (arr0 == null) {
                return;
            }
            for (GridMessageListener l : arr0) {
                l.onMessage(nodeId, msg, plc);
            }
        }

        boolean isEmpty() {
            return this.arr == null;
        }

        synchronized boolean remove(GridMessageListener l) {
            GridMessageListener[] arr0 = this.arr;
            if (arr0 == null) {
                return false;
            }
            if (arr0.length == 1) {
                if (!arr0[0].equals(l)) {
                    return false;
                }
                this.arr = null;
                return true;
            }
            for (int i = 0; i < arr0.length; ++i) {
                if (!arr0[i].equals(l)) continue;
                int newLen = arr0.length - 1;
                if (i == newLen) {
                    this.arr = Arrays.copyOf(arr0, newLen);
                } else {
                    GridMessageListener[] arr1 = new GridMessageListener[newLen];
                    if (i != 0) {
                        System.arraycopy(arr0, 0, arr1, 0, i);
                    }
                    System.arraycopy(arr0, i + 1, arr1, i, newLen - i);
                    this.arr = arr1;
                }
                return true;
            }
            return false;
        }

        synchronized boolean add(GridMessageListener l) {
            GridMessageListener[] arr0 = this.arr;
            if (arr0 == null) {
                return false;
            }
            int oldLen = arr0.length;
            arr0 = Arrays.copyOf(arr0, oldLen + 1);
            arr0[oldLen] = l;
            this.arr = arr0;
            return true;
        }
    }

    public class TransmissionSender
    implements Closeable {
        private final UUID rmtId;
        private final Object topic;
        private T2<UUID, IgniteUuid> sesKey;
        private SocketChannel channel;
        private ObjectOutput out;
        private ObjectInput in;

        public TransmissionSender(UUID rmtId, Object topic) {
            this.rmtId = rmtId;
            this.topic = topic;
            this.sesKey = new T2<UUID, IgniteUuid>(rmtId, IgniteUuid.randomUuid());
        }

        private TransmissionMeta connect() throws IgniteCheckedException, IOException {
            TransmissionMeta syncMeta;
            SocketChannel channel = (SocketChannel)GridIoManager.this.openChannel(this.rmtId, this.topic, new SessionChannelMessage((IgniteUuid)this.sesKey.get2())).get();
            GridIoManager.configureChannel(channel, GridIoManager.this.netTimeoutMs);
            this.channel = channel;
            this.out = new ObjectOutputStream(channel.socket().getOutputStream());
            this.in = new ObjectInputStream(channel.socket().getInputStream());
            try {
                syncMeta = (TransmissionMeta)this.in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IgniteException(e);
            }
            return syncMeta;
        }

        public void send(File file, Map<String, Serializable> params, TransmissionPolicy plc) throws IgniteCheckedException, InterruptedException, IOException {
            this.send(file, 0L, file.length(), params, plc);
        }

        public void send(File file, TransmissionPolicy plc) throws IgniteCheckedException, InterruptedException, IOException {
            this.send(file, 0L, file.length(), new HashMap<String, Serializable>(), plc);
        }

        public void send(File file, long offset, long cnt, Map<String, Serializable> params, TransmissionPolicy plc) throws IgniteCheckedException, InterruptedException, IOException {
            long startTime = U.currentTimeMillis();
            int retries = 0;
            GridIoManager.this.senderStopFlags.putIfAbsent(this.sesKey, new AtomicBoolean());
            try (FileSender snd = new FileSender(file, offset, cnt, params, plc, () -> GridIoManager.this.stopping || ((AtomicBoolean)GridIoManager.this.senderStopFlags.get(this.sesKey)).get(), GridIoManager.this.log, GridIoManager.this.fileIoFactory, 262144);){
                if (GridIoManager.this.log.isDebugEnabled()) {
                    GridIoManager.this.log.debug("Start writing file to remote node [file=" + file.getName() + ", rmtNodeId=" + this.rmtId + ", topic=" + this.topic + ']');
                }
                while (true) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException("The thread has been interrupted. Stop uploading file.");
                    }
                    if (GridIoManager.this.stopping) {
                        throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
                    }
                    try {
                        TransmissionMeta rcvMeta = null;
                        if (this.out == null && this.in == null) {
                            rcvMeta = this.connect();
                            assert (rcvMeta != null) : "Remote receiver has not sent its meta";
                            if (rcvMeta.error() != null) {
                                throw rcvMeta.error();
                            }
                        }
                        snd.send(this.channel, this.out, rcvMeta);
                        boolean written = this.in.readBoolean();
                        assert (written) : "File is not fully written: " + file.getAbsolutePath();
                    }
                    catch (IOException e) {
                        this.closeChannelQuiet();
                        if (++retries >= GridIoManager.this.retryCnt) {
                            throw new IgniteException("The number of retry attempts to upload file exceeded the limit: " + GridIoManager.this.retryCnt, e);
                        }
                        U.warn(GridIoManager.this.log, "Connection lost while writing a file to remote node and will be reestablished [rmtId=" + this.rmtId + ", file=" + file.getName() + ", sesKey=" + this.sesKey + ", retries=" + retries + ", transferred=" + snd.transferred() + ", total=" + snd.state().count() + ']', e);
                        continue;
                    }
                    break;
                }
                U.log(GridIoManager.this.log, "File has been sent to remote node [name=" + file.getName() + ", uploadTime=" + (double)((U.currentTimeMillis() - startTime) / 1000L) + " sec, retries=" + retries + ", transferred=" + snd.transferred() + ", rmtId=" + this.rmtId + ", rmtAddr=" + this.channel.getRemoteAddress() + ']');
            }
            catch (InterruptedException e) {
                this.closeChannelQuiet();
                throw e;
            }
            catch (IgniteCheckedException e) {
                this.closeChannelQuiet();
                if (X.hasCause((Throwable)e, TransmissionCancelledException.class)) {
                    throw new TransmissionCancelledException("File transmission has been cancelled on the remote node [rmtId=" + this.rmtId + ", file=" + file.getName() + ", sesKey=" + this.sesKey + ", retries=" + retries + ", cause='" + e.getCause(TransmissionCancelledException.class).getMessage() + "']");
                }
                throw new IgniteCheckedException("Exception while sending file [rmtId=" + this.rmtId + ", file=" + file.getName() + ", sesKey=" + this.sesKey + ", retries=" + retries + ']', e);
            }
            catch (Throwable e) {
                this.closeChannelQuiet();
                if (GridIoManager.this.stopping) {
                    throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
                }
                if (((AtomicBoolean)GridIoManager.this.senderStopFlags.get(this.sesKey)).get()) {
                    throw new ClusterTopologyCheckedException("Remote node left the cluster: " + this.rmtId, e);
                }
                throw new IgniteException("Unexpected exception while sending file to the remote node. The process stopped [rmtId=" + this.rmtId + ", file=" + file.getName() + ", sesKey=" + this.sesKey + ']', e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                GridIoManager.this.senderStopFlags.remove(this.sesKey);
                ObjectOutput out0 = this.out;
                if (out0 == null) {
                    return;
                }
                U.log(GridIoManager.this.log, "Close file writer session: " + this.sesKey);
                out0.writeBoolean(true);
                out0.flush();
            }
            catch (IOException e) {
                U.warn(GridIoManager.this.log, "An exception while writing close session flag occured.  Session close operation has been ignored", e);
            }
            finally {
                this.closeChannelQuiet();
            }
        }

        private void closeChannelQuiet() {
            U.closeQuiet(this.out);
            U.closeQuiet(this.in);
            U.closeQuiet(this.channel);
            this.out = null;
            this.in = null;
            this.channel = null;
        }
    }

    private static class ReceiverContext {
        private final UUID rmtNodeId;
        @GridToStringExclude
        private final TransmissionHandler hnd;
        private final IgniteUuid sesId;
        private final AtomicBoolean interrupted = new AtomicBoolean();
        private final Lock lock = new ReentrantLock();
        private TransmissionReceiver rcv;
        private TransmissionMeta lastState;
        private GridTimeoutObject timeoutObj;

        public ReceiverContext(UUID rmtNodeId, TransmissionHandler hnd, IgniteUuid sesId) {
            this.rmtNodeId = rmtNodeId;
            this.hnd = hnd;
            this.sesId = sesId;
        }

        public String toString() {
            return S.toString(ReceiverContext.class, this);
        }

        static /* synthetic */ TransmissionReceiver access$6002(ReceiverContext x0, TransmissionReceiver x1) {
            x0.rcv = x1;
            return x0.rcv;
        }

        static /* synthetic */ GridTimeoutObject access$5902(ReceiverContext x0, GridTimeoutObject x1) {
            x0.timeoutObj = x1;
            return x0.timeoutObj;
        }
    }
}

