/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.commandline.ProgressPrinter;
import org.apache.ignite.internal.commandline.indexreader.ItemStorage;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;

class ScanContext {
    final int cacheId;
    final String idxName;
    final int inlineFldCnt;
    final FilePageStore store;
    final Map<Class<? extends PageIO>, PagesStatistic> stats;
    long errCnt;
    final ItemStorage items;
    int[] inline;
    private final IgniteLogger log;
    private final String prefix;
    private final ProgressPrinter printer;

    public ScanContext(int cacheId, String idxName, int inlineFldCnt, FilePageStore store, ItemStorage items, IgniteLogger log, String prefix, ProgressPrinter printer) {
        this.cacheId = cacheId;
        this.idxName = idxName;
        this.inlineFldCnt = inlineFldCnt;
        this.store = store;
        this.items = items;
        this.stats = new LinkedHashMap<Class<? extends PageIO>, PagesStatistic>();
        this.log = log;
        this.prefix = prefix;
        this.printer = printer;
    }

    public void progress() {
        if (this.printer != null) {
            this.printer.printProgress();
        }
    }

    public void addToStats(PageIO io, long addr) {
        ScanContext.addToStats(io, this.stats, 1L, addr, this.store.getPageSize());
    }

    public static void addToStats(PageIO io, Map<Class<? extends PageIO>, PagesStatistic> stats, long cnt, long addr, int pageSize) {
        PagesStatistic stat = stats.computeIfAbsent(io.getClass(), k -> new PagesStatistic());
        stat.cnt += cnt;
        stat.freeSpace += (long)io.getFreeSpace(pageSize, addr);
    }

    public static void addToStats(Class<? extends PageIO> io, Map<Class<? extends PageIO>, PagesStatistic> stats, PagesStatistic toAdd) {
        PagesStatistic stat = stats.computeIfAbsent(io, k -> new PagesStatistic());
        stat.cnt += toAdd.cnt;
        stat.freeSpace += toAdd.freeSpace;
    }

    public void onLeafPage(long pageId, List<Object> data) {
        data.forEach(this.items::add);
    }

    public void onError(long pageId, String message) {
        if (this.errCnt == 0L) {
            this.log.warning(this.prefix + "<ERROR> " + "-----");
            this.log.warning(this.prefix + "<ERROR> " + "Index tree: " + this.idxName);
            this.log.warning(this.prefix + "<ERROR> " + "---- Errors:");
        }
        ++this.errCnt;
        ScanContext.onError(this.log, this.prefix, pageId, message);
    }

    public static void onError(IgniteLogger log, String prefix, long pageId, String message) {
        log.warning(prefix + "<ERROR> " + "Page id: " + pageId + ", exceptions: " + message);
    }

    static class PagesStatistic {
        long cnt;
        long freeSpace;

        PagesStatistic() {
        }
    }
}

