/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.ClusterTagUpdatedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteDiagnosticInfo;
import org.apache.ignite.internal.IgniteDiagnosticMessage;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.ClusterIdAndTag;
import org.apache.ignite.internal.processors.cluster.ClusterMetricsUpdateMessage;
import org.apache.ignite.internal.processors.cluster.ClusterNodeMetrics;
import org.apache.ignite.internal.processors.cluster.ClusterTagGenerator;
import org.apache.ignite.internal.processors.cluster.GridUpdateNotifier;
import org.apache.ignite.internal.processors.cluster.IgniteClusterMXBeanImpl;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.GridTimerTask;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.mxbean.IgniteClusterMXBean;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.jetbrains.annotations.Nullable;

public class ClusterProcessor
extends GridProcessorAdapter
implements DistributedMetastorageLifecycleListener {
    private static final String ATTR_UPDATE_NOTIFIER_STATUS = "UPDATE_NOTIFIER_STATUS";
    private static final String CLUSTER_ID_TAG_KEY = "ignite.internal.cluster.id.tag";
    private static final String M_BEAN_NAME = "IgniteCluster";
    private static final long PERIODIC_VER_CHECK_DELAY = 3600000L;
    private static final long PERIODIC_VER_CHECK_CONN_TIMEOUT = 10000L;
    public static final String TOTAL_SERVER_NODES = "TotalServerNodes";
    public static final String TOTAL_CLIENT_NODES = "TotalClientNodes";
    public static final String TOTAL_BASELINE_NODES = "TotalBaselineNodes";
    public static final String ACTIVE_BASELINE_NODES = "ActiveBaselineNodes";
    public static final boolean DFLT_UPDATE_NOTIFIER = true;
    public static final boolean DFLT_DIAGNOSTIC_ENABLED = true;
    private IgniteClusterImpl cluster;
    private final AtomicBoolean notifyEnabled = new AtomicBoolean();
    @GridToStringExclude
    private Timer updateNtfTimer;
    @GridToStringExclude
    private GridUpdateNotifier verChecker;
    private final AtomicReference<ConcurrentHashMap<Long, InternalDiagnosticFuture>> diagnosticFutMap = new AtomicReference();
    private final AtomicLong diagFutId = new AtomicLong();
    private final Map<UUID, byte[]> allNodesMetrics = new ConcurrentHashMap<UUID, byte[]>();
    private final JdkMarshaller marsh = new JdkMarshaller();
    private DiscoveryMetricsProvider metricsProvider;
    private boolean sndMetrics;
    private volatile UUID locClusterId;
    private volatile String locClusterTag;
    private volatile DistributedMetaStorage metastorage;
    private ObjectName mBean;

    public ClusterProcessor(GridKernalContext ctx) {
        super(ctx);
        this.notifyEnabled.set(IgniteSystemProperties.getBoolean("IGNITE_UPDATE_NOTIFIER", true));
        this.cluster = new IgniteClusterImpl(ctx);
        this.sndMetrics = !(ctx.config().getDiscoverySpi() instanceof TcpDiscoverySpi);
    }

    public boolean diagnosticEnabled() {
        return IgniteSystemProperties.getBoolean("IGNITE_DIAGNOSTIC_ENABLED", true);
    }

    @Override
    public void start() throws IgniteCheckedException {
        GridInternalSubscriptionProcessor isp = this.ctx.internalSubscriptionProcessor();
        isp.registerDistributedMetastorageListener(this);
        this.cluster.start();
    }

    @Override
    public void onReadyForRead(ReadableDistributedMetaStorage metastorage) {
        ClusterIdAndTag idAndTag = (ClusterIdAndTag)this.readKey(metastorage, CLUSTER_ID_TAG_KEY, "Reading cluster ID and tag from metastorage failed, default values will be generated");
        if (this.log.isInfoEnabled()) {
            this.log.info("Cluster ID and tag has been read from metastorage: " + idAndTag);
        }
        if (idAndTag != null) {
            this.locClusterId = idAndTag.id();
            this.locClusterTag = idAndTag.tag();
        }
        metastorage.listen(k -> k.equals(CLUSTER_ID_TAG_KEY), (k, oldVal, newVal) -> {
            if (this.log.isInfoEnabled()) {
                this.log.info("Cluster tag will be set to new value: " + (newVal != null ? newVal.tag() : "null") + ", previous value was: " + (oldVal != null ? oldVal.tag() : "null"));
            }
            if (oldVal != null && newVal != null && this.ctx.event().isRecordable(143)) {
                String msg = "Tag of cluster with id " + oldVal.id() + " has been updated to new value: " + newVal.tag() + ", previous value was " + oldVal.tag();
                this.ctx.closure().runLocalSafe(() -> this.ctx.event().record(new ClusterTagUpdatedEvent(this.ctx.discovery().localNode(), msg, oldVal.id(), oldVal.tag(), newVal.tag())));
            }
            this.cluster.setTag(newVal != null ? newVal.tag() : null);
        });
    }

    private <T extends Serializable> T readKey(ReadableDistributedMetaStorage metastorage, String key, String errMsg) {
        try {
            return metastorage.read(key);
        }
        catch (IgniteCheckedException e) {
            U.warn(this.log, errMsg, e);
            return null;
        }
    }

    @Override
    public void onReadyForWrite(DistributedMetaStorage metastorage) {
        this.metastorage = metastorage;
        this.ctx.closure().runLocalSafe(() -> {
            try {
                ClusterIdAndTag idAndTag = new ClusterIdAndTag(this.cluster.id(), this.cluster.tag());
                if (this.log.isInfoEnabled()) {
                    this.log.info("Writing cluster ID and tag to metastorage on ready for write " + idAndTag);
                }
                metastorage.writeAsync(CLUSTER_ID_TAG_KEY, idAndTag);
            }
            catch (IgniteCheckedException e) {
                this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
        });
    }

    public void updateTag(String newTag) throws IgniteCheckedException {
        ClusterIdAndTag oldTag = (ClusterIdAndTag)this.metastorage.read(CLUSTER_ID_TAG_KEY);
        if (oldTag == null) {
            throw new IgniteCheckedException("Cannot change tag as default tag has not been set yet. Please try again later.");
        }
        if (!this.metastorage.compareAndSet(CLUSTER_ID_TAG_KEY, oldTag, new ClusterIdAndTag(oldTag.id(), newTag))) {
            ClusterIdAndTag concurrentValue = (ClusterIdAndTag)this.metastorage.read(CLUSTER_ID_TAG_KEY);
            throw new IgniteCheckedException("Cluster tag has been concurrently updated to different value: " + concurrentValue.tag());
        }
        this.cluster.setTag(newTag);
    }

    public void onLocalJoin() {
        this.cluster.setId(this.locClusterId != null ? this.locClusterId : UUID.randomUUID());
        this.cluster.setTag(this.locClusterTag != null ? this.locClusterTag : ClusterTagGenerator.generateTag());
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        assert (this.ctx.clientNode());
        this.locClusterId = null;
        this.locClusterTag = null;
        this.cluster.setId(null);
        this.cluster.setTag(null);
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) {
        assert (this.ctx.clientNode());
        this.cluster.setId(this.locClusterId);
        this.cluster.setTag(this.locClusterTag);
        return null;
    }

    public void initDiagnosticListeners() throws IgniteCheckedException {
        this.ctx.event().addLocalEventListener(new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent);
                assert (evt.type() == 12 || evt.type() == 11);
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                UUID nodeId = discoEvt.eventNode().id();
                ConcurrentHashMap futs = (ConcurrentHashMap)ClusterProcessor.this.diagnosticFutMap.get();
                if (futs != null) {
                    for (InternalDiagnosticFuture fut : futs.values()) {
                        if (!fut.nodeId.equals(nodeId)) continue;
                        fut.onDone(new IgniteDiagnosticInfo("Target node failed: " + nodeId));
                    }
                }
                ClusterProcessor.this.allNodesMetrics.remove(nodeId);
            }
        }, 12, 11);
        this.ctx.io().addMessageListener(GridTopic.TOPIC_INTERNAL_DIAGNOSTIC, new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof IgniteDiagnosticMessage) {
                    IgniteDiagnosticMessage msg0 = (IgniteDiagnosticMessage)msg;
                    if (msg0.request()) {
                        byte[] diagRes;
                        ClusterNode node = ClusterProcessor.this.ctx.discovery().node(nodeId);
                        if (node == null) {
                            if (ClusterProcessor.this.diagnosticLog.isDebugEnabled()) {
                                ClusterProcessor.this.diagnosticLog.debug("Skip diagnostic request, sender node left [node=" + nodeId + ", msg=" + msg + ']');
                            }
                            return;
                        }
                        try {
                            IgniteClosure c = (IgniteClosure)msg0.unmarshal(ClusterProcessor.this.marsh);
                            diagRes = ClusterProcessor.this.marsh.marshal(c.apply(ClusterProcessor.this.ctx));
                        }
                        catch (Exception e) {
                            U.error(ClusterProcessor.this.diagnosticLog, "Failed to run diagnostic closure: " + e, e);
                            try {
                                IgniteDiagnosticInfo errInfo = new IgniteDiagnosticInfo("Failed to run diagnostic closure: " + e);
                                diagRes = ClusterProcessor.this.marsh.marshal(errInfo);
                            }
                            catch (Exception e0) {
                                U.error(ClusterProcessor.this.diagnosticLog, "Failed to marshal diagnostic closure result: " + e, e);
                                diagRes = null;
                            }
                        }
                        IgniteDiagnosticMessage res = IgniteDiagnosticMessage.createResponse(diagRes, msg0.futureId());
                        try {
                            ClusterProcessor.this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_INTERNAL_DIAGNOSTIC, (Message)res, (byte)2);
                        }
                        catch (ClusterTopologyCheckedException e) {
                            if (ClusterProcessor.this.diagnosticLog.isDebugEnabled()) {
                                ClusterProcessor.this.diagnosticLog.debug("Failed to send diagnostic response, node left [node=" + nodeId + ", msg=" + msg + ']');
                            }
                        }
                        catch (IgniteCheckedException e) {
                            U.error(ClusterProcessor.this.diagnosticLog, "Failed to send diagnostic response [msg=" + msg0 + "]", e);
                        }
                    } else {
                        InternalDiagnosticFuture fut = (InternalDiagnosticFuture)ClusterProcessor.this.diagnosticFuturesMap().get(msg0.futureId());
                        if (fut != null) {
                            IgniteDiagnosticInfo res;
                            try {
                                res = (IgniteDiagnosticInfo)msg0.unmarshal(ClusterProcessor.this.marsh);
                                if (res == null) {
                                    res = new IgniteDiagnosticInfo("Remote node failed to marshal response.");
                                }
                            }
                            catch (Exception e) {
                                U.error(ClusterProcessor.this.diagnosticLog, "Failed to unmarshal diagnostic response: " + e, e);
                                res = new IgniteDiagnosticInfo("Failed to unmarshal diagnostic response: " + e);
                            }
                            fut.onResponse(res);
                        } else {
                            U.warn(ClusterProcessor.this.diagnosticLog, "Failed to find diagnostic message future [msg=" + msg0 + ']');
                        }
                    }
                } else {
                    U.warn(ClusterProcessor.this.diagnosticLog, "Received unexpected message: " + msg);
                }
            }
        });
        if (this.sndMetrics) {
            this.ctx.io().addMessageListener(GridTopic.TOPIC_METRICS, new GridMessageListener(){

                @Override
                public void onMessage(UUID nodeId, Object msg, byte plc) {
                    if (msg instanceof ClusterMetricsUpdateMessage) {
                        ClusterProcessor.this.processMetricsUpdateMessage(nodeId, (ClusterMetricsUpdateMessage)msg);
                    } else {
                        U.warn(ClusterProcessor.this.log, "Received unexpected message for TOPIC_METRICS: " + msg);
                    }
                }
            });
        }
    }

    public IgniteLogger diagnosticLog() {
        return this.diagnosticLog;
    }

    public IgniteClusterImpl get() {
        return this.cluster;
    }

    public IgniteFuture<?> clientReconnectFuture() {
        IgniteFinishedFutureImpl fut = this.cluster.clientReconnectFuture();
        return fut != null ? fut : new IgniteFinishedFutureImpl();
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.CLUSTER_PROC;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.CLUSTER_PROC.ordinal(), this.getDiscoveryData());
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        dataBag.addNodeSpecificData(GridComponent.DiscoveryDataExchangeType.CLUSTER_PROC.ordinal(), this.getDiscoveryData());
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.CLUSTER_PROC.ordinal(), new ClusterIdAndTag(this.cluster.id(), this.cluster.tag()));
    }

    private Serializable getDiscoveryData() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        map.put(ATTR_UPDATE_NOTIFIER_STATUS, this.notifyEnabled.get());
        return map;
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        ClusterIdAndTag commonData;
        Boolean lstFlag;
        Map<UUID, Serializable> nodeSpecData = data.nodeSpecificData();
        if (nodeSpecData != null && (lstFlag = this.findLastFlag(nodeSpecData.values())) != null) {
            this.notifyEnabled.set(lstFlag);
        }
        if ((commonData = (ClusterIdAndTag)data.commonData()) != null) {
            String remoteClusterTag;
            UUID remoteClusterId = commonData.id();
            if (remoteClusterId != null) {
                if (this.locClusterId != null && !this.locClusterId.equals(remoteClusterId)) {
                    this.log.warning("Received cluster ID differs from locally stored cluster ID and will be rewritten. Received cluster ID: " + remoteClusterId + ", local cluster ID: " + this.locClusterId);
                }
                this.locClusterId = remoteClusterId;
            }
            if ((remoteClusterTag = commonData.tag()) != null) {
                this.locClusterTag = remoteClusterTag;
            }
        }
    }

    private Boolean findLastFlag(Collection<Serializable> vals) {
        Boolean flag = null;
        for (Serializable ser : vals) {
            Map map;
            if (ser == null || !(map = (Map)((Object)ser)).containsKey(ATTR_UPDATE_NOTIFIER_STATUS)) continue;
            flag = (Boolean)map.get(ATTR_UPDATE_NOTIFIER_STATUS);
        }
        return flag;
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        block8: {
            if (this.notifyEnabled.get()) {
                try {
                    this.verChecker = new GridUpdateNotifier(this.ctx.igniteInstanceName(), IgniteVersionUtils.VER_STR, false);
                    this.updateNtfTimer = new Timer("ignite-update-notifier-timer", true);
                    this.updateNtfTimer.scheduleAtFixedRate((TimerTask)new UpdateNotifierTimerTask((IgniteKernal)this.ctx.grid(), this.verChecker, this.notifyEnabled), 0L, 3600000L);
                }
                catch (IgniteCheckedException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug("Failed to create GridUpdateNotifier: " + e);
                }
            }
        }
        if (this.sndMetrics) {
            this.metricsProvider = this.ctx.discovery().createMetricsProvider();
            long updateFreq = this.ctx.config().getMetricsUpdateFrequency();
            this.ctx.timeout().addTimeoutObject(new MetricsUpdateTimeoutObject(updateFreq));
        }
        IgniteClusterMXBeanImpl mxBeanImpl = new IgniteClusterMXBeanImpl(this.cluster);
        if (!U.IGNITE_MBEANS_DISABLED) {
            try {
                this.mBean = U.registerMBean(this.ctx.config().getMBeanServer(), this.ctx.igniteInstanceName(), M_BEAN_NAME, mxBeanImpl.getClass().getSimpleName(), mxBeanImpl, IgniteClusterMXBean.class);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Registered IgniteCluster MBean: " + this.mBean);
                }
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to register MBean for cluster: ", e);
            }
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.unregisterMBean();
    }

    private void unregisterMBean() {
        ObjectName mBeanName = this.mBean;
        if (mBeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.ctx.config().getMBeanServer().unregisterMBean(mBeanName);
            this.mBean = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered IgniteCluster MBean: " + mBeanName);
            }
        }
        catch (JMException e) {
            U.error(this.log, "Failed to unregister IgniteCluster MBean: " + mBeanName, e);
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.updateNtfTimer != null) {
            this.updateNtfTimer.cancel();
        }
        if (this.verChecker != null) {
            this.verChecker.stop();
        }
        if (this.ctx.io() != null) {
            this.ctx.io().removeMessageListener(GridTopic.TOPIC_INTERNAL_DIAGNOSTIC);
        }
    }

    public void registerMetrics() {
        MetricRegistry reg = this.ctx.metric().registry("cluster");
        reg.register(TOTAL_SERVER_NODES, () -> this.ctx.isStopping() || this.ctx.clientDisconnected() ? -1 : this.cluster.forServers().nodes().size(), "Server nodes count.");
        reg.register(TOTAL_CLIENT_NODES, () -> this.ctx.isStopping() || this.ctx.clientDisconnected() ? -1 : this.cluster.forClients().nodes().size(), "Client nodes count.");
        reg.register(TOTAL_BASELINE_NODES, () -> this.ctx.isStopping() || this.ctx.clientDisconnected() ? -1 : F.size(this.cluster.currentBaselineTopology(), new IgnitePredicate[0]), "Total baseline nodes count.");
        reg.register(ACTIVE_BASELINE_NODES, () -> {
            if (this.ctx.isStopping() || this.ctx.clientDisconnected()) {
                return -1;
            }
            Collection<Object> srvIds = F.nodeConsistentIds(this.cluster.forServers().nodes());
            return F.size(this.cluster.currentBaselineTopology(), node -> srvIds.contains(node.consistentId()));
        }, "Active baseline nodes count.");
    }

    private void processMetricsUpdateMessage(UUID sndNodeId, ClusterMetricsUpdateMessage msg) {
        byte[] nodeMetrics = msg.nodeMetrics();
        if (nodeMetrics != null) {
            assert (msg.allNodesMetrics() == null);
            this.allNodesMetrics.put(sndNodeId, nodeMetrics);
            this.updateNodeMetrics(this.ctx.discovery().discoCache(), sndNodeId, nodeMetrics);
        } else {
            Map<UUID, byte[]> allNodesMetrics = msg.allNodesMetrics();
            assert (allNodesMetrics != null);
            DiscoCache discoCache = this.ctx.discovery().discoCache();
            for (Map.Entry<UUID, byte[]> e : allNodesMetrics.entrySet()) {
                if (this.ctx.localNodeId().equals(e.getKey())) continue;
                this.updateNodeMetrics(discoCache, e.getKey(), e.getValue());
            }
        }
    }

    private void updateNodeMetrics(DiscoCache discoCache, UUID nodeId, byte[] metricsBytes) {
        ClusterNode node = discoCache.node(nodeId);
        if (node == null || !discoCache.alive(nodeId)) {
            return;
        }
        try {
            ClusterNodeMetrics metrics = (ClusterNodeMetrics)U.unmarshalZip(this.ctx.config().getMarshaller(), metricsBytes, null);
            assert (node instanceof IgniteClusterNode) : node;
            IgniteClusterNode node0 = (IgniteClusterNode)node;
            node0.setMetrics(ClusterMetricsSnapshot.deserialize(metrics.metrics(), 0));
            node0.setCacheMetrics(metrics.cacheMetrics());
            this.ctx.discovery().metricsUpdateEvent(discoCache, node0);
        }
        catch (IgniteCheckedException e) {
            U.warn(this.log, "Failed to unmarshal node metrics: " + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMetrics() {
        if (this.ctx.isStopping() || this.ctx.clientDisconnected()) {
            return;
        }
        ClusterNode oldest = this.ctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
        if (oldest == null) {
            return;
        }
        if (this.ctx.localNodeId().equals(oldest.id())) {
            IgniteClusterNode locNode = (IgniteClusterNode)this.ctx.discovery().localNode();
            locNode.setMetrics(this.metricsProvider.metrics());
            locNode.setCacheMetrics(this.metricsProvider.cacheMetrics());
            ClusterNodeMetrics metrics = new ClusterNodeMetrics(locNode.metrics(), locNode.cacheMetrics());
            try {
                byte[] metricsBytes = U.zip(U.marshal(this.ctx.config().getMarshaller(), (Object)metrics));
                this.allNodesMetrics.put(this.ctx.localNodeId(), metricsBytes);
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Failed to marshal local node metrics: " + e, e);
            }
            this.ctx.discovery().metricsUpdateEvent(this.ctx.discovery().discoCache(), locNode);
            Collection<ClusterNode> allNodes = this.ctx.discovery().allNodes();
            ClusterMetricsUpdateMessage msg = new ClusterMetricsUpdateMessage(new HashMap<UUID, byte[]>(this.allNodesMetrics));
            for (ClusterNode node : allNodes) {
                if (this.ctx.localNodeId().equals(node.id()) || !this.ctx.discovery().alive(node.id())) continue;
                try {
                    this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_METRICS, (Message)msg, (byte)2);
                }
                catch (ClusterTopologyCheckedException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to send metrics update, node failed: " + e);
                }
                catch (IgniteCheckedException e) {
                    U.warn(this.log, "Failed to send metrics update: " + e, e);
                }
            }
            return;
        }
        ClusterNodeMetrics metrics = new ClusterNodeMetrics(this.metricsProvider.metrics(), this.metricsProvider.cacheMetrics());
        try {
            byte[] metricsBytes = U.zip(U.marshal(this.ctx.config().getMarshaller(), (Object)metrics));
            ClusterMetricsUpdateMessage msg = new ClusterMetricsUpdateMessage(metricsBytes);
            this.ctx.io().sendToGridTopic(oldest, GridTopic.TOPIC_METRICS, (Message)msg, (byte)2);
            return;
        }
        catch (ClusterTopologyCheckedException e) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Failed to send metrics update to oldest, node failed: " + e);
            return;
        }
        catch (IgniteCheckedException e) {
            LT.warn(this.log, e, "Failed to send metrics update to oldest: " + e, false, false);
        }
    }

    public void disableUpdateNotifier() {
        this.notifyEnabled.set(false);
    }

    public boolean updateNotifierEnabled() {
        return this.notifyEnabled.get();
    }

    public String latestVersion() {
        return this.verChecker != null ? this.verChecker.latestVersion() : null;
    }

    public String clusterName() {
        try {
            this.ctx.cache().awaitStarted();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        return IgniteSystemProperties.getString("IGNITE_CLUSTER_NAME", this.ctx.cache().utilityCache().context().dynamicDeploymentId().toString());
    }

    public IgniteInternalFuture<String> requestDiagnosticInfo(final UUID nodeId, IgniteClosure<GridKernalContext, IgniteDiagnosticInfo> c, final String baseMsg) {
        final GridFutureAdapter<String> infoFut = new GridFutureAdapter<String>();
        IgniteInternalFuture<IgniteDiagnosticInfo> rmtFut = this.sendDiagnosticMessage(nodeId, c);
        rmtFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteDiagnosticInfo>>)new CI1<IgniteInternalFuture<IgniteDiagnosticInfo>>(){

            @Override
            public void apply(IgniteInternalFuture<IgniteDiagnosticInfo> fut) {
                String rmtMsg;
                try {
                    rmtMsg = fut.get().message();
                }
                catch (Exception e) {
                    rmtMsg = "Diagnostic processing error: " + e;
                }
                final String rmtMsg0 = rmtMsg;
                IgniteInternalFuture<String> locFut = IgniteDiagnosticMessage.dumpCommunicationInfo(ClusterProcessor.this.ctx, nodeId);
                locFut.listen((IgniteInClosure<IgniteInternalFuture<String>>)new CI1<IgniteInternalFuture<String>>(){

                    @Override
                    public void apply(IgniteInternalFuture<String> locFut) {
                        String locMsg;
                        try {
                            locMsg = locFut.get();
                        }
                        catch (Exception e) {
                            locMsg = "Failed to get info for local node: " + e;
                        }
                        String msg = baseMsg + U.nl() + "Remote node information:" + U.nl() + rmtMsg0 + U.nl() + "Local communication statistics:" + U.nl() + locMsg;
                        infoFut.onDone(msg);
                    }
                });
            }
        });
        return infoFut;
    }

    private IgniteInternalFuture<IgniteDiagnosticInfo> sendDiagnosticMessage(UUID nodeId, IgniteClosure<GridKernalContext, IgniteDiagnosticInfo> c) {
        try {
            IgniteDiagnosticMessage msg = IgniteDiagnosticMessage.createRequest(this.marsh, c, this.diagFutId.getAndIncrement());
            InternalDiagnosticFuture fut = new InternalDiagnosticFuture(nodeId, msg.futureId());
            this.diagnosticFuturesMap().put(msg.futureId(), fut);
            this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_INTERNAL_DIAGNOSTIC, (Message)msg, (byte)2);
            return fut;
        }
        catch (Exception e) {
            U.error(this.diagnosticLog, "Failed to send diagnostic message: " + e);
            return new GridFinishedFuture<IgniteDiagnosticInfo>(new IgniteDiagnosticInfo("Failed to send diagnostic message: " + e));
        }
    }

    private ConcurrentHashMap<Long, InternalDiagnosticFuture> diagnosticFuturesMap() {
        ConcurrentHashMap<Long, InternalDiagnosticFuture> map = this.diagnosticFutMap.get();
        if (map == null && !this.diagnosticFutMap.compareAndSet(null, map = new ConcurrentHashMap())) {
            map = this.diagnosticFutMap.get();
        }
        return map;
    }

    private class MetricsUpdateTimeoutObject
    implements GridTimeoutObject,
    Runnable {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private long endTime;
        private final long timeout;

        MetricsUpdateTimeoutObject(long timeout) {
            this.timeout = timeout;
            this.endTime = U.currentTimeMillis() + timeout;
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public void run() {
            ClusterProcessor.this.updateMetrics();
            this.endTime = U.currentTimeMillis() + this.timeout;
            ClusterProcessor.this.ctx.timeout().addTimeoutObject(this);
        }

        @Override
        public void onTimeout() {
            ClusterProcessor.this.ctx.pools().getSystemExecutorService().execute(this);
        }
    }

    class InternalDiagnosticFuture
    extends GridFutureAdapter<IgniteDiagnosticInfo> {
        private final long id;
        private final UUID nodeId;

        InternalDiagnosticFuture(UUID nodeId, long id) {
            this.nodeId = nodeId;
            this.id = id;
        }

        public void onResponse(IgniteDiagnosticInfo res) {
            this.onDone(res);
        }

        @Override
        public boolean onDone(@Nullable IgniteDiagnosticInfo res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                ClusterProcessor.this.diagnosticFuturesMap().remove(this.id);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(InternalDiagnosticFuture.class, this);
        }
    }

    private static class UpdateNotifierTimerTask
    extends GridTimerTask {
        private final IgniteLogger log;
        private final GridUpdateNotifier verChecker;
        private boolean first = true;
        private final AtomicBoolean notifyEnabled;

        private UpdateNotifierTimerTask(IgniteKernal kernal, GridUpdateNotifier verChecker, AtomicBoolean notifyEnabled) {
            this.log = kernal.context().log(UpdateNotifierTimerTask.class);
            this.verChecker = verChecker;
            this.notifyEnabled = notifyEnabled;
        }

        @Override
        public void safeRun() throws InterruptedException {
            if (!this.notifyEnabled.get()) {
                return;
            }
            this.verChecker.checkForNewVersion(this.log, this.first);
            Thread.sleep(10000L);
            for (int i = 0; i < 60 && this.verChecker.latestVersion() == null; ++i) {
                Thread.sleep(1000L);
            }
            this.verChecker.reportStatus(this.log);
            if (this.first && this.verChecker.error() == null) {
                this.first = false;
                this.verChecker.reportOnlyNew(true);
            }
        }
    }
}

