/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import org.apache.ignite.internal.management.snapshot.AbstractSnapshotCommand;
import org.apache.ignite.internal.management.snapshot.SnapshotRestoreCommandArg;
import org.apache.ignite.internal.management.snapshot.SnapshotRestoreTask;
import org.jetbrains.annotations.Nullable;

public class SnapshotRestoreCommand
extends AbstractSnapshotCommand<SnapshotRestoreCommandArg> {
    @Override
    public String description() {
        return "Restore snapshot";
    }

    @Override
    @Nullable
    public String deprecationMessage(SnapshotRestoreCommandArg arg) {
        if (arg.start()) {
            return "Command option '--start' is redundant and must be avoided.";
        }
        if (arg.cancel()) {
            return "Command deprecated. Use '--snapshot cancel' instead.";
        }
        if (arg.status()) {
            return "Command deprecated. Use '--snapshot status' instead.";
        }
        return null;
    }

    @Override
    public Class<SnapshotRestoreCommandArg> argClass() {
        return SnapshotRestoreCommandArg.class;
    }

    @Override
    public Class<SnapshotRestoreTask> taskClass() {
        return SnapshotRestoreTask.class;
    }

    @Override
    public String confirmationPrompt(SnapshotRestoreCommandArg arg) {
        return arg.status() || arg.cancel() || arg.groups() != null ? null : "Warning: command will restore ALL USER-CREATED CACHE GROUPS from the snapshot " + arg.snapshotName() + '.';
    }
}

