/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlToRelConvertor
extends SqlToRelConverter {
    private final Deque<SqlCall> datasetStack = new ArrayDeque<SqlCall>();
    private RelBuilder relBuilder;

    public IgniteSqlToRelConvertor(RelOptTable.ViewExpander viewExpander, @Nullable SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config cfg) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, cfg);
        this.relBuilder = this.config.getRelBuilderFactory().create(cluster, null);
    }

    protected RelRoot convertQueryRecursive(SqlNode qry, boolean top, @Nullable RelDataType targetRowType) {
        if (qry.getKind() == SqlKind.MERGE) {
            return RelRoot.of((RelNode)this.convertMerge((SqlMerge)qry), (SqlKind)qry.getKind());
        }
        return super.convertQueryRecursive(qry, top, targetRowType);
    }

    protected RelNode convertInsert(SqlInsert call) {
        this.datasetStack.push((SqlCall)call);
        RelNode rel = super.convertInsert(call);
        this.datasetStack.pop();
        return rel;
    }

    public RelNode convertValues(SqlCall values, RelDataType targetRowType) {
        DefaultChecker checker = new DefaultChecker();
        boolean hasDefaults = checker.hasDefaults(values);
        if (hasDefaults) {
            SqlValidatorScope scope = this.validator.getOverScope((SqlNode)values);
            assert (scope != null);
            SqlToRelConverter.Blackboard bb = this.createBlackboard(scope, null, false);
            this.convertValuesImplEx(bb, values, targetRowType);
            return bb.root();
        }
        return super.convertValues(values, targetRowType);
    }

    private void convertValuesImplEx(SqlToRelConverter.Blackboard bb, SqlCall values, RelDataType targetRowType) {
        SqlCall insertOp = this.datasetStack.peek();
        assert (insertOp instanceof SqlInsert);
        assert (values == ((SqlInsert)insertOp).getSource());
        RelOptTable targetTable = this.getTargetTable((SqlNode)insertOp);
        assert (targetTable != null);
        IgniteTable ignTable = (IgniteTable)targetTable.unwrap(IgniteTable.class);
        List tblFields = targetTable.getRowType().getFieldList();
        List targetFields = targetRowType.getFieldNames();
        int[] mapping = new int[targetFields.size()];
        int pos = 0;
        block0: for (String fld : targetFields) {
            int tblPos = 0;
            for (RelDataTypeField tblFld : tblFields) {
                if (tblFld.getName().equals(fld)) {
                    mapping[pos++] = tblPos;
                    continue block0;
                }
                ++tblPos;
            }
        }
        for (SqlNode rowConstructor : values.getOperandList()) {
            SqlCall rowConstructor0 = (SqlCall)rowConstructor;
            ArrayList<Pair> exps = new ArrayList<Pair>(targetFields.size());
            for (pos = 0; pos < targetFields.size(); ++pos) {
                SqlNode operand = (SqlNode)rowConstructor0.getOperandList().get(pos);
                if (operand.getKind() == SqlKind.DEFAULT) {
                    RexNode def = ignTable.descriptor().newColumnDefaultValue(targetTable, mapping[pos], (InitializerContext)bb);
                    exps.add(Pair.of((Object)def, (Object)SqlValidatorUtil.getAlias((SqlNode)operand, (int)pos)));
                    continue;
                }
                exps.add(Pair.of((Object)bb.convertExpression(operand), (Object)SqlValidatorUtil.getAlias((SqlNode)operand, (int)pos)));
            }
            RelNode in = null == bb.root ? LogicalValues.createOneRow((RelOptCluster)this.cluster) : bb.root;
            this.relBuilder.push(in).project((Iterable)Pair.left(exps), (Iterable)Pair.right(exps));
        }
        bb.setRoot(this.relBuilder.union(true, values.getOperandList().size()).build(), true);
    }

    private RelNode convertMerge(SqlMerge call) {
        RelOptTable targetTable = this.getTargetTable((SqlNode)call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            for (SqlNode targetColumn : updateCall.getTargetColumnList()) {
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                RelDataTypeField field = SqlValidatorUtil.getTargetField((RelDataType)targetRowType, (RelDataTypeFactory)this.typeFactory, (SqlIdentifier)id, (SqlValidatorCatalogReader)this.catalogReader, (RelOptTable)targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNameList.add(field.getName());
            }
        }
        RelNode mergeSourceRel = this.convertSelect(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call), false);
        SqlInsert insertCall = call.getInsertCall();
        int nLevel1Exprs = 0;
        List level1InsertExprs = null;
        List level2InsertExprs = null;
        if (insertCall != null) {
            RelNode insertRel = this.convertInsert(insertCall);
            level1InsertExprs = ((LogicalProject)insertRel.getInput(0)).getProjects();
            if (insertRel.getInput(0).getInput(0) instanceof LogicalProject) {
                level2InsertExprs = ((LogicalProject)insertRel.getInput(0).getInput(0)).getProjects();
            }
            nLevel1Exprs = level1InsertExprs.size();
        }
        LogicalJoin join = (LogicalJoin)mergeSourceRel.getInput(0);
        ArrayList projects = new ArrayList();
        for (int level1Idx = 0; level1Idx < nLevel1Exprs; ++level1Idx) {
            Objects.requireNonNull(level1InsertExprs, "level1InsertExprs");
            if (level2InsertExprs != null && level1InsertExprs.get(level1Idx) instanceof RexInputRef) {
                int level2Idx = ((RexInputRef)level1InsertExprs.get(level1Idx)).getIndex();
                projects.add(level2InsertExprs.get(level2Idx));
                continue;
            }
            projects.add(level1InsertExprs.get(level1Idx));
        }
        if (updateCall != null) {
            LogicalProject project = (LogicalProject)mergeSourceRel;
            projects.addAll(project.getProjects());
        } else {
            join = join.copy(join.getTraitSet(), join.getCondition(), join.getLeft(), join.getRight(), JoinRelType.ANTI, false);
        }
        RelBuilder relBuilder = this.config.getRelBuilderFactory().create(this.cluster, null).transform(this.config.getRelBuilderConfigTransform());
        relBuilder.push((RelNode)join).project(projects);
        return LogicalTableModify.create((RelOptTable)targetTable, (Prepare.CatalogReader)this.catalogReader, (RelNode)relBuilder.build(), (TableModify.Operation)TableModify.Operation.MERGE, targetColumnNameList, null, (boolean)false);
    }

    private static class DefaultChecker
    extends SqlShuttle {
        private DefaultChecker() {
        }

        private boolean hasDefaults(SqlCall call) {
            try {
                call.accept((SqlVisitor)this);
                return false;
            }
            catch (ControlFlowException e) {
                return true;
            }
        }

        public @Nullable SqlNode visit(SqlCall call) {
            if (call.getKind() == SqlKind.DEFAULT) {
                throw new ControlFlowException();
            }
            return super.visit(call);
        }
    }
}

