/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.hint;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.hint.HintPredicate;
import org.apache.calcite.rel.hint.HintPredicates;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.ignite.internal.processors.query.calcite.hint.HintOptionsChecker;
import org.apache.ignite.internal.processors.query.calcite.hint.HintsConfig;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;

public enum HintDefinition {
    QUERY_ENGINE,
    DISABLE_RULE,
    EXPAND_DISTINCT_AGG{

        @Override
        public HintPredicate predicate() {
            return HintPredicates.AGGREGATE;
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_EMPTY;
        }
    }
    ,
    ENFORCE_JOIN_ORDER{

        @Override
        public HintPredicate predicate() {
            return HintPredicates.JOIN;
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_EMPTY;
        }

        @Override
        public Collection<RelOptRule> disabledRules() {
            return Arrays.asList(CoreRules.JOIN_COMMUTE, JoinPushThroughJoinRule.LEFT, JoinPushThroughJoinRule.RIGHT);
        }
    }
    ,
    NO_INDEX{

        @Override
        public HintPredicate predicate() {
            return (hint, rel) -> rel instanceof IgniteLogicalTableScan;
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return HintsConfig.OPTS_CHECK_NO_KV;
        }
    }
    ,
    FORCE_INDEX{

        @Override
        public HintPredicate predicate() {
            return NO_INDEX.predicate();
        }

        @Override
        public HintOptionsChecker optionsChecker() {
            return NO_INDEX.optionsChecker();
        }
    };


    HintPredicate predicate() {
        return HintPredicates.SET_VAR;
    }

    HintOptionsChecker optionsChecker() {
        return HintsConfig.OPTS_CHECK_PLAIN;
    }

    public Collection<RelOptRule> disabledRules() {
        return Collections.emptyList();
    }
}

