/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp.agg;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.IterableAccumulator;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.type.UuidType;
import org.apache.ignite.internal.util.typedef.F;

public class Accumulators {
    public static <Row> Supplier<Accumulator<Row>> accumulatorFactory(AggregateCall call, ExecutionContext<Row> ctx) {
        Supplier supplier = Accumulators.accumulatorFunctionFactory(call, ctx);
        if (call.isDistinct()) {
            return () -> new DistinctAccumulator(call, ctx.rowHandler(), supplier);
        }
        return supplier;
    }

    private static <Row> Supplier<Accumulator<Row>> accumulatorFunctionFactory(AggregateCall call, ExecutionContext<Row> ctx) {
        RowHandler hnd = ctx.rowHandler();
        switch (call.getAggregation().getName()) {
            case "COUNT": {
                return () -> new LongCount(call, hnd);
            }
            case "AVG": {
                return Accumulators.avgFactory(call, hnd);
            }
            case "SUM": {
                return Accumulators.sumFactory(call, hnd);
            }
            case "$SUM0": {
                return Accumulators.sumEmptyIsZeroFactory(call, hnd);
            }
            case "MIN": 
            case "EVERY": {
                return Accumulators.minFactory(call, hnd);
            }
            case "MAX": 
            case "SOME": {
                return Accumulators.maxFactory(call, hnd);
            }
            case "SINGLE_VALUE": {
                return () -> new SingleVal(call, hnd);
            }
            case "ANY_VALUE": {
                return () -> new AnyVal(call, hnd);
            }
            case "LISTAGG": 
            case "ARRAY_AGG": 
            case "ARRAY_CONCAT_AGG": {
                return Accumulators.listAggregateSupplier(call, ctx);
            }
        }
        throw new AssertionError((Object)call.getAggregation().getName());
    }

    private static <Row> Supplier<Accumulator<Row>> listAggregateSupplier(AggregateCall call, ExecutionContext<Row> ctx) {
        Supplier accSup;
        RowHandler hnd = ctx.rowHandler();
        String aggName = call.getAggregation().getName();
        if ("LISTAGG".equals(aggName)) {
            accSup = () -> new ListAggAccumulator(call, hnd);
        } else if ("ARRAY_CONCAT_AGG".equals(aggName)) {
            accSup = () -> new ArrayConcatAggregateAccumulator(call, hnd);
        } else if ("ARRAY_AGG".equals(aggName)) {
            accSup = () -> new ArrayAggregateAccumulator(call, hnd);
        } else {
            throw new AssertionError((Object)call.getAggregation().getName());
        }
        if (call.getCollation() != null && !call.getCollation().getFieldCollations().isEmpty()) {
            Comparator cmp = ctx.expressionFactory().comparator(call.getCollation());
            return () -> new SortingAccumulator(accSup, cmp);
        }
        return accSup;
    }

    private static <Row> Supplier<Accumulator<Row>> avgFactory(AggregateCall call, RowHandler<Row> hnd) {
        switch (call.type.getSqlTypeName()) {
            case ANY: {
                throw new UnsupportedOperationException("AVG() is not supported for type '" + call.type + "'.");
            }
            case BIGINT: 
            case DECIMAL: {
                return () -> new DecimalAvg(call, hnd);
            }
        }
        return () -> new DoubleAvg(call, hnd);
    }

    private static <Row> Supplier<Accumulator<Row>> sumFactory(AggregateCall call, RowHandler<Row> hnd) {
        switch (call.type.getSqlTypeName()) {
            case ANY: {
                throw new UnsupportedOperationException("SUM() is not supported for type '" + call.type + "'.");
            }
            case BIGINT: 
            case DECIMAL: {
                return () -> new Sum(call, new DecimalSumEmptyIsZero(call, hnd), hnd);
            }
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return () -> new Sum(call, new DoubleSumEmptyIsZero(call, hnd), hnd);
            }
        }
        return () -> new Sum(call, new LongSumEmptyIsZero(call, hnd), hnd);
    }

    private static <Row> Supplier<Accumulator<Row>> sumEmptyIsZeroFactory(AggregateCall call, RowHandler<Row> hnd) {
        switch (call.type.getSqlTypeName()) {
            case ANY: {
                throw new UnsupportedOperationException("SUM() is not supported for type '" + call.type + "'.");
            }
            case BIGINT: 
            case DECIMAL: {
                return () -> new DecimalSumEmptyIsZero(call, hnd);
            }
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return () -> new DoubleSumEmptyIsZero(call, hnd);
            }
        }
        return () -> new LongSumEmptyIsZero(call, hnd);
    }

    private static <Row> Supplier<Accumulator<Row>> minFactory(AggregateCall call, RowHandler<Row> hnd) {
        switch (call.type.getSqlTypeName()) {
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return () -> new DoubleMinMax(call, hnd, true);
            }
            case DECIMAL: {
                return () -> new DecimalMinMax(call, hnd, true);
            }
            case INTEGER: {
                return () -> new IntMinMax(call, hnd, true);
            }
            case CHAR: 
            case VARCHAR: {
                return () -> new VarCharMinMax(call, hnd, true);
            }
            case BINARY: 
            case VARBINARY: {
                return () -> new ComparableMinMax(call, hnd, true, tf -> tf.createTypeWithNullability(tf.createSqlType(SqlTypeName.VARBINARY), true));
            }
            case ANY: {
                if (call.type instanceof UuidType) {
                    return () -> new ComparableMinMax(call, hnd, true, tf -> tf.createTypeWithNullability(tf.createCustomType((Type)((Object)UUID.class)), true));
                }
                throw new UnsupportedOperationException("MIN() is not supported for type '" + call.type + "'.");
            }
        }
        return () -> new LongMinMax(call, hnd, true);
    }

    private static <Row> Supplier<Accumulator<Row>> maxFactory(AggregateCall call, RowHandler<Row> hnd) {
        switch (call.type.getSqlTypeName()) {
            case DOUBLE: 
            case REAL: 
            case FLOAT: {
                return () -> new DoubleMinMax(call, hnd, false);
            }
            case DECIMAL: {
                return () -> new DecimalMinMax(call, hnd, false);
            }
            case INTEGER: {
                return () -> new IntMinMax(call, hnd, false);
            }
            case CHAR: 
            case VARCHAR: {
                return () -> new VarCharMinMax(call, hnd, false);
            }
            case BINARY: 
            case VARBINARY: {
                return () -> new ComparableMinMax(call, hnd, false, tf -> tf.createTypeWithNullability(tf.createSqlType(SqlTypeName.VARBINARY), true));
            }
            case ANY: {
                if (call.type instanceof UuidType) {
                    return () -> new ComparableMinMax(call, hnd, false, tf -> tf.createTypeWithNullability(tf.createCustomType((Type)((Object)UUID.class)), true));
                }
                throw new UnsupportedOperationException("MAX() is not supported for type '" + call.type + "'.");
            }
        }
        return () -> new LongMinMax(call, hnd, false);
    }

    private static class DistinctAccumulator<Row>
    extends AbstractAccumulator<Row> {
        private final Accumulator<Row> acc;
        private final Map<Object, Row> rows = new HashMap<Object, Row>();

        private DistinctAccumulator(AggregateCall aggCall, RowHandler<Row> hnd, Supplier<Accumulator<Row>> accSup) {
            super(aggCall, hnd);
            this.acc = accSup.get();
        }

        @Override
        public void add(Row row) {
            if (row == null || this.columnCount(row) == 0 || this.get(0, row) == null) {
                return;
            }
            Object key = this.get(0, row);
            if (key == null) {
                return;
            }
            this.rows.put(key, row);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DistinctAccumulator other0 = (DistinctAccumulator)other;
            this.rows.putAll(other0.rows);
        }

        @Override
        public Object end() {
            for (Row row : this.rows.values()) {
                this.acc.add(row);
            }
            return this.acc.end();
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return this.acc.argumentTypes(typeFactory);
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return this.acc.returnType(typeFactory);
        }
    }

    private static class ArrayConcatAggregateAccumulator<Row>
    extends AggAccumulator<Row> {
        public ArrayConcatAggregateAccumulator(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public Object end() {
            if (this.size() == 0) {
                return null;
            }
            ArrayList result = new ArrayList(this.size());
            for (Object row : this) {
                List arr = (List)this.get(0, row);
                if (F.isEmpty((Collection)arr)) continue;
                result.addAll(arr);
            }
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.ANY), -1L), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.ANY), -1L), true);
        }
    }

    private static class ArrayAggregateAccumulator<Row>
    extends AggAccumulator<Row> {
        public ArrayAggregateAccumulator(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public Object end() {
            if (this.size() == 0) {
                return null;
            }
            ArrayList result = new ArrayList(this.size());
            for (Object row : this) {
                result.add(this.get(0, row));
            }
            return result;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.ANY), -1L), true);
        }
    }

    private static class ListAggAccumulator<Row>
    extends AggAccumulator<Row> {
        private static final String DEFAULT_SEPARATOR = ",";
        private final boolean isDfltSep;

        public ListAggAccumulator(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
            this.isDfltSep = aggCall.getArgList().size() <= 1;
        }

        @Override
        public Object end() {
            if (this.isEmpty()) {
                return null;
            }
            StringBuilder builder = null;
            for (Object row : this) {
                Object val = this.get(0, row);
                if (val == null) continue;
                if (builder == null) {
                    builder = new StringBuilder();
                }
                if (builder.length() != 0) {
                    builder.append(this.extractSeparator(row));
                }
                builder.append(val);
            }
            return builder != null ? builder.toString() : null;
        }

        private String extractSeparator(Row row) {
            if (this.isDfltSep || this.columnCount(row) <= 1) {
                return DEFAULT_SEPARATOR;
            }
            Object rawSep = this.get(1, row);
            if (rawSep == null) {
                return DEFAULT_SEPARATOR;
            }
            return rawSep.toString();
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object[])new RelDataType[]{typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true), typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.CHAR), true)});
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
        }
    }

    private static abstract class AggAccumulator<Row>
    extends AbstractAccumulator<Row>
    implements IterableAccumulator<Row> {
        private final List<Row> buf = new ArrayList<Row>();

        protected AggAccumulator(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            if (row == null) {
                return;
            }
            this.buf.add(row);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            AggAccumulator other0 = (AggAccumulator)other;
            this.buf.addAll(other0.buf);
        }

        @Override
        public Iterator<Row> iterator() {
            return this.buf.iterator();
        }

        public boolean isEmpty() {
            return this.buf.isEmpty();
        }

        public int size() {
            return this.buf.size();
        }
    }

    private static class SortingAccumulator<Row>
    implements IterableAccumulator<Row> {
        private final transient Comparator<Row> cmp;
        private final List<Row> list;
        private final Accumulator<Row> acc;

        private SortingAccumulator(Supplier<Accumulator<Row>> accSup, Comparator<Row> cmp) {
            this.cmp = cmp;
            this.list = new ArrayList<Row>();
            this.acc = accSup.get();
        }

        @Override
        public void add(Row row) {
            this.list.add(row);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            SortingAccumulator other1 = (SortingAccumulator)other;
            this.list.addAll(other1.list);
        }

        @Override
        public Object end() {
            this.list.sort(this.cmp);
            for (Row row : this.list) {
                this.acc.add(row);
            }
            return this.acc.end();
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return this.acc.argumentTypes(typeFactory);
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return this.acc.returnType(typeFactory);
        }

        @Override
        public Iterator<Row> iterator() {
            return this.list.iterator();
        }
    }

    private static class ComparableMinMax<Row, T extends Comparable<T>>
    extends AbstractAccumulator<Row> {
        private final boolean min;
        private final transient Function<IgniteTypeFactory, RelDataType> typeSupplier;
        private T val;
        private boolean empty = true;

        private ComparableMinMax(AggregateCall aggCall, RowHandler<Row> hnd, boolean min, Function<IgniteTypeFactory, RelDataType> typeSupplier) {
            super(aggCall, hnd);
            this.min = min;
            this.typeSupplier = typeSupplier;
        }

        @Override
        public void add(Row row) {
            Comparable in = (Comparable)this.get(0, row);
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? (this.val.compareTo((Comparable)in) < 0 ? this.val : in) : (this.val.compareTo((Comparable)in) < 0 ? in : this.val));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator<Row> other) {
            ComparableMinMax other0 = (ComparableMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? (this.val.compareTo(other0.val) < 0 ? this.val : other0.val) : (this.val.compareTo(other0.val) < 0 ? other0.val : this.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : this.val;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)this.typeSupplier.apply(typeFactory));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return this.typeSupplier.apply(typeFactory);
        }
    }

    private static class DecimalMinMax<Row>
    extends AbstractAccumulator<Row> {
        private final boolean min;
        private BigDecimal val;

        private DecimalMinMax(AggregateCall aggCall, RowHandler<Row> hnd, boolean min) {
            super(aggCall, hnd);
            this.min = min;
        }

        @Override
        public void add(Row row) {
            BigDecimal in = (BigDecimal)this.get(0, row);
            if (in == null) {
                return;
            }
            this.val = this.val == null ? in : (this.min ? this.val.min(in) : this.val.max(in));
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DecimalMinMax other0 = (DecimalMinMax)other;
            if (other0.val == null) {
                return;
            }
            this.val = this.val == null ? other0.val : (this.min ? this.val.min(other0.val) : this.val.max(other0.val));
        }

        @Override
        public Object end() {
            return this.val;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true);
        }
    }

    private static class LongMinMax<Row>
    extends AbstractAccumulator<Row> {
        private final boolean min;
        private long val;
        private boolean empty = true;

        private LongMinMax(AggregateCall aggCall, RowHandler<Row> hnd, boolean min) {
            super(aggCall, hnd);
            this.min = min;
        }

        @Override
        public void add(Row row) {
            Long in = (Long)this.get(0, row);
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? Math.min(this.val, in) : Math.max(this.val, in));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator<Row> other) {
            LongMinMax other0 = (LongMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? Math.min(this.val, other0.val) : Math.max(this.val, other0.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : Long.valueOf(this.val);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true);
        }
    }

    private static class IntMinMax<Row>
    extends AbstractAccumulator<Row> {
        private final boolean min;
        private int val;
        private boolean empty = true;

        private IntMinMax(AggregateCall aggCall, RowHandler<Row> hnd, boolean min) {
            super(aggCall, hnd);
            this.min = min;
        }

        @Override
        public void add(Row row) {
            Integer in = (Integer)this.get(0, row);
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? Math.min(this.val, in) : Math.max(this.val, in));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator<Row> other) {
            IntMinMax other0 = (IntMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? Math.min(this.val, other0.val) : Math.max(this.val, other0.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : Integer.valueOf(this.val);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        }
    }

    private static class VarCharMinMax<Row>
    extends AbstractAccumulator<Row> {
        private final boolean min;
        private CharSequence val;
        private boolean empty = true;

        VarCharMinMax(AggregateCall aggCall, RowHandler<Row> hnd, boolean min) {
            super(aggCall, hnd);
            this.min = min;
        }

        @Override
        public void add(Row row) {
            CharSequence in = (CharSequence)this.get(0, row);
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? (CharSeqComparator.INSTANCE.compare(this.val, in) < 0 ? this.val : in) : (CharSeqComparator.INSTANCE.compare(this.val, in) < 0 ? in : this.val));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator<Row> other) {
            VarCharMinMax other0 = (VarCharMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? (CharSeqComparator.INSTANCE.compare(this.val, other0.val) < 0 ? this.val : other0.val) : (CharSeqComparator.INSTANCE.compare(this.val, other0.val) < 0 ? other0.val : this.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : this.val;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
        }

        private static class CharSeqComparator
        implements Comparator<CharSequence> {
            private static final CharSeqComparator INSTANCE = new CharSeqComparator();

            private CharSeqComparator() {
            }

            @Override
            public int compare(CharSequence s1, CharSequence s2) {
                int len = Math.min(s1.length(), s2.length());
                for (int i = 0; i < len; ++i) {
                    int cmp = Character.compare(s1.charAt(i), s2.charAt(i));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return Integer.compare(s1.length(), s2.length());
            }
        }
    }

    private static class DoubleMinMax<Row>
    extends AbstractAccumulator<Row> {
        private final boolean min;
        private double val;
        private boolean empty = true;

        private DoubleMinMax(AggregateCall aggCall, RowHandler<Row> hnd, boolean min) {
            super(aggCall, hnd);
            this.min = min;
        }

        @Override
        public void add(Row row) {
            Double in = (Double)this.get(0, row);
            if (in == null) {
                return;
            }
            this.val = this.empty ? in : (this.min ? Math.min(this.val, in) : Math.max(this.val, in));
            this.empty = false;
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DoubleMinMax other0 = (DoubleMinMax)other;
            if (other0.empty) {
                return;
            }
            this.val = this.empty ? other0.val : (this.min ? Math.min(this.val, other0.val) : Math.max(this.val, other0.val));
            this.empty = false;
        }

        @Override
        public Object end() {
            return this.empty ? null : Double.valueOf(this.val);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }
    }

    private static class DecimalSumEmptyIsZero<Row>
    extends AbstractAccumulator<Row> {
        private BigDecimal sum;

        DecimalSumEmptyIsZero(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            BigDecimal in = (BigDecimal)this.get(0, row);
            if (in == null) {
                return;
            }
            this.sum = this.sum == null ? in : this.sum.add(in);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DecimalSumEmptyIsZero other0 = (DecimalSumEmptyIsZero)other;
            this.sum = this.sum == null ? other0.sum : this.sum.add(other0.sum);
        }

        @Override
        public Object end() {
            return this.sum != null ? this.sum : BigDecimal.ZERO;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true);
        }
    }

    private static class LongSumEmptyIsZero<Row>
    extends AbstractAccumulator<Row> {
        private long sum;

        LongSumEmptyIsZero(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            Long in = (Long)this.get(0, row);
            if (in == null) {
                return;
            }
            this.sum += in.longValue();
        }

        @Override
        public void apply(Accumulator<Row> other) {
            LongSumEmptyIsZero other0 = (LongSumEmptyIsZero)other;
            this.sum += other0.sum;
        }

        @Override
        public Object end() {
            return this.sum;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), true);
        }
    }

    private static class DoubleSumEmptyIsZero<Row>
    extends AbstractAccumulator<Row> {
        private double sum;

        DoubleSumEmptyIsZero(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            Double in = (Double)this.get(0, row);
            if (in == null) {
                return;
            }
            this.sum += in.doubleValue();
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DoubleSumEmptyIsZero other0 = (DoubleSumEmptyIsZero)other;
            this.sum += other0.sum;
        }

        @Override
        public Object end() {
            return this.sum;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }
    }

    private static class Sum<Row>
    extends AbstractAccumulator<Row> {
        private final Accumulator<Row> acc;
        private boolean empty = true;

        public Sum(AggregateCall aggCall, Accumulator<Row> acc, RowHandler<Row> hnd) {
            super(aggCall, hnd);
            this.acc = acc;
        }

        @Override
        public void add(Row row) {
            Object val = this.get(0, row);
            if (val == null) {
                return;
            }
            this.empty = false;
            this.acc.add(row);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            Sum other0 = (Sum)other;
            if (other0.empty) {
                return;
            }
            this.empty = false;
            this.acc.apply(other0.acc);
        }

        @Override
        public Object end() {
            return this.empty ? null : this.acc.end();
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return this.acc.argumentTypes(typeFactory);
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return this.acc.returnType(typeFactory);
        }
    }

    private static class LongCount<Row>
    extends AbstractAccumulator<Row> {
        private long cnt;

        LongCount(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            int argsCount = this.aggregateCall().getArgList().size();
            assert (argsCount == 0 || argsCount == 1);
            if (argsCount == 0 || this.get(0, row) != null) {
                ++this.cnt;
            }
        }

        @Override
        public void apply(Accumulator<Row> other) {
            LongCount other0 = (LongCount)other;
            this.cnt += other0.cnt;
        }

        @Override
        public Object end() {
            return this.cnt;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), false));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    private static class DoubleAvg<Row>
    extends AbstractAccumulator<Row> {
        private double sum;
        private long cnt;

        DoubleAvg(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            Double in = (Double)this.get(0, row);
            if (in == null) {
                return;
            }
            this.sum += in.doubleValue();
            ++this.cnt;
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DoubleAvg other0 = (DoubleAvg)other;
            this.sum += other0.sum;
            this.cnt += other0.cnt;
        }

        @Override
        public Object end() {
            return this.cnt > 0L ? Double.valueOf(this.sum / (double)this.cnt) : null;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }
    }

    private static class DecimalAvg<Row>
    extends AbstractAccumulator<Row> {
        private BigDecimal sum = BigDecimal.ZERO;
        private BigDecimal cnt = BigDecimal.ZERO;

        DecimalAvg(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            BigDecimal in = (BigDecimal)this.get(0, row);
            if (in == null) {
                return;
            }
            this.sum = this.sum.add(in);
            this.cnt = this.cnt.add(BigDecimal.ONE);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            DecimalAvg other0 = (DecimalAvg)other;
            this.sum = this.sum.add(other0.sum);
            this.cnt = this.cnt.add(other0.cnt);
        }

        @Override
        public Object end() {
            return this.cnt.compareTo(BigDecimal.ZERO) == 0 ? null : this.sum.divide(this.cnt, MathContext.DECIMAL64);
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), true);
        }
    }

    private static class AnyVal<Row>
    extends AbstractAccumulator<Row> {
        private Object holder;

        AnyVal(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            if (this.holder == null) {
                this.holder = this.get(0, row);
            }
        }

        @Override
        public void apply(Accumulator<Row> other) {
            if (this.holder == null) {
                this.holder = ((AnyVal)other).holder;
            }
        }

        @Override
        public Object end() {
            return this.holder;
        }

        @Override
        public List<RelDataType> argumentTypes(IgniteTypeFactory typeFactory) {
            return F.asList((Object)typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
        }

        @Override
        public RelDataType returnType(IgniteTypeFactory typeFactory) {
            return typeFactory.createSqlType(SqlTypeName.ANY);
        }
    }

    private static class SingleVal<Row>
    extends AnyVal<Row> {
        private boolean touched;

        SingleVal(AggregateCall aggCall, RowHandler<Row> hnd) {
            super(aggCall, hnd);
        }

        @Override
        public void add(Row row) {
            if (this.touched) {
                throw new IllegalArgumentException("Subquery returned more than 1 value.");
            }
            this.touched = true;
            super.add(row);
        }

        @Override
        public void apply(Accumulator<Row> other) {
            if (((SingleVal)other).touched) {
                if (this.touched) {
                    throw new IllegalArgumentException("Subquery returned more than 1 value.");
                }
                this.touched = true;
            }
            super.apply(other);
        }
    }

    private static abstract class AbstractAccumulator<Row>
    implements Accumulator<Row> {
        private final RowHandler<Row> hnd;
        private final transient AggregateCall aggCall;

        AbstractAccumulator(AggregateCall aggCall, RowHandler<Row> hnd) {
            this.aggCall = aggCall;
            this.hnd = hnd;
        }

        <T> T get(int idx, Row row) {
            List argList = this.aggCall.getArgList();
            assert (idx < argList.size()) : "idx=" + idx + "; arglist=" + argList;
            return (T)this.hnd.get((Integer)argList.get(idx), row);
        }

        protected AggregateCall aggregateCall() {
            return this.aggCall;
        }

        int columnCount(Row row) {
            return this.hnd.columnCount(row);
        }
    }
}

