/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutor;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;

public class QueryTaskExecutorImpl
extends AbstractService
implements QueryTaskExecutor,
Thread.UncaughtExceptionHandler {
    public static final String THREAD_POOL_NAME = "CalciteQueryExecutor";
    private IgniteStripedThreadPoolExecutor stripedThreadPoolExecutor;
    private Thread.UncaughtExceptionHandler eHnd;

    public QueryTaskExecutorImpl(GridKernalContext ctx) {
        super(ctx);
    }

    public void stripedThreadPoolExecutor(IgniteStripedThreadPoolExecutor stripedThreadPoolExecutor) {
        this.stripedThreadPoolExecutor = stripedThreadPoolExecutor;
    }

    public void exceptionHandler(Thread.UncaughtExceptionHandler eHnd) {
        this.eHnd = eHnd;
    }

    @Override
    public void execute(UUID qryId, long fragmentId, Runnable qryTask) {
        this.stripedThreadPoolExecutor.execute(() -> {
            try {
                qryTask.run();
            }
            catch (Throwable e) {
                U.warn((IgniteLogger)this.log, (Object)"Uncaught exception", (Throwable)e);
                this.uncaughtException(Thread.currentThread(), e);
            }
        }, QueryTaskExecutorImpl.hash(qryId, fragmentId));
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        this.exceptionHandler(ctx.uncaughtExceptionHandler());
        IgniteStripedThreadPoolExecutor executor = new IgniteStripedThreadPoolExecutor(ctx.config().getQueryThreadPoolSize(), ctx.igniteInstanceName(), "calciteQry", (Thread.UncaughtExceptionHandler)this, false, 0L);
        this.stripedThreadPoolExecutor(executor);
        executor.registerMetrics(ctx.metric().registry(MetricUtils.metricName((String[])new String[]{"threadPools", THREAD_POOL_NAME})));
    }

    @Override
    public void tearDown() {
        U.shutdownNow(this.getClass(), (ExecutorService)this.stripedThreadPoolExecutor, (IgniteLogger)this.log);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.eHnd != null) {
            this.eHnd.uncaughtException(t, e);
        }
    }

    private static int hash(UUID qryId, long fragmentId) {
        return U.safeAbs((int)(31 * (31 + (qryId != null ? qryId.hashCode() : 0)) + Long.hashCode(fragmentId)));
    }
}

