/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public abstract class AbstractIndexScan<Row, IdxRow>
implements Iterable<Row>,
AutoCloseable {
    private final TreeIndex<IdxRow> idx;
    private final RangeIterable<Row> ranges;
    protected final ExecutionContext<Row> ectx;
    protected final RelDataType rowType;

    protected AbstractIndexScan(ExecutionContext<Row> ectx, RelDataType rowType, TreeIndex<IdxRow> idx, RangeIterable<Row> ranges) {
        this.ectx = ectx;
        this.rowType = rowType;
        this.idx = idx;
        this.ranges = ranges;
    }

    @Override
    public synchronized Iterator<Row> iterator() {
        if (this.ranges == null) {
            return new IteratorImpl(this.idx.find(null, null, true, true, this.indexQueryContext()));
        }
        IgniteClosure & Serializable clo = (IgniteClosure & Serializable)range -> {
            Object lower = range.lower() == null ? null : (Object)this.row2indexRow(range.lower());
            Object upper = range.upper() == null ? null : (Object)this.row2indexRow(range.upper());
            return new IteratorImpl(this.idx.find(lower, upper, range.lowerInclude(), range.upperInclude(), this.indexQueryContext()));
        };
        if (!this.ranges.multiBounds()) {
            Iterator it = this.ranges.iterator();
            if (it.hasNext()) {
                return (Iterator)clo.apply(it.next());
            }
            return Collections.emptyIterator();
        }
        return F.flat((Iterable)F.iterator(this.ranges, (IgniteClosure)clo, (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]));
    }

    protected abstract IdxRow row2indexRow(Row var1);

    protected abstract Row indexRow2Row(IdxRow var1) throws IgniteCheckedException;

    protected abstract IndexQueryContext indexQueryContext();

    @Override
    public void close() {
    }

    private class IteratorImpl
    extends GridIteratorAdapter<Row> {
        private final GridCursor<IdxRow> cursor;
        private Row next;

        private IteratorImpl(GridCursor<IdxRow> cursor) {
            this.cursor = cursor;
        }

        public boolean hasNextX() throws IgniteCheckedException {
            this.advance();
            return this.next != null;
        }

        public Row nextX() throws IgniteCheckedException {
            this.advance();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object res = this.next;
            this.next = null;
            return res;
        }

        public void removeX() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        private void advance() throws IgniteCheckedException {
            assert (this.cursor != null);
            if (this.next != null) {
                return;
            }
            while (this.next == null && this.cursor.next()) {
                Object idxRow = this.cursor.get();
                this.next = AbstractIndexScan.this.indexRow2Row(idxRow);
            }
        }
    }
}

