/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.A;

public class DistributedSqlConfiguration {
    private static final String PROPERTY_UPDATE_MESSAGE = "SQL parameter '%s' was changed from '%s' to '%s'";
    public static final HashSet<String> DFLT_DISABLED_FUNCS = (HashSet)Arrays.stream(new String[]{"FILE_READ", "FILE_WRITE", "CSVWRITE", "CSVREAD", "MEMORY_FREE", "MEMORY_USED", "LOCK_MODE", "LINK_SCHEMA", "SESSION_ID", "CANCEL_SESSION"}).collect(Collectors.toSet());
    public static final int DFLT_QRY_TIMEOUT = 0;
    private final SimpleDistributedProperty<HashSet<String>> disabledSqlFuncs = new SimpleDistributedProperty("sql.disabledFunctions", SimpleDistributedProperty::parseStringSet);
    private final SimpleDistributedProperty<Integer> dfltQueryTimeout = new SimpleDistributedProperty("sql.defaultQueryTimeout", SimpleDistributedProperty::parseNonNegativeInteger);
    private final DistributedBooleanProperty disableCreateLuceneIndexForStringValueType = DistributedBooleanProperty.detachedBooleanProperty((String)"sql.disableCreateLuceneIndexForStringValueType");

    public DistributedSqlConfiguration(final GridKernalContext ctx, final IgniteLogger log) {
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedSqlConfiguration.this.disabledSqlFuncs.addListener(DistributedConfigurationUtils.makeUpdateListener((String)DistributedSqlConfiguration.PROPERTY_UPDATE_MESSAGE, (IgniteLogger)log));
                DistributedSqlConfiguration.this.dfltQueryTimeout.addListener(DistributedConfigurationUtils.makeUpdateListener((String)DistributedSqlConfiguration.PROPERTY_UPDATE_MESSAGE, (IgniteLogger)log));
                dispatcher.registerProperties((DistributedChangeableProperty[])new SimpleDistributedProperty[]{DistributedSqlConfiguration.this.disabledSqlFuncs});
                dispatcher.registerProperties((DistributedChangeableProperty[])new SimpleDistributedProperty[]{DistributedSqlConfiguration.this.dfltQueryTimeout});
                dispatcher.registerProperties((DistributedChangeableProperty[])new DistributedBooleanProperty[]{DistributedSqlConfiguration.this.disableCreateLuceneIndexForStringValueType});
            }

            public void onReadyToWrite() {
                if (ReadableDistributedMetaStorage.isSupported((GridKernalContext)ctx)) {
                    DistributedConfigurationUtils.setDefaultValue((DistributedProperty)DistributedSqlConfiguration.this.disabledSqlFuncs, DFLT_DISABLED_FUNCS, (IgniteLogger)log);
                    DistributedConfigurationUtils.setDefaultValue((DistributedProperty)DistributedSqlConfiguration.this.dfltQueryTimeout, (Serializable)Integer.valueOf((int)ctx.config().getSqlConfiguration().getDefaultQueryTimeout()), (IgniteLogger)log);
                    DistributedConfigurationUtils.setDefaultValue((DistributedProperty)DistributedSqlConfiguration.this.disableCreateLuceneIndexForStringValueType, (Serializable)Boolean.valueOf(false), (IgniteLogger)log);
                } else {
                    log.warning("Distributed metastorage is not supported. All distributed SQL configuration parameters are unavailable.");
                    DistributedSqlConfiguration.this.disabledSqlFuncs.localUpdate(null);
                    DistributedSqlConfiguration.this.dfltQueryTimeout.localUpdate((Serializable)Integer.valueOf((int)ctx.config().getSqlConfiguration().getDefaultQueryTimeout()));
                    DistributedSqlConfiguration.this.disableCreateLuceneIndexForStringValueType.localUpdate((Serializable)Boolean.valueOf(false));
                }
            }
        });
    }

    public Set<String> disabledFunctions() {
        HashSet<String> ret = (HashSet<String>)this.disabledSqlFuncs.get();
        return ret != null ? ret : DFLT_DISABLED_FUNCS;
    }

    public GridFutureAdapter<?> disabledFunctions(HashSet<String> disabledFuncs) throws IgniteCheckedException {
        return this.disabledSqlFuncs.propagateAsync(disabledFuncs);
    }

    public void listenDisabledFunctions(DistributePropertyListener<HashSet<String>> lsnr) {
        this.disabledSqlFuncs.addListener(lsnr);
    }

    public int defaultQueryTimeout() {
        Integer t = (Integer)this.dfltQueryTimeout.get();
        return t != null ? t : 0;
    }

    public GridFutureAdapter<?> defaultQueryTimeout(int timeout) throws IgniteCheckedException {
        A.ensure((timeout >= 0 ? 1 : 0) != 0, (String)"default query timeout value must not be negative.");
        return this.dfltQueryTimeout.propagateAsync((Serializable)Integer.valueOf(timeout));
    }

    public void listenDefaultQueryTimeout(DistributePropertyListener<Integer> lsnr) {
        this.dfltQueryTimeout.addListener(lsnr);
    }

    public boolean isDisableCreateLuceneIndexForStringValueType() {
        Boolean ret = (Boolean)this.disableCreateLuceneIndexForStringValueType.get();
        return ret != null && ret != false;
    }

    public GridFutureAdapter<?> disableCreateLuceneIndexForStringValueType(boolean disableCreateIdx) throws IgniteCheckedException {
        return this.disableCreateLuceneIndexForStringValueType.propagateAsync((Serializable)Boolean.valueOf(disableCreateIdx));
    }
}

