/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.IndexConditions;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class RexUtils {
    private static final Set<SqlKind> TREE_INDEX_COMPARISON = EnumSet.of(SqlKind.EQUALS, SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL);

    public static RexNode makeCast(RexBuilder builder, RexNode node, RelDataType type) {
        return TypeUtils.needCast(builder.getTypeFactory(), node.getType(), type) ? builder.makeCast(type, node) : node;
    }

    public static RexBuilder builder(RelNode rel) {
        return RexUtils.builder(rel.getCluster());
    }

    public static RexBuilder builder(RelOptCluster cluster) {
        return cluster.getRexBuilder();
    }

    public static RexExecutor executor(RelNode rel) {
        return RexUtils.executor(rel.getCluster());
    }

    public static RexExecutor executor(RelOptCluster cluster) {
        return (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
    }

    public static RexSimplify simplifier(RelOptCluster cluster) {
        return new RexSimplify(RexUtils.builder(cluster), RelOptPredicateList.EMPTY, RexUtils.executor(cluster));
    }

    public static RexNode makeCase(RexBuilder builder, RexNode ... operands) {
        if (U.assertionsEnabled()) {
            for (int i = 0; i < operands.length; i += 2) {
                if (operands[i].getType().getSqlTypeName() != SqlTypeName.BOOLEAN && i < operands.length - 1) {
                    throw new AssertionError((Object)("Unexpected operand type. [operands=" + Arrays.toString(operands) + "]"));
                }
            }
        }
        return builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, operands);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType) {
        return RexUtils.isIdentity(projects, inputRowType, false);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType, boolean local) {
        if (inputRowType.getFieldCount() != projects.size()) {
            return false;
        }
        List fields = inputRowType.getFieldList();
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (int i = 0; i < fields.size(); ++i) {
            if (!clazz.isInstance(projects.get(i))) {
                return false;
            }
            RexSlot ref = (RexSlot)projects.get(i);
            if (ref.getIndex() != i) {
                return false;
            }
            if (RelOptUtil.eq((String)"t1", (RelDataType)projects.get(i).getType(), (String)"t2", (RelDataType)((RelDataTypeField)fields.get(i)).getType(), (Litmus)Litmus.IGNORE)) continue;
            return false;
        }
        return true;
    }

    public static IndexConditions buildSortedIndexConditions(RelOptCluster cluster, RelCollation collation, RexNode condition, RelDataType rowType, ImmutableBitSet requiredColumns) {
        RelFieldCollation fc;
        int collFldIdx;
        List<RexCall> collFldPreds;
        if (condition == null) {
            return new IndexConditions();
        }
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Map<Integer, List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (F.isEmpty(fieldsToPredicates)) {
            return new IndexConditions();
        }
        ArrayList<RexNode> lower = new ArrayList<RexNode>();
        ArrayList<RexNode> upper = new ArrayList<RexNode>();
        if (collation == null || collation.isDefault()) {
            ArrayList equalsFields = new ArrayList(fieldsToPredicates.size());
            ArrayList otherFields = new ArrayList(fieldsToPredicates.size());
            fieldsToPredicates.forEach((idx, conds) -> (F.exist((Iterable)conds, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)call -> call.getOperator().getKind() == SqlKind.EQUALS}) ? equalsFields : otherFields).add(idx));
            collation = TraitUtils.createCollation(F.concat((boolean)true, equalsFields, otherFields));
        }
        for (int i = 0; i < collation.getFieldCollations().size() && !F.isEmpty(collFldPreds = fieldsToPredicates.get(collFldIdx = (fc = (RelFieldCollation)collation.getFieldCollations().get(i)).getFieldIndex())); ++i) {
            RexCall bestUpper = null;
            RexCall bestLower = null;
            for (RexCall pred : collFldPreds) {
                if (U.assertionsEnabled()) {
                    RexNode cond = RexUtil.removeCast((RexNode)((RexNode)pred.operands.get(1)));
                    assert (RexUtils.idxOpSupports(cond)) : cond;
                }
                boolean lowerBoundBelow = !fc.getDirection().isDescending();
                SqlOperator op = pred.getOperator();
                switch (op.kind) {
                    case EQUALS: {
                        bestUpper = pred;
                        bestLower = pred;
                        break;
                    }
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        lowerBoundBelow = !lowerBoundBelow;
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        if (lowerBoundBelow) {
                            bestLower = pred;
                            break;
                        }
                        bestUpper = pred;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown condition: " + op.kind));
                    }
                }
                if (bestUpper == null || bestLower == null) continue;
                break;
            }
            if (bestLower == null && bestUpper == null) break;
            if (bestLower != null && bestUpper != null) {
                upper.add((RexNode)bestUpper);
                lower.add((RexNode)bestLower);
                if (bestLower == bestUpper) continue;
                break;
            }
            if (bestLower != null) {
                lower.add((RexNode)bestLower);
                break;
            }
            upper.add((RexNode)bestUpper);
            break;
        }
        Mappings.TargetMapping mapping = null;
        if (requiredColumns != null) {
            mapping = Commons.inverseMapping(requiredColumns, rowType.getFieldCount());
        }
        List<RexNode> lowerBound = null;
        List<RexNode> upperBound = null;
        if (!F.isEmpty(lower)) {
            lowerBound = RexUtils.asBound(cluster, lower, rowType, mapping);
        } else {
            lower = null;
        }
        if (!F.isEmpty(upper)) {
            upperBound = RexUtils.asBound(cluster, upper, rowType, mapping);
        } else {
            upper = null;
        }
        return new IndexConditions(lower, upper, lowerBound, upperBound);
    }

    public static List<RexNode> buildHashSearchRow(RelOptCluster cluster, RexNode condition, RelDataType rowType, ImmutableBitSet requiredColumns, boolean ignoreNotEqualPreds) {
        int fldIdx;
        List<RexCall> collFldPreds;
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Map<Integer, List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (F.isEmpty(fieldsToPredicates)) {
            return null;
        }
        ArrayList<RexCall> searchPreds = null;
        Iterator<Integer> iterator = fieldsToPredicates.keySet().iterator();
        while (iterator.hasNext() && !F.isEmpty(collFldPreds = fieldsToPredicates.get(fldIdx = iterator.next().intValue()))) {
            for (RexCall pred : collFldPreds) {
                if (U.assertionsEnabled()) {
                    RexNode cond = RexUtil.removeCast((RexNode)((RexNode)pred.operands.get(1)));
                    assert (RexUtils.idxOpSupports(cond)) : cond;
                }
                if (pred.getOperator().kind != SqlKind.EQUALS) {
                    if (ignoreNotEqualPreds) continue;
                    return null;
                }
                if (searchPreds == null) {
                    searchPreds = new ArrayList<RexCall>();
                }
                searchPreds.add(pred);
            }
        }
        if (searchPreds == null) {
            return null;
        }
        Mappings.TargetMapping mapping = null;
        if (requiredColumns != null) {
            mapping = Commons.inverseMapping(requiredColumns, rowType.getFieldCount());
        }
        return RexUtils.asBound(cluster, searchPreds, rowType, mapping);
    }

    private static Map<Integer, List<RexCall>> mapPredicatesToFields(RexNode condition, RelOptCluster cluster) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)condition);
        HashMap<Integer, List<RexCall>> res = new HashMap<Integer, List<RexCall>>(conjunctions.size());
        for (RexNode rexNode : conjunctions) {
            RexCall predCall;
            RexSlot ref;
            if (!RexUtils.isBinaryComparison(rexNode) || (ref = (RexSlot)RexUtils.extractRef(predCall = (RexCall)rexNode)) == null) continue;
            if (RexUtils.refOnTheRight(predCall)) {
                predCall = (RexCall)RexUtil.invert((RexBuilder)RexUtils.builder(cluster), (RexCall)predCall);
            }
            List fldPreds = res.computeIfAbsent(ref.getIndex(), k -> new ArrayList(conjunctions.size()));
            fldPreds.add(predCall);
        }
        return res;
    }

    private static RexNode extractRef(RexCall call) {
        assert (RexUtils.isBinaryComparison((RexNode)call));
        RexNode leftOp = (RexNode)call.getOperands().get(0);
        RexNode rightOp = (RexNode)call.getOperands().get(1);
        leftOp = RexUtil.removeCast((RexNode)leftOp);
        rightOp = RexUtil.removeCast((RexNode)rightOp);
        if ((leftOp instanceof RexLocalRef || leftOp instanceof RexInputRef) && RexUtils.idxOpSupports(rightOp)) {
            return leftOp;
        }
        if ((rightOp instanceof RexLocalRef || rightOp instanceof RexInputRef) && RexUtils.idxOpSupports(leftOp)) {
            return rightOp;
        }
        return null;
    }

    private static boolean refOnTheRight(RexCall predCall) {
        RexNode rightOp = (RexNode)predCall.getOperands().get(1);
        return (rightOp = RexUtil.removeCast((RexNode)rightOp)).isA(SqlKind.LOCAL_REF) || rightOp.isA(SqlKind.INPUT_REF);
    }

    public static boolean isBinaryComparison(RexNode exp) {
        return TREE_INDEX_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall && ((RexCall)exp).getOperands().size() == 2;
    }

    private static boolean idxOpSupports(RexNode op) {
        return op instanceof RexLiteral || op instanceof RexDynamicParam || op instanceof RexFieldAccess;
    }

    public static boolean isNotNull(RexNode op) {
        if (op == null) {
            return false;
        }
        return !(op instanceof RexLiteral) || !((RexLiteral)op).isNull();
    }

    public static List<RexNode> asBound(RelOptCluster cluster, Iterable<RexNode> idxCond, RelDataType rowType, @Nullable Mappings.TargetMapping mapping) {
        if (F.isEmpty(idxCond)) {
            return null;
        }
        RexBuilder builder = RexUtils.builder(cluster);
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        List<RexNode> res = Arrays.asList(new RexNode[types.size()]);
        for (RexNode pred : idxCond) {
            int index;
            assert (pred instanceof RexCall);
            RexCall call = (RexCall)pred;
            RexSlot ref = (RexSlot)RexUtil.removeCast((RexNode)((RexNode)call.operands.get(0)));
            RexNode cond = RexUtil.removeCast((RexNode)((RexNode)call.operands.get(1)));
            assert (RexUtils.idxOpSupports(cond)) : cond;
            int n = index = mapping == null ? ref.getIndex() : mapping.getSourceOpt(ref.getIndex());
            assert (index != -1);
            res.set(index, RexUtils.makeCast(builder, cond, (RelDataType)types.get(index)));
        }
        return res;
    }

    public static Mappings.TargetMapping inversePermutation(List<RexNode> nodes, RelDataType inputRowType, boolean local) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)nodes.size(), (int)inputRowType.getFieldCount());
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (Ord node : Ord.zip(nodes)) {
            if (!clazz.isInstance(node.e)) continue;
            mapping.set(node.i, ((RexSlot)node.e).getIndex());
        }
        return mapping;
    }

    public static List<RexNode> replaceLocalRefs(List<RexNode> nodes) {
        return LocalRefReplacer.INSTANCE.apply(nodes);
    }

    public static List<RexNode> replaceInputRefs(List<RexNode> nodes) {
        return InputRefReplacer.INSTANCE.apply(nodes);
    }

    public static RexNode replaceLocalRefs(RexNode node) {
        return LocalRefReplacer.INSTANCE.apply(node);
    }

    public static RexNode replaceInputRefs(RexNode node) {
        return InputRefReplacer.INSTANCE.apply(node);
    }

    public static boolean hasCorrelation(RexNode node) {
        return RexUtils.hasCorrelation(Collections.singletonList(node));
    }

    public static boolean hasCorrelation(List<RexNode> nodes) {
        try {
            RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

                public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                    throw new ControlFlowException();
                }
            };
            nodes.forEach(arg_0 -> RexUtils.lambda$hasCorrelation$2((RexVisitor)v, arg_0));
            return false;
        }
        catch (ControlFlowException e) {
            return true;
        }
    }

    public static Set<CorrelationId> extractCorrelationIds(RexNode node) {
        if (node == null) {
            return Collections.emptySet();
        }
        return RexUtils.extractCorrelationIds(Collections.singletonList(node));
    }

    public static Set<Integer> notNullKeys(List<RexNode> row) {
        if (F.isEmpty(row)) {
            return Collections.emptySet();
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < row.size(); ++i) {
            if (!RexUtils.isNotNull(row.get(i))) continue;
            keys.add(i);
        }
        return keys;
    }

    public static double doubleFromRex(RexNode n, double def) {
        try {
            if (n.isA(SqlKind.LITERAL)) {
                return (Double)((RexLiteral)n).getValueAs(Double.class);
            }
            return def;
        }
        catch (Exception e) {
            assert (false) : "Unable to extract value: " + e.getMessage();
            return def;
        }
    }

    public static Set<CorrelationId> extractCorrelationIds(List<RexNode> nodes) {
        final HashSet<CorrelationId> cors = new HashSet<CorrelationId>();
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                cors.add(correlVariable.id);
                return null;
            }
        };
        nodes.forEach(arg_0 -> RexUtils.lambda$extractCorrelationIds$3((RexVisitor)v, arg_0));
        return cors;
    }

    private static /* synthetic */ void lambda$extractCorrelationIds$3(RexVisitor v, RexNode rex) {
        Void cfr_ignored_0 = (Void)rex.accept(v);
    }

    private static /* synthetic */ void lambda$hasCorrelation$2(RexVisitor v, RexNode n) {
        Void cfr_ignored_0 = (Void)n.accept(v);
    }

    private static class InputRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new InputRefReplacer();

        private InputRefReplacer() {
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return new RexLocalRef(inputRef.getIndex(), inputRef.getType());
        }
    }

    private static class LocalRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new LocalRefReplacer();

        private LocalRefReplacer() {
        }

        public RexNode visitLocalRef(RexLocalRef inputRef) {
            return new RexInputRef(inputRef.getIndex(), inputRef.getType());
        }
    }
}

