/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IndexConditions {
    private final List<RexNode> lowerCond;
    private final List<RexNode> upperCond;
    private final List<RexNode> lowerBound;
    private final List<RexNode> upperBound;

    public IndexConditions() {
        this(null, null, null, null);
    }

    public IndexConditions(@Nullable List<RexNode> lowerCond, @Nullable List<RexNode> upperCond, @Nullable List<RexNode> lowerBound, @Nullable List<RexNode> upperBound) {
        this.lowerCond = lowerCond;
        this.upperCond = upperCond;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public IndexConditions(RelInput input) {
        this.lowerCond = null;
        this.upperCond = null;
        this.lowerBound = input.get("lower") == null ? null : input.getExpressionList("lower");
        this.upperBound = input.get("upper") == null ? null : input.getExpressionList("upper");
    }

    public List<RexNode> lowerCondition() {
        return this.lowerCond;
    }

    public List<RexNode> upperCondition() {
        return this.upperCond;
    }

    public List<RexNode> lowerBound() {
        return this.lowerBound;
    }

    public List<RexNode> upperBound() {
        return this.upperBound;
    }

    public Set<Integer> keys() {
        if (this.upperBound == null && this.lowerBound == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        int cols = this.lowerBound != null ? this.lowerBound.size() : this.upperBound.size();
        for (int i = 0; i < cols; ++i) {
            if ((this.upperBound == null || !RexUtils.isNotNull(this.upperBound.get(i))) && (this.lowerBound == null || !RexUtils.isNotNull(this.lowerBound.get(i)))) continue;
            keys.add(i);
        }
        return Collections.unmodifiableSet(keys);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw.itemIf("lower", this.lowerBound, !F.isEmpty(this.lowerBound)).itemIf("upper", this.upperBound, !F.isEmpty(this.upperBound));
    }

    public String toString() {
        return S.toString(IndexConditions.class, (Object)this, (String)"lower", this.lowerCond, (String)"upper", this.upperCond, (String)"lowerBound", this.lowerBound, (String)"upperBound", this.upperBound);
    }
}

