/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

class ConvertingClosableIterator<Row>
implements Iterator<List<?>>,
AutoCloseable {
    private final Iterator<Row> it;
    private final RowHandler<Row> rowHnd;

    public ConvertingClosableIterator(Iterator<Row> it, ExecutionContext<Row> ectx) {
        this.it = it;
        this.rowHnd = ectx.rowHandler();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public List<Object> next() {
        Row next = this.it.next();
        int rowSize = this.rowHnd.columnCount(next);
        ArrayList<Object> res = new ArrayList<Object>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            res.add(this.rowHnd.get(i, next));
        }
        return res;
    }

    @Override
    public void close() throws Exception {
        Commons.close(this.it);
    }
}

