/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.TableScan;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteStatisticsImpl;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheTableImpl
extends AbstractTable
implements IgniteCacheTable {
    private final CacheTableDescriptor desc;
    private final GridKernalContext ctx;
    private final Map<String, IgniteIndex> indexes = new ConcurrentHashMap<String, IgniteIndex>();
    private volatile boolean idxRebuildInProgress;

    public CacheTableImpl(GridKernalContext ctx, CacheTableDescriptor desc) {
        this.ctx = ctx;
        this.desc = desc;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, ImmutableBitSet requiredColumns) {
        return this.desc.rowType((IgniteTypeFactory)typeFactory, requiredColumns);
    }

    public Statistic getStatistic() {
        String tblName = this.desc.typeDescription().tableName();
        String schemaName = this.desc.typeDescription().schemaName();
        ObjectStatisticsImpl statistics = (ObjectStatisticsImpl)this.ctx.query().statsManager().getLocalStatistics(new StatisticsKey(schemaName, tblName));
        if (statistics != null) {
            return new IgniteStatisticsImpl(statistics);
        }
        return new IgniteStatisticsImpl(this.desc);
    }

    @Override
    public CacheTableDescriptor descriptor() {
        return this.desc;
    }

    @Override
    public IgniteLogicalTableScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return IgniteLogicalTableScan.create(cluster, cluster.traitSet(), relOptTbl, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup group, Predicate<Row> filter, Function<Row, Row> rowTransformer, @Nullable ImmutableBitSet usedColumns) {
        UUID localNodeId = execCtx.localNodeId();
        if (group.nodeIds().contains(localNodeId)) {
            return new TableScan<Row>(execCtx, this.desc, group.partitions(localNodeId), filter, rowTransformer, usedColumns);
        }
        return Collections.emptyList();
    }

    @Override
    public IgniteDistribution distribution() {
        return this.desc.distribution();
    }

    @Override
    public ColocationGroup colocationGroup(MappingQueryContext ctx) {
        return this.desc.colocationGroup(ctx);
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public void addIndex(IgniteIndex idxTbl) {
        this.indexes.put(idxTbl.name(), idxTbl);
    }

    @Override
    public IgniteIndex getIndex(String idxName) {
        return this.indexes.get(idxName);
    }

    @Override
    public void removeIndex(String idxName) {
        this.indexes.remove(idxName);
    }

    @Override
    public void markIndexRebuildInProgress(boolean mark) {
        this.idxRebuildInProgress = mark;
    }

    @Override
    public boolean isIndexRebuildInProgress() {
        return this.idxRebuildInProgress;
    }

    public <C> C unwrap(Class<C> aCls) {
        if (aCls.isInstance(this.desc)) {
            return aCls.cast(this.desc);
        }
        return (C)super.unwrap(aCls);
    }

    @Override
    public void ensureCacheStarted() {
        if (this.desc.cacheContext() == null) {
            try {
                this.ctx.cache().dynamicStartCache(null, this.desc.cacheInfo().config().getName(), null, false, true, true).get();
            }
            catch (IgniteCheckedException ex) {
                throw U.convertException((IgniteCheckedException)ex);
            }
        }
    }

    @Override
    public boolean isModifiable() {
        return true;
    }
}

