/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectableFilterableTableScan
extends TableScan {
    protected final RexNode condition;
    protected final List<RexNode> projects;
    protected final ImmutableBitSet requiredColumns;

    protected ProjectableFilterableTableScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet reqColumns) {
        super(cluster, traitSet, hints, table);
        this.projects = proj;
        this.condition = cond;
        this.requiredColumns = reqColumns;
    }

    protected ProjectableFilterableTableScan(RelInput input) {
        super(input);
        this.condition = input.getExpression("filters");
        this.projects = input.get("projects") == null ? null : input.getExpressionList("projects");
        this.requiredColumns = input.get("requiredColumns") == null ? null : input.getBitSet("requiredColumns");
    }

    public List<RexNode> projects() {
        return this.projects;
    }

    public RexNode condition() {
        return this.condition;
    }

    public ImmutableBitSet requiredColumns() {
        return this.requiredColumns;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return this.explainTerms0(super.explainTerms(pw));
    }

    protected RelWriter explainTerms0(RelWriter pw) {
        return pw.itemIf("filters", (Object)this.condition, this.condition != null).itemIf("projects", this.projects, this.projects != null).itemIf("requiredColumns", (Object)this.requiredColumns, this.requiredColumns != null);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rows = this.table.getRowCount();
        double cost = rows * 1.0;
        if (this.condition != null) {
            cost += rows * 3.0;
        }
        return planner.getCostFactory().makeCost(rows, cost, 0.0);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.table.getRowCount() * mq.getSelectivity((RelNode)this, null);
    }

    public RelDataType deriveRowType() {
        if (this.projects != null) {
            return RexUtil.createStructType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()), this.projects);
        }
        return ((IgniteTable)this.table.unwrap(IgniteTable.class)).getRowType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()), this.requiredColumns);
    }

    public RexNode pushUpPredicate() {
        if (this.condition == null || this.projects == null) {
            return RexUtils.replaceLocalRefs(this.condition);
        }
        IgniteTypeFactory typeFactory = Commons.typeFactory(this.getCluster());
        IgniteTable tbl = (IgniteTable)this.getTable().unwrap(IgniteTable.class);
        final Mappings.TargetMapping mapping = RexUtils.inversePermutation(this.projects, tbl.getRowType((RelDataTypeFactory)typeFactory, this.requiredColumns), true);
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitLocalRef(RexLocalRef ref) {
                int targetRef = mapping.getSourceOpt(ref.getIndex());
                if (targetRef == -1) {
                    throw new ControlFlowException();
                }
                return new RexInputRef(targetRef, ref.getType());
            }
        };
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>();
        for (RexNode conjunction : RelOptUtil.conjunctions((RexNode)this.condition)) {
            try {
                conjunctions.add(shuttle.apply(conjunction));
            }
            catch (ControlFlowException controlFlowException) {}
        }
        return RexUtil.composeConjunction((RexBuilder)RexUtils.builder(this.getCluster()), conjunctions, (boolean)true);
    }

    public RelColumnOrigin columnOriginsByRelLocalRef(int colIdx) {
        int originColIdx = this.requiredColumns() == null ? colIdx : this.requiredColumns().toArray()[colIdx];
        return new RelColumnOrigin(this.getTable(), originColIdx, false);
    }
}

