/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;

public class IgniteProject
extends Project
implements TraitsAwareIgniteRel {
    public IgniteProject(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, (List)ImmutableList.of(), input, projects, rowType);
    }

    public IgniteProject(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new IgniteProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        int key;
        int src;
        RelTraitSet in = inputTraits.get(0);
        IgniteDistribution distribution = TraitUtils.distribution(nodeTraits);
        if (distribution.getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)in.replace((RelTrait)distribution)));
        }
        Mappings.TargetMapping mapping = IgniteProject.getPartialMapping((int)this.input.getRowType().getFieldCount(), (List)this.getProjects());
        ImmutableIntList keys = distribution.getKeys();
        ArrayList<Integer> srcKeys = new ArrayList<Integer>(keys.size());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext() && (src = mapping.getSourceOpt(key = ((Integer)iterator.next()).intValue())) != -1) {
            srcKeys.add(src);
        }
        if (srcKeys.size() == keys.size()) {
            return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)in.replace((RelTrait)IgniteDistributions.hash(srcKeys, distribution.function()))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), (Object)ImmutableList.of((Object)in.replace((RelTrait)IgniteDistributions.single())));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelFieldCollation inFieldCollation;
        Integer newIndex;
        RelTraitSet in = inputTraits.get(0);
        List fieldCollations = TraitUtils.collation(nodeTraits).getFieldCollations();
        if (fieldCollations.isEmpty()) {
            return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)in.replace((RelTrait)RelCollations.EMPTY)));
        }
        HashMap<Integer, Integer> targets = new HashMap<Integer, Integer>();
        for (Ord project : Ord.zip((List)this.getProjects())) {
            if (!(project.e instanceof RexInputRef)) continue;
            targets.putIfAbsent(project.i, ((RexInputRef)project.e).getIndex());
        }
        ArrayList<RelFieldCollation> inFieldCollations = new ArrayList<RelFieldCollation>();
        Iterator iterator = fieldCollations.iterator();
        while (iterator.hasNext() && (newIndex = (Integer)targets.get((inFieldCollation = (RelFieldCollation)iterator.next()).getFieldIndex())) != null) {
            inFieldCollations.add(inFieldCollation.withFieldIndex(newIndex.intValue()));
        }
        if (inFieldCollations.size() == fieldCollations.size()) {
            return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)in.replace((RelTrait)RelCollations.of(inFieldCollations))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), (Object)ImmutableList.of((Object)in.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        RewindabilityTrait rewindability = TraitUtils.rewindability(in);
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)rewindability), (Object)ImmutableList.of((Object)in)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        IgniteDistribution distribution = TraitUtils.projectDistribution(TraitUtils.distribution(in), this.getProjects(), this.getInput().getRowType());
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)distribution), (Object)ImmutableList.of((Object)in)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        RelCollation collation = TraitUtils.projectCollation(TraitUtils.collation(in), this.getProjects(), this.getInput().getRowType());
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)collation), (Object)ImmutableList.of((Object)in)));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(this.getProjects());
        Set<CorrelationId> traitCorrIds = TraitUtils.correlation(nodeTraits).correlationIds();
        if (!traitCorrIds.containsAll(corrIds)) {
            return null;
        }
        return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)inTraits.get(0).replace((RelTrait)TraitUtils.correlation(nodeTraits))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(this.getProjects());
        corrIds.addAll(TraitUtils.correlation(inTraits.get(0)).correlationIds());
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(corrIds)), inTraits));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.getInput());
        return planner.getCostFactory().makeCost(rowCount, rowCount * 1.0, 0.0);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteProject(cluster, this.getTraitSet(), (RelNode)IgniteProject.sole(inputs), this.getProjects(), this.getRowType());
    }
}

