/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare.ddl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlDropTable;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseDataContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgnitePlanner;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.ValidationResult;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.AlterTableAddCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.AlterTableDropCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.ColumnDefinition;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.DdlCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.DropTableCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.SqlToNativeCommandConverter;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.TransactionCommand;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlAlterTableAddColumn;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlAlterTableDropColumn;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCommit;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTable;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTableOption;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTableOptionEnum;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlRollback;
import org.apache.ignite.internal.processors.query.calcite.type.OtherType;
import org.apache.ignite.internal.processors.query.calcite.util.PlanUtils;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.F;

public class DdlSqlToCommandConverter {
    private static final BiFunction<IgniteSqlCreateTableOption, PlanningContext, String> VALUE_IS_IDENTIFIER_VALIDATOR = (opt, ctx) -> {
        if (!(opt.value() instanceof SqlIdentifier) || !((SqlIdentifier)opt.value()).isSimple()) {
            DdlSqlToCommandConverter.throwOptionParsingException(opt, "a simple identifier", ctx.query());
        }
        return ((SqlIdentifier)opt.value()).getSimple();
    };
    private static final TableOptionProcessor<Void> UNSUPPORTED_OPTION_PROCESSOR = new TableOptionProcessor(null, (opt, ctx) -> {
        throw new AssertionError((Object)("Unsupported option " + opt.key()));
    }, null);
    private final Map<IgniteSqlCreateTableOptionEnum, TableOptionProcessor<?>> tblOptionProcessors = Stream.of(new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.TEMPLATE, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::templateName), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.AFFINITY_KEY, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::affinityKey), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.CACHE_GROUP, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::cacheGroup), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.CACHE_NAME, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::cacheName), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.DATA_REGION, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::dataRegionName), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.KEY_TYPE, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::keyTypeName), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.VALUE_TYPE, VALUE_IS_IDENTIFIER_VALIDATOR, CreateTableCommand::valueTypeName), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.ATOMICITY, DdlSqlToCommandConverter.validatorForEnumValue(CacheAtomicityMode.class), CreateTableCommand::atomicityMode), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.WRITE_SYNCHRONIZATION_MODE, DdlSqlToCommandConverter.validatorForEnumValue(CacheWriteSynchronizationMode.class), CreateTableCommand::writeSynchronizationMode), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.BACKUPS, (opt, ctx) -> {
        if (opt.value() instanceof SqlIdentifier) {
            String val = VALUE_IS_IDENTIFIER_VALIDATOR.apply((IgniteSqlCreateTableOption)((Object)opt), (PlanningContext)ctx);
            try {
                int intVal = Integer.parseInt(val);
                if (intVal < 0) {
                    DdlSqlToCommandConverter.throwOptionParsingException(opt, "a non-negative integer", ctx.query());
                }
                return intVal;
            }
            catch (NumberFormatException e) {
                DdlSqlToCommandConverter.throwOptionParsingException(opt, "a non-negative integer", ctx.query());
            }
        }
        if (!(opt.value() instanceof SqlNumericLiteral) || !((SqlNumericLiteral)opt.value()).isInteger() || ((SqlLiteral)opt.value()).intValue(true) < 0) {
            DdlSqlToCommandConverter.throwOptionParsingException(opt, "a non-negative integer", ctx.query());
        }
        return ((SqlLiteral)opt.value()).intValue(true);
    }, CreateTableCommand::backups), new TableOptionProcessor(IgniteSqlCreateTableOptionEnum.ENCRYPTED, (opt, ctx) -> {
        if (opt.value() instanceof SqlIdentifier) {
            String val = VALUE_IS_IDENTIFIER_VALIDATOR.apply((IgniteSqlCreateTableOption)((Object)opt), (PlanningContext)ctx);
            return Boolean.parseBoolean(val);
        }
        if (!(opt.value() instanceof SqlLiteral) && ((SqlLiteral)opt.value()).getTypeName() != SqlTypeName.BOOLEAN) {
            DdlSqlToCommandConverter.throwOptionParsingException(opt, "a boolean", ctx.query());
        }
        return ((SqlLiteral)opt.value()).booleanValue();
    }, CreateTableCommand::encrypted)).collect(Collectors.toMap(rec$ -> TableOptionProcessor.access$200((TableOptionProcessor)rec$), Function.identity()));

    public DdlCommand convert(SqlDdl ddlNode, PlanningContext ctx) {
        if (ddlNode instanceof IgniteSqlCreateTable) {
            return this.convertCreateTable((IgniteSqlCreateTable)ddlNode, ctx);
        }
        if (ddlNode instanceof SqlDropTable) {
            return this.convertDropTable((SqlDropTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableAddColumn) {
            return this.convertAlterTableAdd((IgniteSqlAlterTableAddColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropColumn) {
            return this.convertAlterTableDrop((IgniteSqlAlterTableDropColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCommit || ddlNode instanceof IgniteSqlRollback) {
            return new TransactionCommand();
        }
        if (SqlToNativeCommandConverter.isSupported((SqlNode)ddlNode)) {
            return SqlToNativeCommandConverter.convert(ddlNode, ctx);
        }
        throw new IgniteSQLException("Unsupported operation [sqlNodeKind=" + ddlNode.getKind() + "; querySql=\"" + ctx.query() + "\"]", 1002);
    }

    private CreateTableCommand convertCreateTable(IgniteSqlCreateTable createTblNode, PlanningContext ctx) {
        CreateTableCommand createTblCmd = new CreateTableCommand();
        String schemaName = PlanUtils.deriveSchemaName(createTblNode.name(), ctx);
        String tableName = PlanUtils.deriveObjectName(createTblNode.name(), ctx, "tableName");
        createTblCmd.schemaName(schemaName);
        createTblCmd.tableName(tableName);
        createTblCmd.ifNotExists(createTblNode.ifNotExists());
        createTblCmd.templateName("PARTITIONED");
        if (createTblNode.createOptionList() != null) {
            for (SqlNode optNode : createTblNode.createOptionList().getList()) {
                IgniteSqlCreateTableOption opt = (IgniteSqlCreateTableOption)optNode;
                ((TableOptionProcessor)this.tblOptionProcessors.getOrDefault(opt.key(), DdlSqlToCommandConverter.UNSUPPORTED_OPTION_PROCESSOR)).process(opt, ctx, createTblCmd);
            }
        }
        IgnitePlanner planner = ctx.planner();
        if (createTblNode.query() == null) {
            List colDeclarations = createTblNode.columnList().getList().stream().filter(SqlColumnDeclaration.class::isInstance).map(SqlColumnDeclaration.class::cast).collect(Collectors.toList());
            ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>();
            for (SqlColumnDeclaration col : colDeclarations) {
                if (!col.name.isSimple()) {
                    throw new IgniteSQLException("Unexpected value of columnName [expected a simple identifier, but was " + col.name + "; querySql=\"" + ctx.query() + "\"]", 1001);
                }
                String name = col.name.getSimple();
                RelDataType type = planner.convert(col.dataType);
                Object dflt = null;
                if (col.expression != null) {
                    assert (col.expression instanceof SqlLiteral);
                    Type storageType = ctx.typeFactory().getResultClass(type);
                    BaseDataContext dataCtx = new BaseDataContext(ctx.typeFactory());
                    if (type instanceof OtherType) {
                        throw new IgniteSQLException("Type '" + type + "' doesn't support default value.");
                    }
                    dflt = TypeUtils.fromLiteral(dataCtx, storageType, (SqlLiteral)col.expression);
                }
                cols.add(new ColumnDefinition(name, type, dflt));
            }
            createTblCmd.columns(cols);
            List pkConstraints = createTblNode.columnList().getList().stream().filter(SqlKeyConstraint.class::isInstance).map(SqlKeyConstraint.class::cast).collect(Collectors.toList());
            if (pkConstraints.size() > 1) {
                throw new IgniteSQLException("Unexpected amount of primary key constraints [expected at most one, but was " + pkConstraints.size() + "; querySql=\"" + ctx.query() + "\"]", 1001);
            }
            if (!F.isEmpty(pkConstraints)) {
                HashSet dedupSet = new HashSet();
                List<String> pkCols = pkConstraints.stream().map(pk -> (SqlNode)pk.getOperandList().get(1)).map(SqlNodeList.class::cast).flatMap(l -> l.getList().stream()).map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).filter(dedupSet::add).collect(Collectors.toList());
                createTblCmd.primaryKeyColumns(pkCols);
            }
        } else {
            ValidationResult res = planner.validateAndGetTypeMetadata(createTblNode.query());
            SqlInsert sqlInsert = new SqlInsert(createTblNode.query().getParserPosition(), SqlNodeList.EMPTY, (SqlNode)createTblNode.name(), res.sqlNode(), null);
            createTblCmd.insertStatement(sqlInsert);
            List fields = res.dataType().getFieldList();
            ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>(fields.size());
            if (createTblNode.columnList() != null) {
                List colNames = createTblNode.columnList().getList().stream().map(SqlIdentifier.class::cast).collect(Collectors.toList());
                if (fields.size() != colNames.size()) {
                    throw new IgniteSQLException("Number of columns must match number of query columns", 1001);
                }
                for (int i = 0; i < colNames.size(); ++i) {
                    SqlIdentifier colName = (SqlIdentifier)colNames.get(i);
                    assert (colName.isSimple());
                    RelDataType type = ((RelDataTypeField)fields.get(i)).getType();
                    cols.add(new ColumnDefinition(colName.getSimple(), type, null));
                }
            } else {
                for (RelDataTypeField field : fields) {
                    cols.add(new ColumnDefinition(field.getName(), field.getType(), null));
                }
            }
            createTblCmd.columns(cols);
        }
        if (createTblCmd.columns() == null) {
            throw new IgniteSQLException("Column list or query should be specified for CREATE TABLE command", 1001);
        }
        return createTblCmd;
    }

    private DropTableCommand convertDropTable(SqlDropTable dropTblNode, PlanningContext ctx) {
        DropTableCommand dropTblCmd = new DropTableCommand();
        dropTblCmd.schemaName(PlanUtils.deriveSchemaName(dropTblNode.name, ctx));
        dropTblCmd.tableName(PlanUtils.deriveObjectName(dropTblNode.name, ctx, "tableName"));
        dropTblCmd.ifExists(dropTblNode.ifExists);
        return dropTblCmd;
    }

    private AlterTableAddCommand convertAlterTableAdd(IgniteSqlAlterTableAddColumn alterTblNode, PlanningContext ctx) {
        AlterTableAddCommand alterTblCmd = new AlterTableAddCommand();
        alterTblCmd.schemaName(PlanUtils.deriveSchemaName(alterTblNode.name(), ctx));
        alterTblCmd.tableName(PlanUtils.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        alterTblCmd.ifTableExists(alterTblNode.ifExists());
        alterTblCmd.ifColumnNotExists(alterTblNode.ifNotExistsColumn());
        ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>(alterTblNode.columns().size());
        for (SqlNode colNode : alterTblNode.columns()) {
            assert (colNode instanceof SqlColumnDeclaration) : colNode.getClass();
            SqlColumnDeclaration col = (SqlColumnDeclaration)colNode;
            assert (col.name.isSimple());
            String name = col.name.getSimple();
            RelDataType type = ctx.planner().convert(col.dataType);
            assert (col.expression == null) : "Unexpected column default value" + col.expression;
            cols.add(new ColumnDefinition(name, type, null));
        }
        alterTblCmd.columns(cols);
        return alterTblCmd;
    }

    private AlterTableDropCommand convertAlterTableDrop(IgniteSqlAlterTableDropColumn alterTblNode, PlanningContext ctx) {
        AlterTableDropCommand alterTblCmd = new AlterTableDropCommand();
        alterTblCmd.schemaName(PlanUtils.deriveSchemaName(alterTblNode.name(), ctx));
        alterTblCmd.tableName(PlanUtils.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        alterTblCmd.ifTableExists(alterTblNode.ifExists());
        alterTblCmd.ifColumnExists(alterTblNode.ifExistsColumn());
        ArrayList<String> cols = new ArrayList<String>(alterTblNode.columns().size());
        alterTblNode.columns().forEach(c -> cols.add(((SqlIdentifier)c).getSimple()));
        alterTblCmd.columns(cols);
        return alterTblCmd;
    }

    private String paramIsSqlIdentifierValidator(IgniteSqlCreateTableOption opt, PlanningContext ctx) {
        if (!(opt.value() instanceof SqlIdentifier) || !((SqlIdentifier)opt.value()).isSimple()) {
            DdlSqlToCommandConverter.throwOptionParsingException(opt, "a simple identifier", ctx.query());
        }
        return ((SqlIdentifier)opt.value()).getSimple();
    }

    private static <T extends Enum<T>> BiFunction<IgniteSqlCreateTableOption, PlanningContext, T> validatorForEnumValue(Class<T> clz) {
        return (opt, ctx) -> {
            Enum val = null;
            if (opt.value() instanceof SqlIdentifier) {
                val = Arrays.stream(clz.getEnumConstants()).filter(m -> m.name().equalsIgnoreCase(opt.value().toString())).findFirst().orElse(null);
            }
            if (val == null) {
                DdlSqlToCommandConverter.throwOptionParsingException(opt, "values are " + Arrays.toString(clz.getEnumConstants()), ctx.query());
            }
            return val;
        };
    }

    private static void throwOptionParsingException(IgniteSqlCreateTableOption opt, String exp, String qry) {
        throw new IgniteSQLException("Unexpected value for param " + opt.key() + " [expected " + exp + ", but was " + opt.value() + "; querySql=\"" + qry + "\"]", 1001);
    }

    private static class TableOptionProcessor<T> {
        private final IgniteSqlCreateTableOptionEnum key;
        private final BiFunction<IgniteSqlCreateTableOption, PlanningContext, T> validator;
        private final BiConsumer<CreateTableCommand, T> valSetter;

        private TableOptionProcessor(IgniteSqlCreateTableOptionEnum key, BiFunction<IgniteSqlCreateTableOption, PlanningContext, T> validator, BiConsumer<CreateTableCommand, T> valSetter) {
            this.key = key;
            this.validator = validator;
            this.valSetter = valSetter;
        }

        private void process(IgniteSqlCreateTableOption opt, PlanningContext ctx, CreateTableCommand cmd) {
            assert (this.key == null || this.key == opt.key()) : "Unexpected create table option [expected=" + (Object)((Object)this.key) + ", actual=" + opt.key() + "]";
            this.valSetter.accept(cmd, (CreateTableCommand)this.validator.apply(opt, ctx));
        }

        private IgniteSqlCreateTableOptionEnum key() {
            return this.key;
        }
    }
}

