/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.calcite.prepare.CacheKey;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlanCache;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.schema.AbstractSchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;

public class QueryPlanCacheImpl
extends AbstractService
implements QueryPlanCache {
    private static final int CACHE_SIZE = 1024;
    private GridInternalSubscriptionProcessor subscriptionProcessor;
    private volatile Map<CacheKey, QueryPlan> cache = new GridBoundedConcurrentLinkedHashMap(1024);

    public QueryPlanCacheImpl(GridKernalContext ctx) {
        super(ctx);
        this.subscriptionProcessor(ctx.internalSubscriptionProcessor());
        this.init();
    }

    public void subscriptionProcessor(GridInternalSubscriptionProcessor subscriptionProcessor) {
        this.subscriptionProcessor = subscriptionProcessor;
    }

    @Override
    public void init() {
        this.subscriptionProcessor.registerSchemaChangeListener((SchemaChangeListener)new SchemaListener());
    }

    @Override
    public void onStart(GridKernalContext ctx) {
    }

    @Override
    public QueryPlan queryPlan(CacheKey key, Supplier<QueryPlan> planSupplier) {
        Map<CacheKey, QueryPlan> cache = this.cache;
        QueryPlan plan = cache.computeIfAbsent(key, k -> (QueryPlan)planSupplier.get());
        return plan.copy();
    }

    @Override
    public QueryPlan queryPlan(CacheKey key) {
        Map<CacheKey, QueryPlan> cache = this.cache;
        QueryPlan plan = cache.get(key);
        return plan != null ? plan.copy() : null;
    }

    @Override
    public void clear() {
        this.cache = new GridBoundedConcurrentLinkedHashMap(1024);
    }

    private class SchemaListener
    extends AbstractSchemaChangeListener {
        private SchemaListener() {
        }

        public void onSchemaDropped(String schemaName) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onSqlTypeDropped(String schemaName, GridQueryTypeDescriptor typeDescriptor, boolean destroy) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onIndexCreated(String schemaName, String tblName, String idxName, IndexDescriptor idxDesc) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onIndexDropped(String schemaName, String tblName, String idxName) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onIndexRebuildStarted(String schemaName, String tblName) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onIndexRebuildFinished(String schemaName, String tblName) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onColumnsAdded(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<QueryField> cols) {
            QueryPlanCacheImpl.this.clear();
        }

        public void onColumnsDropped(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<String> cols) {
            QueryPlanCacheImpl.this.clear();
        }
    }
}

