/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.util.typedef.F;

public class TableSpoolNode<Row>
extends AbstractNode<Row>
implements SingleNode<Row>,
Downstream<Row> {
    private int requested;
    private int waiting;
    private int rowIdx;
    private final List<Row> rows;
    private final boolean lazyRead;
    private boolean inLoop;

    public TableSpoolNode(ExecutionContext<Row> ctx, RelDataType rowType, boolean lazyRead) {
        super(ctx, rowType);
        this.lazyRead = lazyRead;
        this.rows = new ArrayList<Row>();
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.rowIdx = 0;
    }

    @Override
    public void rewind() {
        this.rewindInternal();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0);
        this.checkState();
        this.requested += rowsCnt;
        if (!(this.waiting != -1 && this.rowIdx >= this.rows.size() || this.inLoop)) {
            this.context().execute(this::doPush, this::onError);
        } else if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        }
    }

    private void doPush() throws Exception {
        if (this.isClosed()) {
            return;
        }
        if (!this.lazyRead && this.waiting != -1) {
            return;
        }
        int processed = 0;
        this.inLoop = true;
        try {
            while (this.requested > 0 && this.rowIdx < this.rows.size() && processed++ < IN_BUFFER_SIZE) {
                this.downstream().push(this.rows.get(this.rowIdx));
                ++this.rowIdx;
                --this.requested;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.rowIdx >= this.rows.size() && this.waiting == -1 && this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        } else if (this.requested > 0 && processed >= IN_BUFFER_SIZE) {
            this.context().execute(this::doPush, this::onError);
        }
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.rows.add(row);
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        }
        if (this.requested > 0 && this.rowIdx < this.rows.size()) {
            this.doPush();
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.context().execute(this::doPush, this::onError);
    }
}

