/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.RunningQuery;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.query.calcite.QueryRegistry;
import org.apache.ignite.internal.processors.query.calcite.RootQuery;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.util.IgniteUtils;

public class QueryRegistryImpl
extends AbstractService
implements QueryRegistry {
    private final ConcurrentMap<UUID, RunningQuery> runningQrys = new ConcurrentHashMap<UUID, RunningQuery>();
    protected final GridKernalContext kctx;

    public QueryRegistryImpl(GridKernalContext ctx) {
        super(ctx);
        this.kctx = ctx;
    }

    @Override
    public RunningQuery register(RunningQuery qry) {
        return this.runningQrys.computeIfAbsent(qry.id(), k -> {
            if (!(qry instanceof RootQuery)) {
                return qry;
            }
            RootQuery rootQry = (RootQuery)qry;
            RunningQueryManager qryMgr = this.kctx.query().runningQueryManager();
            SqlFieldsQuery fieldsQry = rootQry.context().unwrap(SqlFieldsQuery.class);
            String initiatorId = fieldsQry != null ? fieldsQry.getQueryInitiatorId() : null;
            long locId = qryMgr.register(rootQry.sql(), GridCacheQueryType.SQL_FIELDS, rootQry.context().schemaName(), false, QueryRegistryImpl.createCancelToken(qry), initiatorId);
            rootQry.localQueryId(locId);
            return qry;
        });
    }

    @Override
    public RunningQuery query(UUID id) {
        return (RunningQuery)this.runningQrys.get(id);
    }

    @Override
    public void unregister(UUID id) {
        RunningQuery val = (RunningQuery)this.runningQrys.remove(id);
        if (val instanceof RootQuery) {
            this.kctx.query().runningQueryManager().unregister(((RootQuery)val).localQueryId(), null);
        }
    }

    @Override
    public Collection<? extends RunningQuery> runningQueries() {
        return this.runningQrys.values();
    }

    @Override
    public void tearDown() {
        this.runningQrys.values().forEach(q -> IgniteUtils.close(() -> ((RunningQuery)q).cancel(), (IgniteLogger)this.log));
        this.runningQrys.clear();
    }

    private static GridQueryCancel createCancelToken(RunningQuery qry) {
        GridQueryCancel token = new GridQueryCancel();
        try {
            token.add(() -> ((RunningQuery)qry).cancel());
        }
        catch (QueryCancelledException queryCancelledException) {
            // empty catch block
        }
        return token;
    }
}

